/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.bugtracking.BugtrackingRuntime;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BugtrackingManager
implements LookupListener {
    private static final BugtrackingManager instance = new BugtrackingManager();
    private boolean initialized;
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugracking.BugtrackingManager");
    private RequestProcessor rp = new RequestProcessor("Bugtracking manager");
    private final Collection<BugtrackingConnector> connectors = new ArrayList<BugtrackingConnector>(2);
    private final Lookup.Result<BugtrackingConnector> connectorsLookup = Lookup.getDefault().lookup(new Lookup.Template(BugtrackingConnector.class));
    private Map<String, List<RecentIssue>> recentIssues;

    public static BugtrackingManager getInstance() {
        instance.init();
        return instance;
    }

    private BugtrackingManager() {
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new ActivatedTCListener());
    }

    public Repository[] getKnownRepositories() {
        return this.getKnownRepositories(false);
    }

    public Repository[] getKnownRepositories(boolean bl) {
        Repository[] repositoryArray = KenaiRepositories.getInstance().getRepositories(bl);
        Repository[] repositoryArray2 = this.getRepositories();
        Repository[] repositoryArray3 = new Repository[repositoryArray.length + repositoryArray2.length];
        System.arraycopy(repositoryArray, 0, repositoryArray3, 0, repositoryArray.length);
        System.arraycopy(repositoryArray2, 0, repositoryArray3, repositoryArray.length, repositoryArray2.length);
        return repositoryArray3;
    }

    public Repository[] getRepositories() {
        BugtrackingConnector[] bugtrackingConnectorArray;
        ArrayList<Repository> arrayList = new ArrayList<Repository>(10);
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = this.getConnectors()) {
            Repository[] repositoryArray = bugtrackingConnector.getRepositories();
            if (repositoryArray == null) continue;
            for (Repository repository : repositoryArray) {
                arrayList.add(repository);
            }
        }
        return arrayList.toArray(new Repository[arrayList.size()]);
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.connectorsLookup.addLookupListener((LookupListener)this);
        this.refreshConnectors();
        BugtrackingRuntime.getInstance();
        LOG.fine("Bugtracking manager initialized");
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugtrackingConnector[] getConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            return this.connectors.toArray(new BugtrackingConnector[this.connectors.size()]);
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshConnectors();
    }

    public List<Issue> getRecentIssues(Repository repository) {
        assert (repository != null);
        List<RecentIssue> list = this.getRecentIssues().get(repository.getID());
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Issue> arrayList = new ArrayList<Issue>(list.size());
        for (RecentIssue recentIssue : list) {
            arrayList.add(recentIssue.getIssue());
        }
        return arrayList;
    }

    public void addRecentIssue(Repository repository, Issue issue) {
        assert (repository != null && issue != null);
        if (issue.getID() == null) {
            return;
        }
        List<RecentIssue> list = this.getRecentIssues().get(repository.getID());
        if (list == null) {
            list = new ArrayList<RecentIssue>();
            this.getRecentIssues().put(repository.getID(), list);
        }
        for (RecentIssue object : list) {
            if (!object.getIssue().getID().equals(issue.getID())) continue;
            list.remove(object);
            break;
        }
        if (list.size() == 5) {
            list.remove(4);
        }
        list.add(0, new RecentIssue(issue, System.currentTimeMillis()));
        if (LOG.isLoggable(Level.FINE)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (RecentIssue recentIssue : list) {
                LOG.fine("recent issue: [" + recentIssue.getIssue().getRepository().getDisplayName() + ", " + recentIssue.getIssue().getID() + ", " + simpleDateFormat.format(new Date(recentIssue.getTimestamp())) + "]");
            }
        }
    }

    public Map<String, List<RecentIssue>> getAllRecentIssues() {
        return Collections.unmodifiableMap(this.getRecentIssues());
    }

    private Map<String, List<RecentIssue>> getRecentIssues() {
        if (this.recentIssues == null) {
            this.recentIssues = new HashMap<String, List<RecentIssue>>();
        }
        return this.recentIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConnectors() {
        Collection collection = this.connectorsLookup.allInstances();
        if (LOG.isLoggable(Level.FINER)) {
            for (BugtrackingConnector bugtrackingConnector : collection) {
                LOG.finer("registered provider: " + bugtrackingConnector.getDisplayName());
            }
        }
        Collection<BugtrackingConnector> collection2 = this.connectors;
        synchronized (collection2) {
            this.connectors.clear();
            this.connectors.addAll(collection);
        }
    }

    private class ActivatedTCListener
    implements PropertyChangeListener {
        private ActivatedTCListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                TopComponent topComponent = registry.getActivated();
                LOG.finer("activated TC : " + topComponent);
                if (!(topComponent instanceof IssueTopComponent)) {
                    return;
                }
                IssueTopComponent issueTopComponent = (IssueTopComponent)topComponent;
                Issue issue = issueTopComponent.getIssue();
                LOG.fine("activated issue : " + issue);
                if (issue == null || issue.isNew()) {
                    return;
                }
                BugtrackingManager.this.addRecentIssue(issue.getRepository(), issue);
            }
        }
    }

    public class RecentIssue {
        private Issue issue;
        private long ts;

        public RecentIssue(Issue issue, long l) {
            this.issue = issue;
            this.ts = l;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public long getTimestamp() {
            return this.ts;
        }
    }
}

