/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{AntBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        if (!string.equals(AntBreakpoint.class.getName())) {
            return null;
        }
        Line line = this.getLine(properties.getString("url", null), properties.getInt("lineNumber", 1));
        if (line == null) {
            return null;
        }
        AntBreakpoint antBreakpoint = new AntBreakpoint(line);
        antBreakpoint.setGroupName(properties.getString("groupName", ""));
        int n = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = n > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        antBreakpoint.setHitCountFilter(n, hIT_COUNT_FILTERING_STYLE);
        if (properties.getBoolean("enabled", true)) {
            antBreakpoint.enable();
        } else {
            antBreakpoint.disable();
        }
        return antBreakpoint;
    }

    public void write(Object object, Properties properties) {
        AntBreakpoint antBreakpoint = (AntBreakpoint)((Object)object);
        FileObject fileObject = (FileObject)antBreakpoint.getLine().getLookup().lookup(FileObject.class);
        try {
            properties.setString("url", fileObject.getURL().toString());
            properties.setInt("lineNumber", antBreakpoint.getLine().getLineNumber());
            properties.setString("groupName", antBreakpoint.getGroupName());
            properties.setBoolean("enabled", antBreakpoint.isEnabled());
            properties.setInt("hitCountFilter", antBreakpoint.getHitCountFilter());
            Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = antBreakpoint.getHitCountFilteringStyle();
            properties.setInt("hitCountFilter_style", hIT_COUNT_FILTERING_STYLE != null ? hIT_COUNT_FILTERING_STYLE.ordinal() : 0);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileStateInvalidException.printStackTrace();
        }
    }

    private Line getLine(String string, int n) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

