/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public class CsmBaseUtilities {
    private static boolean TRACE_XREF_REPOSITORY = Boolean.getBoolean("cnd.modelimpl.trace.xref.repository");

    private CsmBaseUtilities() {
    }

    public static boolean isValid(CsmObject csmObject) {
        if (CsmKindUtilities.isValidable(csmObject)) {
            return ((CsmValidable)((Object)csmObject)).isValid();
        }
        return csmObject != null;
    }

    public static boolean isGlobalNamespace(CsmScope csmScope) {
        if (CsmKindUtilities.isNamespace(csmScope)) {
            return ((CsmNamespace)csmScope).isGlobal();
        }
        return false;
    }

    public static boolean isInlineFunction(CsmFunction csmFunction) {
        if (csmFunction.isInline()) {
            return true;
        }
        CsmScope csmScope = csmFunction.getScope();
        if (csmScope == null || CsmBaseUtilities.isGlobalNamespace(csmScope)) {
            return false;
        }
        CsmFunction csmFunction2 = CsmBaseUtilities.getFunctionDeclaration(csmFunction);
        if (csmFunction2 == null || !CsmKindUtilities.isMethod(csmFunction)) {
            return false;
        }
        return csmScope.equals(((CsmMethod)csmFunction2).getContainingClass());
    }

    public static boolean isStaticContext(CsmFunction csmFunction) {
        assert (csmFunction != null) : "must be not null";
        if (CsmKindUtilities.isGlobalFunction(csmFunction)) {
            return true;
        }
        CsmFunction csmFunction2 = CsmBaseUtilities.getFunctionDeclaration(csmFunction);
        if (CsmKindUtilities.isClassMember(csmFunction2)) {
            return ((CsmMember)((Object)csmFunction2)).isStatic();
        }
        return false;
    }

    public static CsmFunction getOperator(CsmClassifier csmClassifier, CsmFunction.OperatorKind operatorKind) {
        if (!CsmKindUtilities.isClass(csmClassifier)) {
            return null;
        }
        for (CsmMember csmMember : ((CsmClass)csmClassifier).getMembers()) {
            if (!CsmKindUtilities.isOperator(csmMember) || ((CsmFunction)((Object)csmMember)).getOperatorKind() != operatorKind) continue;
            return (CsmFunction)((Object)csmMember);
        }
        return null;
    }

    public static CsmObject[] getDefinitionDeclaration(CsmObject csmObject, boolean bl) {
        CsmObject csmObject2;
        CsmObject csmObject3;
        if (bl && CsmKindUtilities.isTemplateInstantiation(csmObject)) {
            csmObject = ((CsmInstantiation)csmObject).getTemplateDeclaration();
        }
        if (CsmKindUtilities.isVariableDefinition(csmObject)) {
            csmObject3 = ((CsmVariableDefinition)csmObject).getDeclaration();
            if (csmObject3 == null) {
                csmObject3 = csmObject;
                if (TRACE_XREF_REPOSITORY) {
                    System.err.println("not found declaration for variable definition " + csmObject);
                }
            }
            csmObject2 = csmObject;
        } else if (CsmKindUtilities.isVariableDeclaration(csmObject)) {
            csmObject3 = csmObject;
            csmObject2 = ((CsmVariable)csmObject).getDefinition();
        } else if (CsmKindUtilities.isFunctionDefinition(csmObject)) {
            csmObject3 = ((CsmFunctionDefinition)csmObject).getDeclaration();
            if (csmObject3 == null) {
                csmObject3 = csmObject;
                if (TRACE_XREF_REPOSITORY) {
                    System.err.println("not found declaration for function definition " + csmObject);
                }
            }
            csmObject2 = csmObject;
        } else if (CsmKindUtilities.isFunctionDeclaration(csmObject)) {
            csmObject3 = csmObject;
            csmObject2 = ((CsmFunction)csmObject).getDefinition();
        } else if (CsmKindUtilities.isClassForwardDeclaration(csmObject)) {
            CsmClassForwardDeclaration csmClassForwardDeclaration = (CsmClassForwardDeclaration)csmObject;
            if (csmClassForwardDeclaration.getCsmClass() != null) {
                csmObject3 = csmObject;
                csmObject2 = csmClassForwardDeclaration.getCsmClass();
            } else {
                csmObject3 = csmObject;
                csmObject2 = null;
            }
        } else if (CsmKindUtilities.isClass(csmObject)) {
            CsmClass csmClass = (CsmClass)csmObject;
            CsmClassifier csmClassifier = csmClass.getContainingFile().getProject().findClassifier(csmClass.getQualifiedName());
            if (csmClass.equals(csmClassifier)) {
                csmObject3 = csmObject;
                csmObject2 = null;
            } else if (csmClassifier != null) {
                csmObject3 = csmClassifier;
                csmObject2 = csmClass;
            } else {
                csmObject3 = csmObject;
                csmObject2 = null;
            }
        } else {
            csmObject3 = csmObject;
            csmObject2 = null;
        }
        assert (csmObject3 != null);
        return new CsmObject[]{csmObject3, csmObject2};
    }

    public static CsmClass getFunctionClass(CsmFunction csmFunction) {
        assert (csmFunction != null) : "must be not null";
        CsmClass csmClass = null;
        CsmFunction csmFunction2 = CsmBaseUtilities.getFunctionDeclaration(csmFunction);
        if (CsmKindUtilities.isClassMember(csmFunction2)) {
            csmClass = ((CsmMember)((Object)csmFunction2)).getContainingClass();
        }
        return csmClass;
    }

    public static CsmClass getFunctionClassByQualifiedName(CsmFunction csmFunction) {
        if (csmFunction != null) {
            String string = ((Object)csmFunction.getQualifiedName()).toString().replaceAll("(.*)::.*", "$1");
            CsmClassifier csmClassifier = CsmClassifierResolver.getDefault().findClassifierUsedInFile(string, csmFunction.getContainingFile(), false);
            if (CsmKindUtilities.isClassifier(csmClassifier)) {
                CsmClassifier csmClassifier2 = csmClassifier;
                csmClassifier2 = CsmClassifierResolver.getDefault().getOriginalClassifier(csmClassifier2, csmFunction.getContainingFile());
                if (CsmKindUtilities.isClass(csmClassifier2)) {
                    return (CsmClass)csmClassifier2;
                }
            }
        }
        return null;
    }

    public static CsmClass getObjectClass(CsmObject csmObject) {
        CsmScope csmScope;
        CsmClass csmClass = null;
        if (CsmKindUtilities.isFunction(csmObject)) {
            csmClass = CsmBaseUtilities.getFunctionClass((CsmFunction)csmObject);
        } else if (CsmKindUtilities.isClass(csmObject)) {
            csmClass = (CsmClass)csmObject;
        } else if (CsmKindUtilities.isEnumerator(csmObject)) {
            csmClass = CsmBaseUtilities.getObjectClass(((CsmEnumerator)csmObject).getEnumeration());
        } else if (CsmKindUtilities.isScopeElement(csmObject) && CsmKindUtilities.isClass(csmScope = ((CsmScopeElement)csmObject).getScope())) {
            csmClass = (CsmClass)csmScope;
        }
        return csmClass;
    }

    public static CsmNamespace getObjectNamespace(CsmObject csmObject) {
        CsmScope csmScope;
        CsmNamespace csmNamespace = null;
        if (CsmKindUtilities.isNamespace(csmObject)) {
            csmNamespace = (CsmNamespace)csmObject;
        } else if (CsmKindUtilities.isFunction(csmObject)) {
            csmNamespace = CsmBaseUtilities.getFunctionNamespace((CsmFunction)csmObject);
        } else if (CsmKindUtilities.isClass(csmObject)) {
            csmNamespace = CsmBaseUtilities.getClassNamespace((CsmClassifier)csmObject);
        } else if (CsmKindUtilities.isEnumerator(csmObject)) {
            csmNamespace = CsmBaseUtilities.getObjectNamespace(((CsmEnumerator)csmObject).getEnumeration());
        } else if (CsmKindUtilities.isScopeElement(csmObject) && CsmKindUtilities.isNamespace(csmScope = ((CsmScopeElement)csmObject).getScope())) {
            csmNamespace = (CsmNamespace)csmScope;
        }
        return csmNamespace;
    }

    public static CsmNamespace getFunctionNamespace(CsmFunction csmFunction) {
        CsmScope csmScope;
        if (CsmKindUtilities.isFunctionDefinition(csmFunction)) {
            csmScope = ((CsmFunctionDefinition)csmFunction).getDeclaration();
            CsmScope csmScope2 = csmFunction = csmScope != null ? csmScope : csmFunction;
        }
        if (csmFunction != null) {
            csmScope = csmFunction.getScope();
            if (CsmKindUtilities.isNamespaceDefinition(csmScope)) {
                CsmNamespace csmNamespace = ((CsmNamespaceDefinition)csmScope).getNamespace();
                return csmNamespace;
            }
            if (CsmKindUtilities.isNamespace(csmScope)) {
                CsmNamespace csmNamespace = (CsmNamespace)csmScope;
                return csmNamespace;
            }
            if (CsmKindUtilities.isClass(csmScope)) {
                return CsmBaseUtilities.getClassNamespace((CsmClass)csmScope);
            }
        }
        return null;
    }

    public static CsmNamespace getClassNamespace(CsmClassifier csmClassifier) {
        CsmScope csmScope = csmClassifier.getScope();
        while (csmScope != null) {
            if (CsmKindUtilities.isNamespace(csmScope)) {
                return (CsmNamespace)csmScope;
            }
            if (!CsmKindUtilities.isScopeElement(csmScope)) break;
            csmScope = ((CsmScopeElement)((Object)csmScope)).getScope();
        }
        return null;
    }

    public static CsmFunction getFunctionDeclaration(CsmFunction csmFunction) {
        assert (csmFunction != null) : "must be not null";
        CsmFunction csmFunction2 = csmFunction;
        if (CsmKindUtilities.isFunctionDefinition(csmFunction2)) {
            csmFunction2 = ((CsmFunctionDefinition)csmFunction2).getDeclaration();
        }
        return csmFunction2;
    }

    public static boolean isFileLocalFunction(CsmFunction csmFunction) {
        CsmFunction csmFunction2 = CsmBaseUtilities.getFunctionDeclaration(csmFunction);
        return csmFunction2 != null && CsmKindUtilities.isFile(csmFunction2.getScope());
    }

    public static boolean isDeclarationFromUnnamedNamespace(CsmObject csmObject) {
        if (CsmKindUtilities.isScopeElement(csmObject)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject).getScope();
            if (CsmKindUtilities.isNamespaceDefinition(csmScope)) {
                return ((CsmNamespaceDefinition)csmScope).getName().length() == 0;
            }
            if (CsmKindUtilities.isNamespace(csmScope)) {
                CsmNamespace csmNamespace = (CsmNamespace)csmScope;
                return !csmNamespace.isGlobal() && csmNamespace.getName().length() == 0;
            }
        }
        return false;
    }

    public static CsmClass getContextClass(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (csmOffsetableDeclaration == null) {
            return null;
        }
        CsmClass csmClass = null;
        if (CsmKindUtilities.isClass(csmOffsetableDeclaration)) {
            csmClass = (CsmClass)csmOffsetableDeclaration;
        } else if (CsmKindUtilities.isClassMember(csmOffsetableDeclaration)) {
            csmClass = ((CsmMember)csmOffsetableDeclaration).getContainingClass();
        } else if (CsmKindUtilities.isFunction(csmOffsetableDeclaration)) {
            csmClass = CsmBaseUtilities.getFunctionClass((CsmFunction)csmOffsetableDeclaration);
        }
        return csmClass;
    }

    public static CsmFunction getContextFunction(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (csmOffsetableDeclaration == null) {
            return null;
        }
        CsmFunction csmFunction = null;
        if (CsmKindUtilities.isFunction(csmOffsetableDeclaration)) {
            csmFunction = (CsmFunction)csmOffsetableDeclaration;
        }
        return csmFunction;
    }

    public static CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier, CsmFile csmFile) {
        return CsmClassifierResolver.getDefault().getOriginalClassifier(csmClassifier, csmFile);
    }

    public static CsmClassifier getClassifier(CsmType csmType, CsmFile csmFile, boolean bl) {
        return CsmClassifierResolver.getDefault().getTypeClassifier(csmType, csmFile, 0, bl);
    }
}

