/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasText(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static String implode(List<String> list, String string) {
        Parameters.notNull((CharSequence)"items", list);
        Parameters.notNull((CharSequence)"delimiter", (Object)string);
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static List<String> explode(String string, String string2) {
        Parameters.notNull((CharSequence)"delimiter", (Object)string2);
        if (!StringUtils.hasText(string)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split(Pattern.quote(string2)));
    }

    public static Pattern getPattern(String string) {
        Parameters.notNull((CharSequence)"text", (Object)string);
        return StringUtils.getPattern0(string, ".*", ".*");
    }

    public static Pattern getExactPattern(String string) {
        Parameters.notNull((CharSequence)"text", (Object)string);
        return StringUtils.getPattern0(string, "^", "$");
    }

    private static Pattern getPattern0(String string, String string2, String string3) {
        assert (string != null);
        assert (string2 != null);
        assert (string3 != null);
        if (string.contains("?") || string.contains("*")) {
            String string4 = string.replace("\\", "").replace(".", "\\.").replace("-", "\\-").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("?", ".").replace("*", ".*");
            return Pattern.compile(string2 + string4 + string3, 2);
        }
        return null;
    }
}

