/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    public static final String PHP_MIME_TYPE = "text/x-php5";

    private FileUtils() {
    }

    public static boolean isPhpFile(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file", (Object)fileObject);
        return PHP_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{PHP_MIME_TYPE}));
    }

    public static List<String> findFileOnUsersPath(String string) {
        Parameters.notNull((CharSequence)"filename", (Object)string);
        String string2 = System.getenv("PATH");
        if (string2 == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string2.split(File.pathSeparator)));
        ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet.size());
        for (String string3 : linkedHashSet) {
            String string4;
            File file = new File(string3, string);
            if (!file.isFile() || arrayList.contains(string4 = FileUtil.normalizeFile((File)file).getAbsolutePath())) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static FileObject getFileObject(Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            return fileObject;
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create SAX parser", parserConfigurationException);
        }
    }
}

