/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchPanel
extends JPanel {
    private static final long serialVersionUID = 26389843114771322L;
    private final RequestProcessor rp;
    private final UiUtils.SearchWindow.SearchWindowSupport support;
    private List<String> foundItems;
    private DialogDescriptor descriptor;
    private RequestProcessor.Task detectTask;
    private JLabel detectedFilesLabel;
    private JList foundItemsList;
    private JScrollPane foundItemsScrollPane;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    private SearchPanel(UiUtils.SearchWindow.SearchWindowSupport searchWindowSupport) {
        assert (searchWindowSupport != null);
        this.support = searchWindowSupport;
        this.initComponents();
        this.rp = new RequestProcessor("PHP Search Panel detection thread (" + searchWindowSupport.getPleaseWaitPart() + ")", 1, true);
        Mnemonics.setLocalizedText((JLabel)this.detectedFilesLabel, (String)searchWindowSupport.getListTitle());
        this.messageLabel.setText(NbBundle.getMessage(SearchPanel.class, (String)"LBL_PleaseWait", (Object)searchWindowSupport.getPleaseWaitPart()));
    }

    public static SearchPanel create(UiUtils.SearchWindow.SearchWindowSupport searchWindowSupport) {
        return new SearchPanel(searchWindowSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, this.support.getWindowTitle(), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.cancelDetection();
            }
        });
        if (this.foundItems == null) {
            this.descriptor.setValid(false);
            this.foundItemsList.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.detectTask = this.rp.create(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    final List<String> list = SearchPanel.this.support.detect();
                    assert (list != null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SearchPanel.this.updateFoundItems(list);
                        }
                    });
                }
            });
            this.detectTask.schedule(0);
        } else {
            this.updateFoundItems(this.foundItems);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public List<String> getFoundItems() {
        return this.foundItems;
    }

    public String getSelectedItem() {
        return (String)this.foundItemsList.getSelectedValue();
    }

    void cancelDetection() {
        if (this.detectTask != null) {
            this.detectTask.cancel();
        }
    }

    void updateFoundItems(List<String> list) {
        this.foundItems = list;
        this.foundItemsList.setEnabled(true);
        this.foundItemsList.setListData(list.toArray(new String[list.size()]));
        String string = null;
        if (list.size() == 0) {
            string = this.support.getNoItemsFound();
        } else {
            string = " ";
            this.foundItemsList.setSelectedIndex(0);
        }
        this.messageLabel.setText(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(this.getBackground());
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.detectedFilesLabel = new JLabel();
        this.foundItemsScrollPane = new JScrollPane();
        this.foundItemsList = new JList();
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setFocusTraversalPolicy(null);
        this.detectedFilesLabel.setLabelFor(this.foundItemsList);
        Mnemonics.setLocalizedText((JLabel)this.detectedFilesLabel, (String)"title");
        this.foundItemsList.setSelectionMode(0);
        this.foundItemsList.setEnabled(false);
        this.foundItemsScrollPane.setViewportView(this.foundItemsList);
        this.foundItemsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleName"));
        this.foundItemsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersList.AccessibleContext.accessibleDescription"));
        this.messageLabel.setLabelFor(this.progressBar);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)"please wait...");
        this.progressBar.setString(" ");
        this.progressBar.setStringPainted(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.foundItemsScrollPane, -1, 291, Short.MAX_VALUE).add(1, (Component)this.progressBar, -1, 291, Short.MAX_VALUE).add(1, (Component)this.detectedFilesLabel).add(1, (Component)this.messageLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.detectedFilesLabel).addPreferredGap(0).add((Component)this.foundItemsScrollPane, -1, 105, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).add(0, 0, 0)));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleName"));
        this.detectedFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.detectedFilesLabel.AccessibleContext.accessibleDescription"));
        this.foundItemsScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleName"));
        this.foundItemsScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.phpInterpretersScrollPane.AccessibleContext.accessibleDescription"));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleName"));
        this.messageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.messageLabel.AccessibleContext.accessibleDescription"));
        this.progressBar.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleName"));
        this.progressBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.progressBar.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"SelectPhpInterpreterPanel.AccessibleContext.accessibleDescription"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Detector {
        public List<String> detect();
    }

    public static final class Strings {
        final String windowTitle;
        final String listTitle;
        final String pleaseWaitPart;
        final String noItemsFound;

        public Strings(String string, String string2, String string3, String string4) {
            assert (string != null);
            assert (string2 != null);
            assert (string3 != null);
            assert (string4 != null);
            this.windowTitle = string;
            this.listTitle = string2;
            this.pleaseWaitPart = string3;
            this.noItemsFound = string4;
        }
    }
}

