/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.target.iterator.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.target.iterator.spi.TargetPanelProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetChooserPanel<T>
implements WizardDescriptor.Panel {
    private static final Logger LOG = Logger.getLogger(TargetChooserPanel.class.getName());
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+\\|{};:'\",<>/?]");
    private static final Pattern INVALID_FOLDERNAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+|{};'\",<>?]");
    private ChangeSupport myChangeSupport = new ChangeSupport((Object)this);
    private TargetChooserPanelGUI<T> myGui;
    private T myId;
    private Project myProject;
    private SourceGroup[] myFolders;
    private TemplateWizard myTemplateWizard;
    private TargetPanelProvider<T> myProvider;

    public TargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, T t) {
        this.myFolders = sourceGroupArray;
        this.myProject = project;
        this.myId = t;
        this.loadProvider();
        this.getProvider().init(this);
    }

    public T getId() {
        return this.myId;
    }

    public TargetChooserPanelGUI<T> getComponent() {
        if (this.myGui == null) {
            this.myGui = new TargetChooserPanelGUI(this);
        }
        return this.myGui;
    }

    public Project getProject() {
        return this.myProject;
    }

    public SourceGroup[] getSourceGroups() {
        return this.myFolders;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getProvider().isValid(this);
    }

    public boolean checkValid() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this.myGui != null && this.myGui.getTargetName() != null;
        if (!bl2) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", null);
            return false;
        }
        String string = this.myGui.getTargetName();
        if (INVALID_FILENAME_CHARACTERS.matcher(string).find()) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename"));
            return false;
        }
        String string2 = this.myGui.getTargetFolder();
        if (INVALID_FOLDERNAME_CHARACTERS.matcher(string2).find()) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_foldername"));
            return false;
        }
        String string3 = this.myGui.getTargetName();
        File file = this.myGui.getTargetFile();
        String string4 = this.getProvider().getResultExtension(this);
        String string5 = this.canUseFileName(file, this.myGui.getRelativeTargetFolder(), string3, string4);
        if (string5 != null) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)string5);
        } else {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)this.myGui.getErrorMessage());
        }
        boolean bl4 = bl = this.myGui.isPanelValid() && string5 == null;
        if (bl && string3.indexOf(46) >= 0) {
            this.myTemplateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_dotsInName", (Object)(string3 + "." + string4)));
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myChangeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myChangeSupport.removeChangeListener(changeListener);
    }

    public TemplateWizard getTemplateWizard() {
        return this.myTemplateWizard;
    }

    public void readSettings(Object object) {
        this.myTemplateWizard = (TemplateWizard)object;
        if (this.myGui != null) {
            this.myGui.initValues();
            String string = this.getProvider().getWizardTitle();
            if (string != null) {
                this.getTemplateWizard().putProperty("NewFileWizard_Title", (Object)string);
            }
            this.getProvider().readSettings(this);
        }
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (this.isValid()) {
            File file = new File(this.myGui.getCreatedFilePath());
            File file2 = new File(file.getParentFile().getPath());
            if (!file2.exists()) {
                try {
                    FileUtil.createFolder((File)file2);
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                }
            }
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)fileObject);
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)this.myGui.getTargetName());
            this.getProvider().storeSettings(this);
        }
        ((WizardDescriptor)object).putProperty("NewFileWizard_Title", null);
    }

    public void fireChange() {
        this.myChangeSupport.fireChange();
    }

    TargetPanelProvider<T> getProvider() {
        return this.myProvider;
    }

    private void loadProvider() {
        Collection collection = Lookup.getDefault().lookupAll(TargetPanelProvider.class);
        for (TargetPanelProvider targetPanelProvider : collection) {
            if (!targetPanelProvider.isApplicable(this.myId)) continue;
            this.myProvider = targetPanelProvider;
            break;
        }
        if (this.myProvider == null) {
            throw new IllegalStateException("No provider for id '" + this.myId + "'  is found ");
        }
    }

    private String canUseFileName(File file, String string, String string2, String string3) {
        StringBuilder stringBuilder;
        String string4 = string2;
        if (string3 != null && string3.length() > 0) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append('.');
            stringBuilder.append(string3);
            string4 = stringBuilder.toString();
        }
        if (!this.checkFileName(string2)) {
            return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename", (Object)string4);
        }
        stringBuilder = null;
        if (file != null) {
            try {
                stringBuilder = FileUtil.toFileObject((File)file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_path", (Object)string);
            }
        }
        if (stringBuilder != null) {
            if (!stringBuilder.canWrite()) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_fs_is_readonly");
            }
            if (stringBuilder.getFileObject(string4) != null) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string4);
            }
            if (Utilities.isWindows() && this.checkCaseInsensitiveName((FileObject)stringBuilder, string4)) {
                return NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string4);
            }
        }
        return null;
    }

    private boolean checkCaseInsensitiveName(FileObject fileObject, String string) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string.equalsIgnoreCase(fileObject2.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkFileName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                return false;
            }
            if (cArray[i] != '/') continue;
            return false;
        }
        return true;
    }
}

