/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2PluginProperties {
    public static final String PROP_JAVA_PLATFORM = "java_platform";
    public static final String PROP_JAVADOCS = "javadocs";
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private InstanceProperties ip;
    private static final int DEBUGPORT = 9009;
    private ServerUtilities su;

    public Hk2PluginProperties(Hk2DeploymentManager hk2DeploymentManager, ServerUtilities serverUtilities) {
        this.ip = InstanceProperties.getInstanceProperties((String)hk2DeploymentManager.getUri());
        this.su = serverUtilities;
    }

    public String getDomainDir() {
        String string = this.ip.getProperty("domainsfolder");
        return null == string ? string : string + File.separator + this.ip.getProperty("domainname");
    }

    public String getInstallRoot() {
        return this.ip.getProperty("installfolder");
    }

    public String getGlassfishRoot() {
        return this.ip.getProperty("homefolder");
    }

    public JavaPlatform getJavaPlatform() {
        String string = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string2 = (String)javaPlatformArray[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatformArray[i];
        }
        return javaPlatformManager.getDefaultPlatform();
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public List<URL> getClasses() {
        File file = new File(this.getGlassfishRoot());
        return Hk2PluginProperties.getClasses(file);
    }

    public static List<URL> getClasses(File file) {
        List<String> list = new ArrayList<String>();
        HashSet<URI> hashSet = new HashSet<URI>();
        try {
            Object object;
            Object object2;
            File file2 = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)"javax.javaee(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            Logger.getLogger("glassfish-javaee").log(Level.FINER, "JavaEE jar is " + (file2 != null ? file2.getAbsolutePath() : "null"));
            if (file2 != null && file2.exists()) {
                list.add("web/jsf-connector-10.0");
                object2 = new JarFile(file2);
                Manifest arrayList2 = ((JarFile)object2).getManifest();
                if (arrayList2 != null) {
                    object = arrayList2.getMainAttributes();
                    String string = ((Attributes)object).getValue("Class-Path");
                    Logger.getLogger("glassfish-javaee").log(Level.FINER, "JavaEE jar classpath is \"" + string + "\"");
                    if (string != null && string.length() > 0) {
                        File file3 = file2.getParentFile();
                        for (String string2 : string.split(" ")) {
                            hashSet.add(Hk2PluginProperties.fileToUrl(new File(file3, string2)).toURI());
                        }
                    }
                }
                if (hashSet.size() == 0) {
                    Logger.getLogger("glassfish-javaee").log(Level.FINER, file2.getAbsolutePath() + " contains null classpath or subjars not found.  Using directly.");
                    hashSet.add(Hk2PluginProperties.fileToUrl(file2).toURI());
                }
            } else {
                object2 = new File(file.getAbsolutePath() + File.separatorChar + "modules");
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object2));
                list = ServerUtilities.filterByManifest(list, (FileObject)fileObject, (int)0, (boolean)true);
            }
            list.add("webservices(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("jaxb(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("web/jstl-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("web/jsf-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("jstl-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("jsf-impl(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("jsf-api(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("bean-validator(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("webbeans-osgi-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            list.add("weld-osgi-bundle(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            for (String string : list) {
                object = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)string);
                if (object == null || !((File)object).exists()) continue;
                hashSet.add(Hk2PluginProperties.fileToUrl((File)object).toURI());
            }
            object2 = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)"endorsed/webservices-api-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            if (null != object2) {
                hashSet.add(Hk2PluginProperties.fileToUrl((File)object2).toURI());
            } else {
                object2 = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)"webservices-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
                if (null != object2) {
                    hashSet.add(Hk2PluginProperties.fileToUrl((File)object2).toURI());
                }
            }
            object2 = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)"endorsed/jaxb-api-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            if (null != object2) {
                hashSet.add(Hk2PluginProperties.fileToUrl((File)object2).toURI());
            } else {
                object2 = ServerUtilities.getJarName((String)file.getAbsolutePath(), (String)"jaxb-osgi(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
                if (null != object2) {
                    hashSet.add(Hk2PluginProperties.fileToUrl((File)object2).toURI());
                }
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (URI uRI : hashSet) {
                arrayList.add(uRI.toURL());
            }
            return arrayList;
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return new ArrayList<URL>();
    }

    public List<URL> getJavadocs() {
        String string = this.ip.getProperty(PROP_JAVADOCS);
        if (string == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (String string2 : this.su.getAssociatedJavaDoc()) {
                try {
                    File file = InstalledFileLocator.getDefault().locate(string2, null, false);
                    if (file == null) continue;
                    arrayList.add(Hk2PluginProperties.fileToUrl(file));
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
                }
            }
            return arrayList;
        }
        return Hk2PluginProperties.tokenizePath(string);
    }

    public static List<URL> tokenizePath(String string) {
        try {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
            char c = '\u0000';
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                char c2;
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                    n = c2;
                    ++n2;
                    continue;
                }
                if (c != '\u0000') {
                    if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                        string2 = "" + c + ':' + string2;
                    } else {
                        arrayList.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(c))));
                    }
                    c = '\u0000';
                }
                n2 = 0;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    c = c2;
                    continue;
                }
                arrayList.add(Hk2PluginProperties.fileToUrl(new File(string2)));
            }
            if (c != '\u0000') {
                arrayList.add(Hk2PluginProperties.fileToUrl(new File(Character.toString(c))));
            }
            return arrayList;
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
            return new ArrayList<URL>();
        }
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        }
        return uRL;
    }

    public static String buildPath(List<URL> list) {
        String string = System.getProperty("path.separator");
        StringBuilder stringBuilder = new StringBuilder(list.size() * 16);
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(Hk2PluginProperties.urlToString(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String urlToString(URL uRL) {
        Serializable serializable;
        if ("jar".equals(uRL.getProtocol())) {
            serializable = FileUtil.getArchiveFile((URL)uRL);
            if (FileUtil.getArchiveRoot((URL)serializable).equals(uRL)) {
                uRL = serializable;
            } else {
                return uRL.toExternalForm();
            }
        }
        if ("file".equals(uRL.getProtocol())) {
            serializable = new File(URI.create(uRL.toExternalForm()));
            return ((File)serializable).getAbsolutePath();
        }
        return uRL.toExternalForm();
    }

    public void setJavadocs(List<URL> list) {
        this.ip.setProperty(PROP_JAVADOCS, Hk2PluginProperties.buildPath(list));
    }

    public int getDebugPort() {
        return 9009;
    }

    private static boolean isRunning(String string, int n) throws IOException {
        if (null == string) {
            return false;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        Socket socket = new Socket();
        socket.connect(inetSocketAddress, 1);
        socket.close();
        return true;
    }

    public static boolean isRunning(String string, String string2) {
        try {
            return Hk2PluginProperties.isRunning(string, Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, string + "  " + string2, numberFormatException);
            return false;
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, string + "  " + string2, iOException);
            return false;
        }
    }
}

