/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.swingapp.templates.ConfigureProjectVisualPanel;
import org.netbeans.modules.swingapp.templates.NewAppWizardIterator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureProjectPanel
implements WizardDescriptor.Panel,
WizardDescriptor.FinishablePanel {
    private WizardDescriptor wizard;
    private NewAppWizardIterator wizardIterator;
    private ConfigureProjectVisualPanel visualPanel;
    public static final String SHARED_LIBRARIES = "sharedLibraries";
    private EventListenerList listenerList;

    public ConfigureProjectPanel(NewAppWizardIterator newAppWizardIterator) {
        this.wizardIterator = newAppWizardIterator;
    }

    public Component getComponent() {
        if (this.visualPanel == null) {
            this.visualPanel = new ConfigureProjectVisualPanel(this);
        }
        return this.visualPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.swingapp.templates.ConfigureProjectPanel");
    }

    public void readSettings(Object object) {
        String string;
        WizardDescriptor wizardDescriptor;
        this.wizard = wizardDescriptor = (WizardDescriptor)object;
        this.getComponent();
        wizardDescriptor.putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"TITLE_NewDesktopApp"));
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        String string2 = (String)wizardDescriptor.getProperty("projname");
        if (string2 == null) {
            string = "DesktopApplication";
            int n = 0;
            while (new File(file, string2 = string + ++n).exists()) {
            }
        }
        string = (String)wizardDescriptor.getProperty("appname");
        this.visualPanel.setConfig(file, string2, string);
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        wizardDescriptor.putProperty("projdir", (Object)this.visualPanel.getProjectDirectory());
        wizardDescriptor.putProperty("projname", (Object)this.visualPanel.getProjectName());
        wizardDescriptor.putProperty("appname", (Object)this.visualPanel.getApplicationClassName());
        wizardDescriptor.putProperty("appshell", (Object)this.visualPanel.getSelectedTemplate());
        wizardDescriptor.putProperty("setAsMain", (Object)this.visualPanel.isSetMainProject());
        wizardDescriptor.putProperty(SHARED_LIBRARIES, this.visualPanel.isShareable() ? this.visualPanel.getLibFolderPath() : null);
    }

    public boolean isValid() {
        File file;
        File file2;
        File file3;
        String string;
        if (this.visualPanel.isShareable()) {
            string = this.visualPanel.getLibFolderPath();
            if (this.visualPanel.getProjectDirectory() != null) {
                if (new File(string).isAbsolute()) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    file3 = FileUtil.normalizeFile((File)this.visualPanel.getProjectDirectory());
                    if (!CollocationQuery.areCollocated((File)file3, (File)(file2 = PropertyUtils.resolveFile((File)file3, (String)string)))) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if ((string = this.visualPanel.getProjectName()) == null || string.length() == 0 || string.indexOf(47) > 0 || string.indexOf(92) > 0 || string.indexOf(58) > 0 || string.indexOf(34) > 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        file3 = this.visualPanel.getProjectDirectory();
        try {
            file2 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectLocation"));
            return false;
        }
        if (Utilities.isUnix() && file2.getParentFile().getParent() == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectInRootNotSupported"));
            return false;
        }
        for (file = FileUtil.normalizeFile((File)file3); file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectLocation"));
            return false;
        }
        File[] fileArray = file3.listFiles();
        if (file3.exists() && fileArray != null && fileArray.length > 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        String string2 = this.visualPanel.getApplicationClassName();
        for (String string3 : string2.split("\\.", -1)) {
            if (Utilities.isJavaIdentifier((String)string3)) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_InvalidAppClassName"));
            return false;
        }
        if (string2.indexOf(46) <= 0) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_InvalidDefaultPackage"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        return this.visualPanel.getSelectedTemplate() != null;
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getAppShellIterator() == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    void visualPanelChanged(boolean bl) {
        if (bl) {
            this.wizardIterator.setAppShellIterator(this.getAppShellWizardIterator(this.visualPanel.getSelectedTemplate()));
        }
        this.fireStateChanged();
    }

    private WizardDescriptor.InstantiatingIterator getAppShellWizardIterator(FileObject fileObject) {
        Object object;
        if (fileObject != null && (object = fileObject.getAttribute("instantiatingIterator")) instanceof WizardDescriptor.InstantiatingIterator) {
            return (WizardDescriptor.InstantiatingIterator)object;
        }
        return null;
    }
}

