/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.View;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ResourcePanelImpl
extends JPanel
implements ResourcePanel {
    private DesignResourceMap resources;
    private Class valueType;
    private ResourceValueImpl resourceValue;
    private boolean validValue;
    private ResourceValueImpl lastValue;
    private String newKey;
    private List<ChangeListener> listeners;
    private boolean ignoreCombo;
    private JRadioButton applicationRadio;
    private ButtonGroup buttonGroup1;
    private JRadioButton classRadio;
    private JLabel hintLabel;
    private JCheckBox i18nCheckBox;
    private JLabel invalidLabel;
    private JSeparator jSeparator1;
    private JComboBox keyCombo;
    private JLabel keyLabel;
    private JLabel layoutBugWorkaroundLabel;
    private JLabel levelLabel;
    private JCheckBox resourceCheckBox;
    private JLabel valueLabel;
    private JTextField valueTextField;

    ResourcePanelImpl(DesignResourceMap designResourceMap, Class clazz) {
        this.resources = designResourceMap;
        this.valueType = clazz;
        this.initComponents();
        this.invalidLabel.setVisible(false);
        this.keyCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    ResourcePanelImpl.this.keyComboActionPerformed(null);
                }
            }
        });
        this.classRadio.setSelected(true);
    }

    public void init(String string, boolean bl) {
        this.lastValue = null;
        ResourceValueImpl resourceValueImpl = this.resources.getResourceValue(string, this.valueType);
        if (resourceValueImpl == null) {
            resourceValueImpl = new ResourceValueImpl(string, this.valueType, null, null, null, this.valueType == String.class, this.getStorageLevel(), this.resources.getSourceFile());
            this.newKey = string;
        } else {
            this.newKey = null;
        }
        if (bl) {
            this.resourceValue = resourceValueImpl;
            this.loadKeys();
            this.resourceCheckBox.setSelected(true);
            this.fireChange();
        } else {
            this.resourceValue = null;
            if (this.newKey == null) {
                resourceValueImpl.setValue(null);
                resourceValueImpl.setStringValue(null);
            }
            this.lastValue = resourceValueImpl;
            this.resourceCheckBox.setSelected(false);
        }
        this.enableControls();
        this.updateControls();
    }

    public void setValue(Object object, String string, String string2) {
        Object object2;
        if (!this.isEditingEnabled()) {
            return;
        }
        DesignResourceMap designResourceMap = this.resources.getLevel(this.getStorageLevel());
        if (string2 != null) {
            object2 = designResourceMap.getResourcesDir();
            string = string2.startsWith((String)object2) ? string2.substring(((String)object2).length()) : (string2.startsWith("/") ? "" : "/") + string2;
        }
        if (string != null) {
            try {
                object2 = designResourceMap.evaluateStringValue(string, this.valueType);
                if (object == null) {
                    object = object2;
                }
                if (string2 == null && this.resourceValue.getClassPathResourceName() != null) {
                    string2 = designResourceMap.getResourcesDir() + string;
                }
            }
            catch (ResourceMap.LookupException lookupException) {
                object = ResourceValue.IGNORED_VALUE;
                string2 = null;
            }
        } else {
            string = ResourceUtils.getValueAsString(object);
            if (string == null) {
                object = ResourceValue.IGNORED_VALUE;
                string = "";
            }
        }
        this.resourceValue.setStringValue(string);
        if (string2 != null) {
            this.resourceValue.setClassPathResourceName(string2);
        }
        this.resourceValue.setValue(object);
        this.setValueFieldText(string);
        this.setValidValue(object != ResourceValue.IGNORED_VALUE);
    }

    public ResourceValue getResource() {
        return this.resourceValue;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<ChangeListener>();
        } else {
            this.listeners.remove(changeListener);
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    private boolean isEditingEnabled() {
        return this.resourceValue != null;
    }

    private void setStorageLevel(int n) {
        switch (n) {
            case 2: {
                this.classRadio.setSelected(true);
                break;
            }
            case 0: {
                this.applicationRadio.setSelected(true);
            }
        }
    }

    private int getStorageLevel() {
        if (this.applicationRadio.isSelected()) {
            return 0;
        }
        return 2;
    }

    private void loadKeys() {
        DesignResourceMap designResourceMap = this.resources.getLevel(this.resourceValue.getStorageLevel());
        Collection<String> collection = designResourceMap.collectKeys("\\S+", false);
        ArrayList<String> arrayList = new ArrayList<String>(collection.size() + 2);
        arrayList.addAll(collection);
        String string = this.resourceValue.getKey();
        if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
        if (this.newKey != null && !this.newKey.equals(string) && !arrayList.contains(this.newKey)) {
            arrayList.add(this.newKey);
        }
        Collections.sort(arrayList);
        this.keyCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void updateControls() {
        if (this.isEditingEnabled()) {
            if (this.resourceValue != null) {
                this.i18nCheckBox.setSelected(this.resourceValue.isInternationalized());
                this.ignoreCombo = true;
                this.keyCombo.setSelectedItem(this.resourceValue.getKey());
                this.ignoreCombo = false;
                String string = this.resourceValue.getStringValue();
                this.setValueFieldText(string != null ? string : "");
                this.setStorageLevel(this.resourceValue.getStorageLevel());
            }
        } else {
            this.setValueFieldText("");
            if (this.lastValue != null) {
                this.i18nCheckBox.setSelected(this.lastValue.isInternationalized());
                this.ignoreCombo = true;
                this.keyCombo.setSelectedItem(this.lastValue.getKey());
                this.ignoreCombo = false;
                this.setStorageLevel(this.lastValue.getStorageLevel());
            }
        }
    }

    private void enableControls() {
        boolean bl = this.isEditingEnabled();
        this.i18nCheckBox.setEnabled(bl);
        this.classRadio.setEnabled(bl);
        this.applicationRadio.setEnabled(bl && this.resources.getLevel(0) != null);
        this.keyCombo.setEnabled(bl);
        this.valueTextField.setEnabled(bl);
    }

    private void enablePanel(boolean bl) {
        if (bl && !this.isEditingEnabled()) {
            assert (this.lastValue != null);
            this.resourceValue = this.lastValue;
            this.loadKeys();
        } else if (!bl && this.isEditingEnabled()) {
            this.lastValue = new ResourceValueImpl(this.resourceValue);
            this.lastValue.setValue(null);
            this.lastValue.setStringValue(null);
            this.resourceValue = null;
        }
        this.enableControls();
        this.updateControls();
    }

    private void setValidValue(boolean bl) {
        this.validValue = bl;
        this.invalidLabel.setVisible(!bl);
        this.valueTextField.setToolTipText(bl ? null : this.invalidLabel.getToolTipText());
        if (!bl) {
            this.valueTextField.setSelectionStart(0);
            this.valueTextField.setSelectionEnd(this.valueTextField.getDocument().getLength());
        }
    }

    private boolean isValidValue() {
        return this.validValue;
    }

    private void setValueFieldText(String string) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\n') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length() * 2);
                    stringBuilder.append(string.substring(0, i));
                }
                if (c == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                stringBuilder.append("\\n");
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        this.valueTextField.setText(stringBuilder != null ? stringBuilder.toString() : string);
    }

    private String getValueFieldText() {
        String string = this.valueTextField.getText();
        StringBuilder stringBuilder = null;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length());
                    stringBuilder.append(string.substring(0, i));
                }
                if (bl) {
                    stringBuilder.append('\\');
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                if (c == 'n') {
                    c = '\n';
                } else {
                    stringBuilder.append('\\');
                }
                bl = false;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    private void setStorageLevelToValue(int n) {
        if (this.resourceValue != null) {
            this.resourceValue.setStorageLevel(n);
            if (this.resourceValue.getClassPathResourceName() != null) {
                String string;
                Object object = this.resourceValue.getValue();
                String string2 = this.getValueFieldText();
                this.setValue(null, string2, null);
                if (this.resourceValue.getValue() == object && !string2.equals(string = this.resourceValue.getStringValue())) {
                    this.setValue(null, string, null);
                }
                if (this.resourceValue.getValue() != object) {
                    this.fireChange();
                } else {
                    this.resourceValue.setStringValue(string2);
                    string = this.resources.getLevel(n).getResourcesDir();
                    this.resourceValue.setClassPathResourceName(string + string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                return;
            }
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        serializable = new ChangeEvent(this);
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged((ChangeEvent)serializable);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSeparator1 = new JSeparator();
        this.resourceCheckBox = new JCheckBox();
        this.i18nCheckBox = new JCheckBox();
        this.levelLabel = new JLabel();
        this.keyLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.classRadio = new JRadioButton();
        this.applicationRadio = new JRadioButton();
        this.valueTextField = new JTextField();
        this.keyCombo = new JComboBox();
        this.invalidLabel = new JLabel();
        this.layoutBugWorkaroundLabel = new JLabel();
        this.hintLabel = new JLabel();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.resourceCheckBox, (String)NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.resourceCheckBox.text"));
        this.resourceCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resourceCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.resourceCheckBox.addActionListener(formListener);
        this.i18nCheckBox.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.i18nCheckBox.text"));
        this.i18nCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.i18nCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.i18nCheckBox.addActionListener(formListener);
        this.levelLabel.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.levelLabel.text"));
        this.keyLabel.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.keyLabel.text"));
        this.valueLabel.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.valueLabel.text"));
        this.buttonGroup1.add(this.classRadio);
        this.classRadio.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.classRadio.text"));
        this.classRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classRadio.setMargin(new Insets(0, 0, 0, 0));
        this.classRadio.addActionListener(formListener);
        this.buttonGroup1.add(this.applicationRadio);
        this.applicationRadio.setText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.applicationRadio.text"));
        this.applicationRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.applicationRadio.setMargin(new Insets(0, 0, 0, 0));
        this.applicationRadio.addActionListener(formListener);
        this.valueTextField.addActionListener(formListener);
        this.keyCombo.setEditable(true);
        this.keyCombo.addActionListener(formListener);
        this.invalidLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/swingapp/resources/invalid.gif")));
        this.invalidLabel.setToolTipText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl.invalidLabel.toolTipText"));
        this.hintLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/swingapp/resources/help.png")));
        this.hintLabel.addMouseListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keyLabel).add((Component)this.valueLabel).add((Component)this.levelLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.classRadio).addPreferredGap(0).add((Component)this.applicationRadio)).add((Component)this.keyCombo, 0, 270, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.valueTextField, -1, 250, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.invalidLabel).add(0, 0, 0).add((Component)this.layoutBugWorkaroundLabel))).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.resourceCheckBox).addPreferredGap(0).add((Component)this.hintLabel).add(15, 15, 15).add((Component)this.i18nCheckBox).addContainerGap(102, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 327, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.resourceCheckBox).add((Component)this.i18nCheckBox).add((Component)this.hintLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyLabel).add((Component)this.keyCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.valueLabel).add((Component)this.valueTextField, -2, -1, -2).add((Component)this.invalidLabel).add((Component)this.layoutBugWorkaroundLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.classRadio).add((Component)this.levelLabel).add((Component)this.applicationRadio)).addContainerGap()));
    }

    private void hintLabelMousePressed(MouseEvent mouseEvent) {
        Object object;
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(NbBundle.getMessage(ResourcePanelImpl.class, (String)"ResourcePanelImpl_ToolTip"));
        Dimension dimension = this.getSize();
        if (jToolTip.getPreferredSize().width > dimension.width && (object = (View)jToolTip.getClientProperty("html")) != null) {
            ((View)object).setSize(dimension.width, 0.0f);
        }
        object = new Window(SwingUtilities.getWindowAncestor(this));
        ((Component)object).setFocusable(true);
        ((Container)object).add(jToolTip);
        ((Window)object).pack();
        Point point = new Point(-3, -((Component)object).getHeight() - 3);
        SwingUtilities.convertPointToScreen(point, this);
        ((Window)object).setLocation(point.x, point.y);
        ((Component)object).addKeyListener(new KeyAdapter((Window)object){
            final /* synthetic */ Window val$win;
            {
                this.val$win = window;
            }

            public void keyPressed(KeyEvent keyEvent) {
                this.val$win.setVisible(false);
                this.val$win.dispose();
                ResourcePanelImpl.this.resourceCheckBox.requestFocusInWindow();
            }
        });
        ((Component)object).addFocusListener(new FocusAdapter((Window)object){
            final /* synthetic */ Window val$win;
            {
                this.val$win = window;
            }

            public void focusLost(FocusEvent focusEvent) {
                this.val$win.setVisible(false);
                this.val$win.dispose();
            }
        });
        jToolTip.addMouseListener(new MouseAdapter((Window)object){
            final /* synthetic */ Window val$win;
            {
                this.val$win = window;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.val$win.setVisible(false);
                this.val$win.dispose();
                ResourcePanelImpl.this.resourceCheckBox.requestFocusInWindow();
            }
        });
        ((Window)object).setVisible(true);
    }

    private void applicationRadioActionPerformed(ActionEvent actionEvent) {
        this.setStorageLevelToValue(0);
        this.loadKeys();
        this.updateControls();
    }

    private void classRadioActionPerformed(ActionEvent actionEvent) {
        this.setStorageLevelToValue(2);
        this.loadKeys();
        this.updateControls();
    }

    private void resourceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enablePanel(this.resourceCheckBox.isSelected());
        this.fireChange();
    }

    private void i18nCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.resourceValue.setInternationalized(this.i18nCheckBox.isSelected());
    }

    private void valueTextFieldActionPerformed(ActionEvent actionEvent) {
        this.setValue(null, this.getValueFieldText(), null);
        if (this.resourceValue != null && this.resourceValue.getValue() != null) {
            if (this.isValidValue()) {
                this.fireChange();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void keyComboActionPerformed(ActionEvent actionEvent) {
        if (this.ignoreCombo) {
            return;
        }
        String string = (String)this.keyCombo.getEditor().getItem();
        if (this.resourceValue.getKey().equals(string)) {
            return;
        }
        ResourceValueImpl resourceValueImpl = this.resources.getResourceValue(string, this.valueType);
        if (resourceValueImpl == null) {
            resourceValueImpl = new ResourceValueImpl(this.resourceValue);
            resourceValueImpl.setKey(string);
            this.resourceValue = resourceValueImpl;
            this.loadKeys();
        } else {
            this.resourceValue = resourceValueImpl;
            this.fireChange();
        }
        this.updateControls();
    }

    private class FormListener
    implements ActionListener,
    MouseListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ResourcePanelImpl.this.resourceCheckBox) {
                ResourcePanelImpl.this.resourceCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ResourcePanelImpl.this.i18nCheckBox) {
                ResourcePanelImpl.this.i18nCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ResourcePanelImpl.this.classRadio) {
                ResourcePanelImpl.this.classRadioActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ResourcePanelImpl.this.applicationRadio) {
                ResourcePanelImpl.this.applicationRadioActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ResourcePanelImpl.this.valueTextField) {
                ResourcePanelImpl.this.valueTextFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == ResourcePanelImpl.this.keyCombo) {
                ResourcePanelImpl.this.keyComboActionPerformed(actionEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ResourcePanelImpl.this.hintLabel) {
                ResourcePanelImpl.this.hintLabelMousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

