/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsOccurrenceFinder
extends OccurrencesFinder<JsParseResult> {
    private boolean cancelled;
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> occurrences;
    private FileObject file;

    public int getPriority() {
        return 200;
    }

    public final Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrences;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    public void run(JsParseResult jsParseResult, SchedulerEvent schedulerEvent) {
        Object object2;
        Object object3;
        Node node;
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        FileObject fileObject = jsParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != this.file) {
            this.occurrences = null;
            this.file = fileObject;
        }
        if ((node = jsParseResult.getRootNode()) == null) {
            return;
        }
        Object object4 = new HashMap(100);
        int n = AstUtilities.getAstOffset((Parser.Result)jsParseResult, this.caretPosition);
        if (n == -1) {
            return;
        }
        AstPath astPath = new AstPath(node, n);
        Node node2 = astPath.leaf();
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        OffsetRange offsetRange = jsParseResult.getSanitizedRange();
        if (offsetRange.containsInclusive(n)) {
            node2 = null;
        }
        if (node2 != null) {
            try {
                boolean bl;
                object3 = AstUtilities.getRange(node2);
                object2 = jsParseResult.getSnapshot().getText();
                Token<? extends JsTokenId> object5 = LexUtilities.getToken(jsParseResult.getSnapshot(), n);
                boolean bl2 = object5 != null && object5.id() == JsTokenId.FUNCTION;
                boolean bl3 = node2.getType() == 164;
                boolean bl4 = node2.getType() == 4 && n < node2.getSourceStart() + "return".length();
                boolean bl5 = bl = node2.getType() == 72 && n < node2.getSourceStart() + "yield".length();
                if (bl2 || bl3 || bl4 || bl) {
                    Node node3 = node2;
                    if (bl2) {
                        int n2 = n + "function".length();
                        astPath = new AstPath(node, n2);
                        node3 = astPath.leaf();
                        if (node3.getType() == 163) {
                            node3 = node3.getParentNode();
                        }
                    } else if (node3.getType() == 164) {
                        node3 = node3.getParentNode();
                    } else if (bl4 || bl) {
                        Node node4;
                        for (node4 = node3.getParentNode(); node4 != null && node4.getType() != 108; node4 = node4.getParentNode()) {
                        }
                        if (node4 != null) {
                            node3 = node4;
                        }
                    }
                    this.highlightExits(node3, (Map<OffsetRange, ColoringAttributes>)object4, jsParseResult);
                    node2 = null;
                } else if (node2.getType() == 38 && object3.getStart() != -1 && object3.getEnd() != -1 && GsfUtilities.getRowStart(object2, (int)object3.getStart()) != GsfUtilities.getRowStart(object2, (int)object3.getEnd())) {
                    node2 = null;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        if (node2 != null && AstUtilities.isNameNode(node2)) {
            object3 = node2.getString();
            object2 = variableVisitor.getVarOccurrences(node2);
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Node node5 = (Node)iterator.next();
                    OffsetRange offsetRange2 = AstUtilities.getNameRange(node5);
                    object4.put(offsetRange2, ColoringAttributes.MARK_OCCURRENCES);
                }
            } else {
                Node node6 = variableVisitor.getDefiningScope(node2);
                this.addNodes(node6 != null ? node6 : node, (String)object3, (Map<OffsetRange, ColoringAttributes>)object4);
            }
            node2 = null;
        }
        if (this.isCancelled()) {
            return;
        }
        if (object4.size() > 0) {
            object3 = new HashMap(2 * object4.size());
            for (Map.Entry entry : object4.entrySet()) {
                OffsetRange offsetRange3 = LexUtilities.getLexerOffsets(jsParseResult, (OffsetRange)entry.getKey());
                if (offsetRange3 == OffsetRange.NONE) continue;
                object3.put(offsetRange3, entry.getValue());
            }
            this.occurrences = object4 = object3;
        } else {
            this.occurrences = null;
        }
    }

    private void addNodes(Node node, String string, Map<OffsetRange, ColoringAttributes> map) {
        Node node2;
        if (AstUtilities.isNameNode(node) && string.equals(node.getString())) {
            node2 = AstUtilities.getNameRange(node);
            map.put((OffsetRange)node2, ColoringAttributes.MARK_OCCURRENCES);
        }
        if (node.hasChildren()) {
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.addNodes(node2, string, map);
            }
        }
    }

    private void highlightExits(Node node, Map<OffsetRange, ColoringAttributes> map, JsParseResult jsParseResult) {
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.highlightExitPoints(node2, map, jsParseResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightExitPoints(Node node, Map<OffsetRange, ColoringAttributes> map, JsParseResult jsParseResult) {
        OffsetRange offsetRange;
        int n = node.getType();
        if (n == 50 || n == 51 || n == 72 || n == 4 && node.getSourceEnd() > node.getSourceStart()) {
            offsetRange = AstUtilities.getRange(node);
            BaseDocument baseDocument = (BaseDocument)jsParseResult.getSnapshot().getSource().getDocument(false);
            if (baseDocument != null) {
                try {
                    int n2;
                    int n3;
                    baseDocument.readLock();
                    OffsetRange offsetRange2 = LexUtilities.getLexerOffsets(jsParseResult, offsetRange);
                    if (offsetRange2 != OffsetRange.NONE && (n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(offsetRange2.getStart(), baseDocument.getLength()))) != (n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(offsetRange2.getEnd(), baseDocument.getLength())))) {
                        offsetRange2 = new OffsetRange(Math.min(offsetRange2.getStart(), baseDocument.getLength()), Utilities.getRowEnd((BaseDocument)baseDocument, (int)Math.min(baseDocument.getLength(), offsetRange2.getStart())));
                        offsetRange = AstUtilities.getAstOffsets((Parser.Result)jsParseResult, offsetRange2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                finally {
                    baseDocument.readUnlock();
                }
                if (offsetRange != OffsetRange.NONE) {
                    map.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        } else if (n == 108 || n == 135) {
            return;
        }
        if (node.hasChildren()) {
            for (offsetRange = node.getFirstChild(); offsetRange != null; offsetRange = offsetRange.getNext()) {
                this.highlightExitPoints((Node)offsetRange, map, jsParseResult);
            }
        }
    }
}

