/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.net.URISyntaxException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class JsClassPathProvider
implements ClassPathProvider {
    public static final String BOOT_CP = "JavascriptBootClassPath";
    private static FileObject jsStubsFO;
    private static ClassPath bootClassPath;

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals(BOOT_CP)) {
            return JsClassPathProvider.getBootClassPath();
        }
        return null;
    }

    public static synchronized ClassPath getBootClassPath() {
        FileObject fileObject;
        if (bootClassPath == null && (fileObject = JsClassPathProvider.getJsStubs()) != null) {
            bootClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{JsClassPathProvider.getJsStubs()});
        }
        return bootClassPath;
    }

    private static FileObject getJsStubs() {
        if (jsStubsFO == null) {
            File file = InstalledFileLocator.getDefault().locate("jsstubs/allstubs.zip", "org.netbeans.modules.javascript.editing", false);
            if (file == null) {
                try {
                    File file2 = new File(JsClassPathProvider.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    file = new File(file2.getParentFile().getParentFile(), "jsstubs/allstubs.zip");
                }
                catch (URISyntaxException uRISyntaxException) {
                    assert (false) : uRISyntaxException;
                    return null;
                }
            }
            assert (file.isFile()) : file;
            jsStubsFO = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)file));
        }
        return jsStubsFO;
    }
}

