/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.codecoverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.Document;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.codecoverage.api.CoverageActionFactory;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.ruby.codecoverage.InstallRCovAction;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyCoverageProvider
implements CoverageProvider {
    private static final String CODE_COVERAGE_TEST_ACTION = "code.coverage.test.action";
    private Map<String, String> hitCounts;
    private Map<String, String> fullNames;
    private long timestamp;
    private Set<String> mimeTypes;
    private Project project;
    private Boolean enabled;
    private Boolean aggregating;
    private static final boolean SKIP_EXCLUSIONS;
    private static final boolean RCOV_RAILS;

    public RubyCoverageProvider(Project project) {
        this.project = project;
        this.mimeTypes = new HashSet<String>();
        this.mimeTypes.add("text/x-ruby");
    }

    public static RubyCoverageProvider get(Project project) {
        return (RubyCoverageProvider)project.getLookup().lookup(RubyCoverageProvider.class);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return true;
    }

    public synchronized boolean isAggregating() {
        if (this.aggregating == null) {
            this.aggregating = CoverageProviderHelper.isAggregating((Project)this.project);
        }
        return this.aggregating;
    }

    public synchronized void setAggregating(boolean bl) {
        if (this.aggregating != null && bl == this.isAggregating()) {
            return;
        }
        this.aggregating = bl;
        CoverageProviderHelper.setAggregating((Project)this.project, (boolean)bl);
    }

    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
        }
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.enabled != null && bl == this.isEnabled()) {
            return;
        }
        this.timestamp = 0L;
        if (bl) {
            GemManager gemManager = RubyPlatform.gemManagerFor((Project)this.project);
            if (gemManager == null || !gemManager.isGemInstalled("rcov")) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RubyCoverageProvider.class, (String)"RcovNotInstalled"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
        } else {
            this.hitCounts = null;
            this.fullNames = null;
        }
        this.enabled = bl;
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)bl);
    }

    private static List<LineCount> getLineCounts(String string) {
        int n;
        int n2 = string.length() / 5;
        ArrayList<LineCount> arrayList = new ArrayList<LineCount>(n2);
        int n3 = string.length();
        int n4 = 0;
        int n5 = -1;
        for (int i = n = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                n4 = Integer.valueOf(string.substring(n, i));
                n = i + 1;
                continue;
            }
            if (c == ',') {
                int n6 = Integer.valueOf(string.substring(n, i));
                if (n5 != -1 && n5 < n4) {
                    for (int j = n5; j <= n4; ++j) {
                        arrayList.add(new LineCount(j, n6));
                    }
                    n5 = -1;
                } else {
                    arrayList.add(new LineCount(n4, n6));
                }
                n = i + 1;
                continue;
            }
            if (c == ' ') {
                n = i + 1;
                continue;
            }
            if (c != '>') continue;
            n5 = Integer.valueOf(string.substring(n, i));
            n = i + 1;
        }
        return arrayList;
    }

    private static FileCoverageSummary createSummary(Project project, String string, List<LineCount> list) {
        Sources sources;
        LineCount lineCount2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (LineCount lineCount2 : list) {
            if (lineCount2.lineno > n) {
                n = lineCount2.lineno;
            }
            if (lineCount2.count == -2) {
                ++n2;
                continue;
            }
            if (lineCount2.count != -1) continue;
            ++n4;
        }
        int n5 = n - n2;
        File file = new File(string);
        lineCount2 = file.exists() ? FileUtil.toFileObject((File)file) : project.getProjectDirectory().getFileObject(string.replace('\\', '/'));
        if (lineCount2 == null && (sources = (Sources)project.getLookup().lookup(Sources.class)) != null) {
            String string2 = "ruby";
            for (SourceGroup sourceGroup : sources.getSourceGroups(string2)) {
                FileObject fileObject = sourceGroup.getRootFolder();
                lineCount2 = string.indexOf(92) != -1 ? fileObject.getFileObject(string.replace("\\", "/")) : fileObject.getFileObject(string);
                if (lineCount2 != null) break;
            }
        }
        sources = new FileCoverageSummary((FileObject)lineCount2, string, n, n5, n4, n3);
        return sources;
    }

    public synchronized List<FileCoverageSummary> getResults() {
        ArrayList<FileCoverageSummary> arrayList = new ArrayList<FileCoverageSummary>();
        this.update();
        if (this.hitCounts == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.hitCounts.entrySet()) {
            String string = entry.getKey();
            if ("fcntl".equals(string)) continue;
            List<LineCount> list = RubyCoverageProvider.getLineCounts(entry.getValue());
            FileCoverageSummary fileCoverageSummary = RubyCoverageProvider.createSummary(this.project, string, list);
            arrayList.add(fileCoverageSummary);
        }
        return arrayList;
    }

    public static Action createCoverageAction(Project project) {
        InstallRCovAction installRCovAction = new InstallRCovAction(project);
        if (!installRCovAction.isEnabled()) {
            installRCovAction = null;
        }
        return CoverageActionFactory.createCollectorAction((Action)installRCovAction, null);
    }

    public synchronized void clear() {
        File file = this.getRubyCoverageFile();
        if (file.exists()) {
            file.delete();
        }
        if ((file = this.getNbCoverageFile()).exists()) {
            file.delete();
        }
        this.hitCounts = null;
        this.fullNames = null;
        this.timestamp = 0L;
    }

    public synchronized FileCoverageDetails getDetails(FileObject fileObject, Document document) {
        Object object;
        String string;
        this.update();
        if (this.hitCounts == null) {
            return null;
        }
        String string2 = FileUtil.toFile((FileObject)fileObject).getPath();
        if (string2 == null) {
            return null;
        }
        String string3 = this.hitCounts.get(string2);
        if (string3 == null) {
            string3 = this.hitCounts.get(string2.toLowerCase());
        }
        if (string3 == null && (string = this.fullNames.get(((String)(object = fileObject.getNameExt())).toLowerCase())) != null && !string.equalsIgnoreCase(string2)) {
            string3 = this.hitCounts.get(string);
        }
        if (string3 != null) {
            object = RubyCoverageProvider.getLineCounts(string3);
            int n = 0;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                LineCount lineCount = (LineCount)object2.next();
                if (lineCount.lineno <= n) continue;
                n = lineCount.lineno;
            }
            object2 = new int[n + 1];
            for (int i = 0; i < n + 1; ++i) {
                object2[i] = -1;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                LineCount lineCount = (LineCount)iterator.next();
                assert (lineCount.lineno >= 0);
                object2[((LineCount)lineCount).lineno] = lineCount.count;
            }
            return new RubyFileCoverageDetails(fileObject, (int[])object2, this.project, string2, (List<LineCount>)object, this.timestamp);
        }
        return null;
    }

    public Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    private File getNbCoverageDir() {
        return new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory().getFileObject("nbproject")), "private" + File.separator + "coverage");
    }

    private File getNbCoverageFile() {
        return new File(this.getNbCoverageDir(), ".nbcoverage");
    }

    private File getRubyCoverageFile() {
        return new File(this.getNbCoverageDir(), ".coverage");
    }

    public synchronized void notifyProjectOpened() {
        CoverageManager.INSTANCE.setEnabled(this.project, true);
    }

    public void setAvailable(boolean bl) {
        CoverageManager.INSTANCE.setEnabled(this.project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update() {
        block20: {
            File file = this.getRubyCoverageFile();
            if (!file.exists()) {
                return;
            }
            File file2 = this.getNbCoverageFile();
            if (file2.exists() && this.timestamp < file2.lastModified()) {
                this.timestamp = file2.lastModified();
                this.hitCounts = new HashMap<String, String>();
                this.fullNames = new HashMap<String, String>();
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(file2));
                    while (true) {
                        try {
                            while (true) {
                                String string = bufferedReader.readLine();
                                String string2 = bufferedReader.readLine();
                                if (string == null) break block20;
                                if (string2 == null) {
                                    break block20;
                                }
                                int n = Math.max(string.lastIndexOf(92), string.lastIndexOf(47));
                                String string3 = string;
                                if (n != -1) {
                                    string3 = string.substring(n + 1);
                                }
                                this.fullNames.put(string3.toLowerCase(), string);
                                this.hitCounts.put(string, string2);
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                }
            }
        }
    }

    public RubyExecutionDescriptor wrapWithCoverage(final RubyExecutionDescriptor rubyExecutionDescriptor, boolean bl, String string) {
        Object object;
        Object object2;
        RubyPlatform rubyPlatform = rubyExecutionDescriptor.getPlatform();
        File file = new File(rubyPlatform.getInterpreterFile().getParentFile(), "rcov");
        if (!(file.exists() || (file = new File(rubyPlatform.getInterpreterFile().getParentFile(), "rcov.bat")).exists() || (file = new File(rubyPlatform.getInterpreterFile().getParentFile(), "rcov.cmd")).exists())) {
            Logger.getLogger(RubyCoverageProvider.class.getName()).log(Level.WARNING, "Warning: RCov not found at " + file.getPath());
            return rubyExecutionDescriptor;
        }
        File file2 = this.getNbCoverageDir();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        File file3 = installedFileLocator.locate("coverage/rcov_wrapper.rb", "org-netbeans-modules-ruby-codecoverage.jar", false);
        assert (file3 != null);
        String string2 = file3.getPath();
        ArrayList<String> arrayList = new ArrayList<String>(20);
        File file4 = this.getNbCoverageFile();
        File file5 = this.getRubyCoverageFile();
        arrayList.add(file5.getPath());
        arrayList.add(file4.getPath());
        boolean bl2 = this.isAggregating();
        HashMap<String, Object> hashMap = rubyExecutionDescriptor.getAdditionalEnvironment();
        if (!bl) {
            arrayList.add(file.getPath());
            this.buildRcovArgs(null, arrayList, bl2, string, rubyExecutionDescriptor);
        }
        arrayList.add(rubyExecutionDescriptor.getScript());
        String string3 = rubyExecutionDescriptor.getInitialArgsPlain();
        if (bl) {
            hashMap = new HashMap<String, Object>(hashMap);
            object2 = installedFileLocator.locate("coverage/rake_wrapper.rb", "org-netbeans-modules-ruby-codecoverage.jar", false);
            assert (object2 != null);
            hashMap.put("NB_RAKE_WRAPPER", ((File)object2).getPath());
            hashMap.put("NB_RCOV_PATH", file.getPath());
            if (string3 != null && ((String[])(object = Utilities.parseParameters((String)string3))).length == 2 && "-r".equals(object[0])) {
                hashMap.put("NB_DELEGATED_SCRIPT", object[1]);
                string3 = "-r \"" + ((File)object2).getPath() + "\"";
            }
            if (!bl2) {
                this.clear();
            }
            object = new StringBuilder();
            this.buildRcovArgs((StringBuilder)object, null, true, string, rubyExecutionDescriptor);
            hashMap.put("NB_RCOV_ARGS", ((StringBuilder)object).toString());
        }
        if ((object2 = rubyExecutionDescriptor.getAdditionalArgs()) != null) {
            if (!bl) {
                arrayList.add("--");
            }
            for (RubyExecutionDescriptor rubyExecutionDescriptor2 : object2) {
                arrayList.add((String)rubyExecutionDescriptor2);
            }
        }
        object2 = arrayList.toArray(new String[arrayList.size()]);
        object = new RubyExecutionDescriptor(rubyExecutionDescriptor);
        object.addAdditionalEnv(hashMap);
        object.initialArgs(string3);
        object.script(string2);
        object.additionalArgs((String[])object2);
        HideCoverageFramesConvertor hideCoverageFramesConvertor = new HideCoverageFramesConvertor();
        object.addOutConvertor((LineConvertor)hideCoverageFramesConvertor);
        object.addErrConvertor((LineConvertor)hideCoverageFramesConvertor);
        object.postBuild(new Runnable(){

            public void run() {
                RubyCoverageProvider.this.update();
                CoverageManager.INSTANCE.resultsUpdated(RubyCoverageProvider.this.project, (CoverageProvider)RubyCoverageProvider.this);
                if (rubyExecutionDescriptor.getPostBuild() != null) {
                    rubyExecutionDescriptor.getPostBuild().run();
                }
            }
        });
        return object;
    }

    public String getTestAllAction() {
        String string;
        PropertyEvaluator propertyEvaluator;
        if (this.project != null && (propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null && (string = propertyEvaluator.getProperty(CODE_COVERAGE_TEST_ACTION)) != null) {
            return string;
        }
        return null;
    }

    private void buildRcovArgs(StringBuilder stringBuilder, List<String> list, boolean bl, String string, RubyExecutionDescriptor rubyExecutionDescriptor) {
        String string2 = this.getRubyCoverageFile().getPath();
        if (bl) {
            if (list != null) {
                list.add("--aggregate");
                list.add(string2);
            } else {
                stringBuilder.append(" --aggregate \"");
                stringBuilder.append(string2);
                stringBuilder.append("\"");
            }
        }
        if (list != null) {
            list.add("--save");
            list.add(string2);
        } else {
            stringBuilder.append(" --save \"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        if (list != null) {
            list.add("--no-html");
        } else {
            stringBuilder.append(" --no-html");
        }
        if (string == null && rubyExecutionDescriptor.getFileObject() != null) {
            string = rubyExecutionDescriptor.getFileObject().getNameExt();
        }
        if (string != null) {
            string = string.substring(Math.max(string.lastIndexOf(92), string.lastIndexOf(47)) + 1);
            if (list != null) {
                list.add("--include-file");
                list.add(string);
            } else {
                stringBuilder.append(" --include-file \"");
                stringBuilder.append(string);
                stringBuilder.append("\"");
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder(100);
        stringBuilder2.append("\\/ruby2\\/,/\\\\ruby2\\\\/");
        stringBuilder2.append(",\\bfcntl\\b");
        stringBuilder2.append(",/\\bvendor\\//");
        RubyPlatform rubyPlatform = rubyExecutionDescriptor.getPlatform();
        if (rubyPlatform != null) {
            String string3;
            GemManager gemManager;
            String string4 = rubyPlatform.getHome().getPath();
            stringBuilder2.append(',');
            stringBuilder2.append(string4.replace("/", "\\/"));
            if (File.separatorChar == '\\') {
                stringBuilder2.append(string4.replace('\\', '/').replace("/", "\\/"));
            }
            if (rubyPlatform.hasRubyGemsInstalled() && (gemManager = rubyPlatform.getGemManager()) != null && (string3 = gemManager.getGemHome()) != null && !string3.startsWith(string4)) {
                stringBuilder2.append(',');
                stringBuilder2.append(string3.replace("/", "\\/"));
                if (File.separatorChar == '\\') {
                    stringBuilder2.append(string3.replace('\\', '/').replace("/", "\\/"));
                }
            }
        }
        if (SKIP_EXCLUSIONS) {
            if (list != null) {
                list.add("--exclude-only");
                list.add("thisstringdefinitelydoesnotexist");
            } else {
                stringBuilder.append(" --exclude-only \"thisstringdefinitelydoesnotexist\"");
            }
        } else if (list != null) {
            list.add("--exclude-only");
            list.add(stringBuilder2.toString());
        } else {
            stringBuilder.append(" --exclude-only \"");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append("\"");
        }
        if (RCOV_RAILS && this.project.getClass().getSimpleName().contains("Rails")) {
            if (list != null) {
                list.add("--rails");
            } else {
                stringBuilder.append(" --rails");
            }
        }
    }

    static {
        String string = System.getProperty("coverage.exclude");
        SKIP_EXCLUSIONS = string != null && "true".equals(string);
        String string2 = System.getProperty("coverage.rcov-rails");
        RCOV_RAILS = string2 == null || "true".equals(string2);
    }

    private static class LineCount {
        private final int lineno;
        private final int count;

        public LineCount(int n, int n2) {
            this.lineno = n;
            this.count = n2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LineCount lineCount = (LineCount)object;
            return this.lineno == lineCount.lineno;
        }

        public int hashCode() {
            int n = 7;
            n = 59 * n + this.lineno;
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RubyFileCoverageDetails
    implements FileCoverageDetails {
        private final int[] hitCounts;
        private final String fileName;
        private final List<LineCount> lineCounts;
        private Project project;
        private final long lastUpdated;
        private final FileObject fileObject;

        public RubyFileCoverageDetails(FileObject fileObject, int[] nArray, Project project, String string, List<LineCount> list, long l) {
            this.fileObject = fileObject;
            this.hitCounts = nArray;
            this.project = project;
            this.fileName = string;
            this.lineCounts = list;
            this.lastUpdated = l;
        }

        public int getLineCount() {
            return this.hitCounts.length;
        }

        public boolean hasHitCounts() {
            return true;
        }

        public FileCoverageSummary getSummary() {
            return RubyCoverageProvider.createSummary(this.project, this.fileName, this.lineCounts);
        }

        public CoverageType getType(int n) {
            int n2 = this.hitCounts[n];
            switch (n2) {
                case -3: {
                    return CoverageType.UNKNOWN;
                }
                case -2: {
                    return CoverageType.NOT_COVERED;
                }
                case -1: {
                    return CoverageType.INFERRED;
                }
            }
            return CoverageType.COVERED;
        }

        public int getHitCount(int n) {
            return this.hitCounts[n];
        }

        public long lastUpdated() {
            return this.lastUpdated;
        }

        public FileObject getFile() {
            return this.fileObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HideCoverageFramesConvertor
    implements LineConvertor {
        private HideCoverageFramesConvertor() {
        }

        public List<ConvertedLine> convert(String string) {
            if (string.contains("/ruby2/coverage/") || string.contains("/rcov") || File.separatorChar == '\\' && (string.contains("\\ruby2\\coverage\\") || string.contains("\\rcov"))) {
                return Collections.emptyList();
            }
            return null;
        }
    }
}

