/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.Reason;
import org.netbeans.modules.php.dbgp.packets.StackGetCommand;
import org.netbeans.modules.php.dbgp.packets.Status;
import org.netbeans.modules.php.dbgp.packets.StopCommand;
import org.w3c.dom.Node;

public class StatusResponse
extends DbgpResponse {
    private static final String REASON = "reason";
    private static final String STATUS = "status";

    StatusResponse(Node node) {
        super(node);
    }

    public Status getStatus() {
        String string = StatusResponse.getAttribute(this.getNode(), STATUS);
        return Status.forString(string);
    }

    public Reason getReason() {
        String string = StatusResponse.getAttribute(this.getNode(), REASON);
        return Reason.forString(string);
    }

    public void process(DebugSession debugSession, DbgpCommand dbgpCommand) {
        Status status = this.getStatus();
        Reason reason = this.getReason();
        assert (status != null);
        assert (reason != null);
        debugSession.setStatus(status);
        if (status.isBreak() && reason.isOK()) {
            StackGetCommand stackGetCommand = new StackGetCommand(debugSession.getTransactionId());
            debugSession.sendCommandLater(stackGetCommand);
            DebugSession.IDESessionBridge iDESessionBridge = debugSession.getBridge();
            if (iDESessionBridge != null) {
                iDESessionBridge.setSuspended(true);
                StatusResponse.updateThreadsModel(iDESessionBridge, debugSession);
            }
        } else if ((status.isStopping() || status.isStopped()) && reason.isOK()) {
            SessionProgress sessionProgress;
            StopCommand stopCommand = new StopCommand(debugSession.getTransactionId());
            debugSession.sendCommandLater(stopCommand);
            debugSession.cancel();
            if (debugSession.getOptions().isDebugForFirstPageOnly() && (sessionProgress = SessionProgress.forSessionId(debugSession.getSessionId())) != null) {
                sessionProgress.cancel();
                return;
            }
            this.setNextSessionAsCurrent();
        }
    }

    private void setNextSessionAsCurrent() {
        Session[] sessionArray;
        for (Session session : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            if (session.lookupFirst(null, DebugSession.class) != null) continue;
            DebuggerManager.getDebuggerManager().setCurrentSession(session);
            break;
        }
    }

    private static void updateThreadsModel(DebugSession.IDESessionBridge iDESessionBridge, DebugSession debugSession) {
        ThreadsModel threadsModel = iDESessionBridge.getThreadsModel();
        if (threadsModel != null) {
            threadsModel.updateSession(debugSession);
        }
    }
}

