/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.packets.BreakResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetResponse;
import org.netbeans.modules.php.dbgp.packets.BrkpntUpdateResponse;
import org.netbeans.modules.php.dbgp.packets.ContextGetResponse;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpStream;
import org.netbeans.modules.php.dbgp.packets.EvalResponse;
import org.netbeans.modules.php.dbgp.packets.ExecResponse;
import org.netbeans.modules.php.dbgp.packets.ExprResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureGetResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureSetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyGetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertySetResponse;
import org.netbeans.modules.php.dbgp.packets.PropertyValueResponse;
import org.netbeans.modules.php.dbgp.packets.SourceResponse;
import org.netbeans.modules.php.dbgp.packets.StackDepthResponse;
import org.netbeans.modules.php.dbgp.packets.StackGetResponse;
import org.netbeans.modules.php.dbgp.packets.StatusResponse;
import org.netbeans.modules.php.dbgp.packets.StreamResponse;
import org.netbeans.modules.php.dbgp.packets.TypeMapGetResponse;
import org.w3c.dom.Node;

class MessageBuilder {
    private static final String TYPE = "type";

    private MessageBuilder() {
    }

    static DbgpMessage createStream(Node node) {
        Node node2 = node.getAttributes().getNamedItem(TYPE);
        assert (node2 != null);
        String string = node2.getNodeValue();
        if (DbgpStream.StreamType.STDOUT.equals(string)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDOUT);
        }
        if (DbgpStream.StreamType.STDERR.equals(string)) {
            return new DbgpStream(node, DbgpStream.StreamType.STDERR);
        }
        assert (false);
        return null;
    }

    static DbgpMessage createResponse(Node node) {
        String string = DbgpMessage.getAttribute(node, "command");
        assert (string != null);
        if (string.equals("run") || string.equals("status") || string.equals("step_out") || string.equals("step_over") || string.equals("step_into") || string.equals("stop")) {
            return new StatusResponse(node);
        }
        if (string.equals("breakpoint_set")) {
            return new BrkpntSetResponse(node);
        }
        if (string.equals("breakpoint_update")) {
            return new BrkpntUpdateResponse(node);
        }
        if (string.equals("breakpoint_remove")) {
            return new BrkpntRemoveResponse(node);
        }
        if (string.equals("context_names")) {
            return new ContextNamesResponse(node);
        }
        if (string.equals("context_get")) {
            return new ContextGetResponse(node);
        }
        if (string.equals("stack_depth")) {
            return new StackDepthResponse(node);
        }
        if (string.equals("stack_get")) {
            return new StackGetResponse(node);
        }
        if (string.equals("typemap_get")) {
            return new TypeMapGetResponse(node);
        }
        if (string.equals("property_set")) {
            return new PropertySetResponse(node);
        }
        if (string.equals("property_get")) {
            return new PropertyGetResponse(node);
        }
        if (string.equals("property_value")) {
            return new PropertyValueResponse(node);
        }
        if (string.equals("source")) {
            return new SourceResponse(node);
        }
        if (string.equals(DbgpStream.StreamType.STDERR.toString()) || string.equals(DbgpStream.StreamType.STDOUT.toString())) {
            return new StreamResponse(node);
        }
        if (string.equals("feature_get")) {
            return new FeatureGetResponse(node);
        }
        if (string.equals("feature_set")) {
            return new FeatureSetResponse(node);
        }
        if (string.equals("break")) {
            return new BreakResponse(node);
        }
        if (string.equals("eval")) {
            return new EvalResponse(node);
        }
        if (string.equals("expr")) {
            return new ExprResponse(node);
        }
        if (string.equals("exec")) {
            return new ExecResponse(node);
        }
        return null;
    }
}

