/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public abstract class DbgpCommand {
    private static final String DATA_SEPARATOR = " -- ";
    private static final String TRANSACTION_OPT = " -i ";
    private String myCommand;
    private String myTransaction;

    DbgpCommand(String string, String string2) {
        this.myCommand = string;
        this.myTransaction = string2;
    }

    public void send(OutputStream outputStream) throws IOException {
        Object object;
        String string = null;
        if (this.getData() != null) {
            object = new BASE64Encoder();
            string = object.encode(this.getData().getBytes("ISO-8859-1"));
        }
        object = new StringBuilder(this.myCommand);
        ((StringBuilder)object).append(this.getArgumentString());
        if (string != null) {
            ((StringBuilder)object).append(DATA_SEPARATOR);
            ((StringBuilder)object).append(string);
        }
        Logger.getLogger(DbgpCommand.class.getName()).fine("command to send : " + object);
        byte[] byArray = ((StringBuilder)object).toString().getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        outputStream.write(byArray2);
        outputStream.flush();
    }

    public String getTransactionId() {
        return this.myTransaction;
    }

    public abstract boolean wantAcknowledgment();

    protected String getData() {
        return null;
    }

    protected String getArguments() {
        return "";
    }

    private String getArgumentString() {
        if (this.getArguments() != null && this.getArguments().length() > 0) {
            return TRANSACTION_OPT + this.myTransaction + " " + this.getArguments();
        }
        return TRANSACTION_OPT + this.myTransaction;
    }
}

