/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models.nodes;

import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextNode
extends AbstractModelNode
implements ModelNode {
    private static final String SUPER_GLOBAL = "Superglobals";
    private static final String SUPER_ICON = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private final String myName;
    private final int myIndex;

    protected ContextNode(ContextNamesResponse.Context context, List<Property> list) {
        super(null, list);
        this.myName = context.getContext();
        this.myIndex = context.getId();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getVaraibleSize() {
        return this.getVariables().size();
    }

    @Override
    public ModelNode[] getChildren(int n, int n2) {
        List<AbstractVariableNode> list = this.getVariables().subList(n, n2);
        return list.toArray(new ModelNode[list.size()]);
    }

    @Override
    public int getChildrenSize() {
        return this.getVariables().size();
    }

    @Override
    public String getIconBase() {
        if (this.isGlobal()) {
            return SUPER_ICON;
        }
        return null;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildrenSize() == 0;
    }

    public boolean equalsTo(ContextNode contextNode) {
        String string = contextNode.myName;
        if (string == null) {
            return this.myName == null;
        }
        return string.equals(this.myName);
    }

    public boolean isGlobal() {
        return SUPER_GLOBAL.equals(this.getDbgpName());
    }

    @Override
    protected boolean isTypeApplied(Set<VariablesModelFilter.FilterType> set) {
        if (!set.contains((Object)VariablesModelFilter.FilterType.SUPERGLOBALS)) {
            return !this.isGlobal();
        }
        return true;
    }

    private String getDbgpName() {
        return this.myName;
    }
}

