/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    private static final String LINE_NUMBER = "lineNumber";
    private static final String URL = "url";
    private static final String ENABED = "enabled";
    private static final String FUNC_NAME = "functionName";
    private static final String TYPE = "type";

    public String[] getSupportedClassNames() {
        return new String[]{LineBreakpoint.class.getName(), FunctionBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        if (string.equals(LineBreakpoint.class.getName())) {
            Line line = this.getLine(properties.getString(URL, null), properties.getInt(LINE_NUMBER, 1));
            if (line == null) {
                return null;
            }
            LineBreakpoint lineBreakpoint = new LineBreakpoint(line);
            if (!properties.getBoolean(ENABED, true)) {
                lineBreakpoint.disable();
            }
            return new LineBreakpoint(line);
        }
        if (string.equals(FunctionBreakpoint.class.getName())) {
            String string2 = properties.getString(FUNC_NAME, null);
            FunctionBreakpoint.Type type = FunctionBreakpoint.Type.forString(properties.getString(TYPE, null));
            if (string2 == null || type == null) {
                return null;
            }
            return new FunctionBreakpoint(type, string2);
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            FileObject fileObject = (FileObject)lineBreakpoint.getLine().getLookup().lookup(FileObject.class);
            try {
                properties.setString(URL, fileObject.getURL().toString());
                properties.setInt(LINE_NUMBER, lineBreakpoint.getLine().getLineNumber());
                properties.setBoolean(ENABED, lineBreakpoint.isEnabled());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.log(fileStateInvalidException);
            }
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = functionBreakpoint.getFunction();
            properties.setString(FUNC_NAME, string);
            properties.setString(TYPE, functionBreakpoint.getType().toString());
            properties.setBoolean(ENABED, functionBreakpoint.isEnabled());
        }
    }

    private void log(FileStateInvalidException fileStateInvalidException) {
        Logger.getLogger(BreakpointsReader.class.getName()).log(Level.SEVERE, null, fileStateInvalidException);
    }

    private Line getLine(String string, int n) {
        FileObject fileObject = this.getFileObject(string);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private FileObject getFileObject(String string) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return fileObject;
    }
}

