/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntUpdateCommand;

public class BreakpointRuntimeSetter
extends DebuggerManagerAdapter {
    private String[] myProperties;

    public String[] getProperties() {
        if (this.myProperties == null) {
            this.myProperties = new String[]{"breakpoints"};
        }
        return this.myProperties;
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.performCommand(breakpoint, Lazy.SET_COMMAND);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.performCommand(breakpoint, Lazy.REMOVE_COMMAND);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"enabled".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        this.performCommand((Breakpoint)object, Lazy.UPDATE_COMMAND);
    }

    private void performCommand(Breakpoint breakpoint, Command command) {
        Session[] sessionArray;
        if (!(breakpoint instanceof AbstractBreakpoint)) {
            return;
        }
        AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)breakpoint;
        for (Session session : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
            if (sessionId == null) continue;
            SessionManager sessionManager = SessionManager.getInstance();
            List<DebugSession> list = sessionManager.findSessionsById(sessionId);
            for (DebugSession debugSession : list) {
                command.perform(abstractBreakpoint, sessionId, debugSession);
            }
        }
    }

    private static class Lazy {
        static final Command SET_COMMAND = new SetBreakpointCommand();
        static final Command REMOVE_COMMAND = new RemoveBreakpointCommand();
        static final Command UPDATE_COMMAND = new UpdateBreakpointCommand();

        private Lazy() {
        }
    }

    private static class UpdateBreakpointCommand
    implements Command {
        private UpdateBreakpointCommand() {
        }

        public void perform(AbstractBreakpoint abstractBreakpoint, SessionId sessionId, DebugSession debugSession) {
            BrkpntUpdateCommand brkpntUpdateCommand = new BrkpntUpdateCommand(debugSession.getTransactionId(), abstractBreakpoint.getBreakpointId());
            BrkpntSetCommand.State state = abstractBreakpoint.isEnabled() ? BrkpntSetCommand.State.ENABLED : BrkpntSetCommand.State.DISABLED;
            brkpntUpdateCommand.setState(state);
            debugSession.sendCommandLater(brkpntUpdateCommand);
        }
    }

    private static class RemoveBreakpointCommand
    implements Command {
        private RemoveBreakpointCommand() {
        }

        public void perform(AbstractBreakpoint abstractBreakpoint, SessionId sessionId, DebugSession debugSession) {
            if (!abstractBreakpoint.isSessionRelated(debugSession)) {
                return;
            }
            BrkpntRemoveCommand brkpntRemoveCommand = new BrkpntRemoveCommand(debugSession.getTransactionId(), abstractBreakpoint.getBreakpointId());
            debugSession.sendCommandLater(brkpntRemoveCommand);
        }
    }

    private static class SetBreakpointCommand
    implements Command {
        private SetBreakpointCommand() {
        }

        public void perform(AbstractBreakpoint abstractBreakpoint, SessionId sessionId, DebugSession debugSession) {
            BrkpntSetCommand brkpntSetCommand = Utils.getCommand(debugSession, sessionId, abstractBreakpoint);
            if (brkpntSetCommand != null) {
                debugSession.sendCommandLater(brkpntSetCommand);
            }
        }
    }

    private static interface Command {
        public void perform(AbstractBreakpoint var1, SessionId var2, DebugSession var3);
    }
}

