/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.insane.model.HeapModel;
import org.netbeans.insane.model.Item;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlHeapModel
implements HeapModel {
    private Map<Integer, Item> items = new HashMap<Integer, Item>();
    private Map<String, Item> roots = new HashMap<String, Item>();

    public static HeapModel parse(File file) throws Exception {
        XmlHeapModel xmlHeapModel = new XmlHeapModel(new InputSource(new FileInputStream(file)));
        return xmlHeapModel;
    }

    @Override
    public Iterator<Item> getAllItems() {
        return Collections.unmodifiableCollection(this.items.values()).iterator();
    }

    @Override
    public Collection<Item> getObjectsOfType(String string) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        Iterator<Item> iterator = this.getAllItems();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            if (!string.equals(item.getType())) continue;
            arrayList.add(item);
        }
        return arrayList;
    }

    @Override
    public Collection<String> getRoots() {
        return Collections.unmodifiableSet(this.roots.keySet());
    }

    @Override
    public Item getObjectAt(String string) {
        return this.roots.get(string);
    }

    @Override
    public Item getItem(int n) {
        Item item = this.items.get(new Integer(n));
        if (item == null) {
            throw new IllegalArgumentException("Bad ID");
        }
        return item;
    }

    private XmlHeapModel(InputSource inputSource) throws Exception {
        Handler handler = new Handler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.getXMLReader().setContentHandler(handler);
        sAXParser.getXMLReader().parse(inputSource);
    }

    Item createItem(int n, String string, int n2, String string2) {
        MemItem memItem = new MemItem(n, string, n2, string2);
        this.items.put(new Integer(n), memItem);
        return memItem;
    }

    void addReference(int n, int n2) {
        MemItem memItem = (MemItem)this.getItem(n);
        MemItem memItem2 = (MemItem)this.getItem(n2);
        memItem.addOutgoing(memItem2);
        memItem2.addIncomming(memItem);
    }

    void addReference(String string, int n) {
        MemItem memItem = (MemItem)this.getItem(n);
        memItem.addIncomming(string);
    }

    int getIdFromString(String string) {
        return Integer.parseInt(string, 16);
    }

    private static class RefEnum
    implements Enumeration {
        int ptr;
        Object[] items;

        RefEnum(boolean bl, Object[] objectArray) {
            this.items = objectArray;
            if (!bl) {
                while (objectArray[this.ptr++] != null) {
                }
            }
        }

        public boolean hasMoreElements() {
            return this.ptr < this.items.length && this.items[this.ptr] != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.items[this.ptr++];
            }
            throw new NoSuchElementException();
        }
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;

        private Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.depth == 0) {
                if (!"insane".equals(string3)) {
                    throw new SAXException("format");
                }
            } else {
                if (this.depth != 1) {
                    throw new SAXException("format");
                }
                if ("object".equals(string3)) {
                    String string4 = attributes.getValue("id");
                    String string5 = attributes.getValue("type");
                    String string6 = attributes.getValue("size");
                    String string7 = attributes.getValue("value");
                    XmlHeapModel.this.createItem(XmlHeapModel.this.getIdFromString(string4), string5, Integer.parseInt(string6), string7);
                } else if ("ref".equals(string3)) {
                    String string8 = attributes.getValue("from");
                    String string9 = attributes.getValue("name");
                    String string10 = attributes.getValue("to");
                    if (string8 != null) {
                        XmlHeapModel.this.addReference(XmlHeapModel.this.getIdFromString(string8), XmlHeapModel.this.getIdFromString(string10));
                    } else {
                        XmlHeapModel.this.addReference(string9, XmlHeapModel.this.getIdFromString(string10));
                    }
                } else {
                    throw new SAXException("format");
                }
            }
            ++this.depth;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.depth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemItem
    implements Item {
        private Object[] refs = new Object[]{null};
        private int id;
        private int size;
        private String type;
        private String value;

        MemItem(int n, String string, int n2, String string2) {
            this.id = n;
            this.type = string.intern();
            this.size = n2;
            this.value = string2;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Enumeration<Object> incomming() {
            return new RefEnum(true, this.refs);
        }

        @Override
        public Enumeration<Item> outgoing() {
            return new RefEnum(false, this.refs);
        }

        @Override
        public int getId() {
            return this.id;
        }

        public String toString() {
            if (this.value == null) {
                return this.type + "@" + Integer.toHexString(this.id);
            }
            return this.type + "@" + Integer.toHexString(this.id) + ": \"" + this.value + '\"';
        }

        void addIncomming(Object object) {
            Object[] objectArray = new Object[this.refs.length + 1];
            objectArray[0] = object;
            System.arraycopy(this.refs, 0, objectArray, 1, this.refs.length);
            this.refs = objectArray;
        }

        void addOutgoing(Object object) {
            Object[] objectArray = new Object[this.refs.length + 1];
            objectArray[this.refs.length] = object;
            System.arraycopy(this.refs, 0, objectArray, 0, this.refs.length);
            this.refs = objectArray;
        }
    }
}

