/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BookmarkList {
    private static final String PROP_BOOKMARKS = "bookmarks";
    private static Set<EditorCookie.Observable> observedObservables = new WeakSet();
    private Document document;
    private List bookmarks;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static PropertyChangeListener documentModifiedListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorCookie.Observable observable;
            StyledDocument styledDocument;
            if ("modified".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue()) && (styledDocument = (observable = (EditorCookie.Observable)propertyChangeEvent.getSource()).getDocument()) != null) {
                BookmarkList bookmarkList = BookmarkList.get(styledDocument);
                BookmarksPersistence.saveBookmarks(bookmarkList);
            }
        }
    };
    private static final Comparator<Bookmark> breakpointsComparator = new Comparator<Bookmark>(){

        @Override
        public int compare(Bookmark bookmark, Bookmark bookmark2) {
            return bookmark.getOffset() - bookmark2.getOffset();
        }
    };

    public static BookmarkList get(Document document) {
        BookmarkList bookmarkList = (BookmarkList)document.getProperty(BookmarkList.class);
        if (bookmarkList == null) {
            bookmarkList = new BookmarkList(document);
            document.putProperty(BookmarkList.class, bookmarkList);
        }
        return bookmarkList;
    }

    private BookmarkList(Document document) {
        EditorCookie.Observable observable;
        if (document == null) {
            throw new NullPointerException("Document cannot be null");
        }
        this.document = document;
        this.bookmarks = new ArrayList();
        BookmarksPersistence.loadBookmarks(this);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && (observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class)) != null && !observedObservables.contains(observable)) {
            observable.addPropertyChangeListener(documentModifiedListener);
            observedObservables.add(observable);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public synchronized List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public Bookmark getNextBookmark(int n, boolean bl) {
        this.checkOffsetNonNegative(++n);
        Bookmark bookmark = this.getNextBookmark(n);
        return bookmark != null || !bl ? bookmark : this.getNextBookmark(-1, false);
    }

    public Bookmark getPreviousBookmark(int n, boolean bl) {
        Bookmark bookmark;
        this.checkOffsetNonNegative(n);
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>(this.getBookmarks());
        if (!arrayList.isEmpty()) {
            if ((bookmark = this.getNextBookmark(--n)) == null || bookmark.getOffset() != n) {
                int n2;
                int n3 = n2 = bookmark == null ? arrayList.size() : arrayList.indexOf(bookmark);
                bookmark = --n2 >= 0 ? (Bookmark)arrayList.get(n2) : (bl ? this.getPreviousBookmark(Integer.MAX_VALUE, false) : null);
            }
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    private Bookmark getNextBookmark(int n) {
        int n2 = 0;
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>(this.getBookmarks());
        if (arrayList.isEmpty()) {
            return null;
        }
        int n3 = arrayList.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = ((Bookmark)arrayList.get(n4)).getOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            --n4;
            while (n4 >= 0 && ((Bookmark)arrayList.get(n4)).getOffset() == n) {
                --n4;
            }
            return (Bookmark)arrayList.get(++n4);
        }
        if (n2 < arrayList.size()) {
            return (Bookmark)arrayList.get(n2);
        }
        return null;
    }

    public Bookmark toggleLineBookmark(int n) {
        this.checkOffsetInDocument(n);
        Element element = this.document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Bookmark bookmark = null;
        if (n2 < element.getElementCount()) {
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            bookmark = this.getNextBookmark(n3);
            if (bookmark != null && bookmark.getOffset() < element2.getEndOffset()) {
                this.removeBookmark(bookmark);
            } else {
                bookmark = this.addBookmark(n3);
            }
            BookmarksPersistence.saveBookmarks(this);
        }
        return bookmark;
    }

    public synchronized boolean removeBookmark(Bookmark bookmark) {
        boolean bl = this.bookmarks.remove(bookmark);
        if (bl) {
            bookmark.release();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BookmarkList.this.propertyChangeSupport.firePropertyChange(BookmarkList.PROP_BOOKMARKS, null, null);
                }
            });
        }
        return bl;
    }

    public synchronized void removeAllBookmarks() {
        if (!this.bookmarks.isEmpty()) {
            for (int i = 0; i < this.bookmarks.size(); ++i) {
                Bookmark bookmark = (Bookmark)this.bookmarks.get(i);
                bookmark.release();
            }
            this.bookmarks.clear();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BookmarkList.this.propertyChangeSupport.firePropertyChange(BookmarkList.PROP_BOOKMARKS, null, null);
                }
            });
        }
    }

    public synchronized Bookmark addBookmark(int n) {
        Bookmark bookmark = new Bookmark(this, n);
        this.bookmarks.add(bookmark);
        Collections.sort(this.bookmarks, breakpointsComparator);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BookmarkList.this.propertyChangeSupport.firePropertyChange(BookmarkList.PROP_BOOKMARKS, null, null);
            }
        });
        return bookmark;
    }

    private void checkOffsetNonNegative(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("offset=" + n + " < 0");
        }
    }

    private void checkOffsetInDocument(int n) {
        this.checkOffsetNonNegative(n);
        int n2 = this.document.getLength();
        if (n > n2) {
            throw new IndexOutOfBoundsException("offset=" + n + " > doc.getLength()=" + n2);
        }
    }

    public synchronized String toString() {
        return "Bookmarks: " + this.bookmarks;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

