/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileObjectIterator
implements Iterator<FileObject> {
    private Collection<FileObject> roots;
    private Iterator<FileObject> rootsIterator;
    private Enumeration<? extends FileObject> rootChildrenEnum;

    public FileObjectIterator(Collection<FileObject> collection) {
        this.roots = collection;
    }

    @Override
    public boolean hasNext() {
        if (null == this.rootsIterator) {
            this.rootsIterator = this.roots.iterator();
            return this.rootsIterator.hasNext();
        }
        return null != this.rootChildrenEnum && this.rootChildrenEnum.hasMoreElements() || this.rootsIterator.hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FileObject next() {
        FileObject fileObject = null;
        if (null != this.rootChildrenEnum) {
            if (this.rootChildrenEnum.hasMoreElements()) return this.rootChildrenEnum.nextElement();
        }
        if (!this.rootsIterator.hasNext()) throw new NoSuchElementException();
        fileObject = this.rootsIterator.next();
        this.rootChildrenEnum = fileObject.getChildren(true);
        return fileObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean isUnderRoots(FileObject fileObject) {
        for (FileObject fileObject2 : this.roots) {
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }
}

