/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class SelectKeyboardShortcutPanel
extends JPanel
implements KeyListener {
    private KeyStroke stroke = null;
    private SelectKeyboardShortcutWizardPanel wiz;
    private JTextArea hintsArea;
    private JPanel mainPanel;
    private JTextField testField;

    public SelectKeyboardShortcutPanel(SelectKeyboardShortcutWizardPanel selectKeyboardShortcutWizardPanel) {
        this.wiz = selectKeyboardShortcutWizardPanel;
        this.initComponents();
        this.initAccessibility();
        this.setName(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"SKSP_LBL_select_shortcut_to_add"));
        this.testField.addKeyListener(this);
    }

    private void initAccessibility() {
        this.testField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"ACSN_LBL_type_here"));
        this.testField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"ACSD_LBL_type_here"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"SKSP_TEXT_press_any_key_seq"));
    }

    private void initComponents() {
        this.hintsArea = new JTextArea();
        this.mainPanel = new JPanel();
        this.testField = new JTextField();
        this.setLayout(new BorderLayout());
        this.hintsArea.setBackground(new Color(204, 204, 204));
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setForeground(new Color(102, 102, 153));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setText(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"SKSP_TEXT_press_any_key_seq"));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setEnabled(false);
        this.hintsArea.setOpaque(false);
        this.add((Component)this.hintsArea, "North");
        this.testField.setColumns(15);
        this.testField.setHorizontalAlignment(0);
        this.testField.setText(NbBundle.getMessage(SelectKeyboardShortcutPanel.class, (String)"SKSP_LBL_type_here"));
        this.mainPanel.add(this.testField);
        this.add((Component)this.mainPanel, "Center");
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
        this.testField.setText(Utilities.keyToString((KeyStroke)this.stroke));
        this.wiz.fireChangeEvent();
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectKeyboardShortcutWizardPanel
    implements WizardDescriptor.Panel<ShortcutWizard> {
        private SelectKeyboardShortcutPanel panel = null;
        private FileObject shortcutsFolder = null;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public Component getComponent() {
            return this.getPanel();
        }

        private SelectKeyboardShortcutPanel getPanel() {
            if (this.panel == null) {
                this.panel = new SelectKeyboardShortcutPanel(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            if (this.shortcutsFolder == null) {
                this.shortcutsFolder = FileUtil.getConfigFile((String)"Shortcuts");
            }
            return this.getPanel().stroke != null && this.shortcutsFolder.getFileObject(Utilities.keyToString((KeyStroke)this.getPanel().stroke), "instance") == null && this.shortcutsFolder.getFileObject(Utilities.keyToString((KeyStroke)this.getPanel().stroke), "xml") == null;
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        protected final void fireChangeEvent() {
            this.cs.fireChange();
        }

        public void readSettings(ShortcutWizard shortcutWizard) {
        }

        public void storeSettings(ShortcutWizard shortcutWizard) {
            shortcutWizard.putProperty("wizdata.stroke", this.getPanel().stroke);
        }
    }
}

