/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.jdesktop.layout.GroupLayout;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class IntroPanel
extends JPanel {
    private IntroWizardPanel wiz;
    private JCheckBox customizeCheck;
    private JTextArea hintsArea;
    private JCheckBox keyboardCheck;
    private JCheckBox menuCheck;
    private JCheckBox toolbarCheck;

    public IntroPanel(IntroWizardPanel introWizardPanel) {
        this.wiz = introWizardPanel;
        this.initComponents();
        this.initAccessibility();
        this.setName(NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cfg_basic_opts"));
    }

    public void requestFocus() {
        super.requestFocus();
        this.customizeCheck.requestFocus();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.menuCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_menu_item"));
        this.toolbarCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_toolbar_button"));
        this.keyboardCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_kbd_shortcut"));
        this.customizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_cust_code_checkbox"));
    }

    private void initComponents() {
        this.hintsArea = new JTextArea();
        this.menuCheck = new JCheckBox();
        this.toolbarCheck = new JCheckBox();
        this.keyboardCheck = new JCheckBox();
        this.customizeCheck = new JCheckBox();
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setText(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setEnabled(false);
        this.hintsArea.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.menuCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_menu_item"));
        this.menuCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.toolbarCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_toolbar_button"));
        this.toolbarCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.keyboardCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_kbd_shortcut"));
        this.keyboardCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.customizeCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cust_code_checkbox"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.hintsArea).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.menuCheck).add((Component)this.toolbarCheck).add((Component)this.keyboardCheck).add((Component)this.customizeCheck)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.hintsArea, -2, -1, -2).addPreferredGap(1).add((Component)this.menuCheck).addPreferredGap(0).add((Component)this.toolbarCheck).addPreferredGap(0).add((Component)this.keyboardCheck).addPreferredGap(0).add((Component)this.customizeCheck).addContainerGap(15, Short.MAX_VALUE)));
    }

    private void someCheckboxClicked(ActionEvent actionEvent) {
        this.wiz.fireChangeEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntroWizardPanel
    implements WizardDescriptor.Panel<ShortcutWizard> {
        private IntroPanel panel = null;
        private ShortcutWizard wiz = null;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public void initialize(ShortcutWizard shortcutWizard) {
            this.wiz = shortcutWizard;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        private IntroPanel getPanel() {
            if (this.panel == null) {
                this.panel = new IntroPanel(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().menuCheck.isSelected() || this.getPanel().toolbarCheck.isSelected() || this.getPanel().keyboardCheck.isSelected();
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        protected final void fireChangeEvent() {
            this.storeSettings(this.wiz);
            this.cs.fireChange();
        }

        public void readSettings(ShortcutWizard shortcutWizard) {
            this.getPanel().customizeCheck.setSelected(this.flag("wizdata.show.cust"));
            this.getPanel().menuCheck.setSelected(this.flag("wizdata.show.menu"));
            this.getPanel().toolbarCheck.setSelected(this.flag("wizdata.show.tool"));
            this.getPanel().keyboardCheck.setSelected(this.flag("wizdata.show.keyb"));
        }

        private boolean flag(String string) {
            Boolean bl = (Boolean)this.wiz.getProperty("wizdata.show.keyb");
            return bl != null ? bl : false;
        }

        public void storeSettings(ShortcutWizard shortcutWizard) {
            shortcutWizard.putProperty("wizdata.show.cust", this.getPanel().customizeCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            shortcutWizard.putProperty("wizdata.show.menu", this.getPanel().menuCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            shortcutWizard.putProperty("wizdata.show.tool", this.getPanel().toolbarCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            shortcutWizard.putProperty("wizdata.show.keyb", this.getPanel().keyboardCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

