/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(StandardLogger.class.getName());
    private static final Pattern CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    private static final Pattern CWD_ENTER = Pattern.compile(".*Entering directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern CWD_LEAVE = Pattern.compile(".*Leaving directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private final long mockTotalTime;
    private static final Pattern IMPORTANT_MESSAGE = Pattern.compile("\\[deprecation\\]|warning|stopped");
    private static final Pattern HYPERLINK = Pattern.compile("(\"?(.+?)\"?(?:(?::|, line )(\\d+)(?::(\\d+)(?::(\\d+):(\\d+))?)?)?)(: +(.*))");

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long l) {
        this.mockTotalTime = l;
    }

    @Override
    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    @Override
    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    @Override
    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    @Override
    public String[] interestedInTasks(AntSession antSession) {
        return AntLogger.ALL_TASKS;
    }

    @Override
    public int[] interestedInLogLevels(AntSession antSession) {
        int n = antSession.getVerbosity();
        assert (n >= 0 && n <= 4) : n;
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private SessionData getSessionData(AntSession antSession) {
        SessionData sessionData = (SessionData)antSession.getCustomData(this);
        if (sessionData == null) {
            sessionData = new SessionData();
            antSession.putCustomData(this, sessionData);
        }
        return sessionData;
    }

    @Override
    public void buildInitializationFailed(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        Throwable throwable = antEvent.getException();
        if (antEvent.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(throwable, antEvent);
        } else {
            antEvent.getSession().println(throwable.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    private static void deliverBlockOfTextAsLines(String string, AntEvent antEvent, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            antEvent.getSession().deliverMessageLogged(antEvent, string2, n);
        }
    }

    private static void deliverStackTrace(Throwable throwable, AntEvent antEvent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        StandardLogger.deliverBlockOfTextAsLines(stringWriter.toString(), antEvent, 0);
    }

    @Override
    public void buildStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        this.getSessionData((AntSession)antEvent.getSession()).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_running_ant", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    @Override
    public void buildFinished(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        AntSession antSession = antEvent.getSession();
        Throwable throwable = antEvent.getException();
        long l = System.currentTimeMillis() - this.getSessionData((AntSession)antSession).startTime;
        if (this.mockTotalTime != 0L) {
            l = this.mockTotalTime;
        }
        if (throwable == null) {
            StandardLogger.formatColoredMessageWithTime(antSession, "FMT_finished_target_printed", false, l);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_finished_target_status", (Object)antSession.getDisplayName()));
        } else {
            if (StandardLogger.isStopException(throwable.getCause())) {
                throwable = throwable.getCause();
            }
            if (!antSession.isExceptionConsumed(throwable)) {
                String string;
                String string2;
                Throwable throwable2;
                antSession.consumeException(throwable);
                StringBuilder stringBuilder = new StringBuilder();
                while (StandardLogger.isBuildException(throwable) && (throwable2 = throwable.getCause()) != null && (string2 = throwable.toString()).endsWith(string = throwable2.toString())) {
                    stringBuilder.append(string2.substring(0, string2.length() - string.length()));
                    throwable = throwable2;
                }
                if (StandardLogger.isBuildException(throwable) && antSession.getVerbosity() < 3) {
                    stringBuilder.append(throwable);
                    StandardLogger.deliverBlockOfTextAsLines(stringBuilder.toString(), antEvent, 0);
                } else if (!StandardLogger.isStopException(throwable) || antEvent.getSession().getVerbosity() >= 3) {
                    if (stringBuilder.length() > 0) {
                        StandardLogger.deliverBlockOfTextAsLines(stringBuilder.toString(), antEvent, 0);
                    }
                    StandardLogger.deliverStackTrace(throwable, antEvent);
                }
            }
            if (StandardLogger.isStopException(throwable)) {
                StandardLogger.formatColoredMessageWithTime(antSession, "FMT_target_stopped_printed", true, l);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_stopped_status", (Object)antEvent.getSession().getDisplayName()));
            } else {
                StandardLogger.formatColoredMessageWithTime(antSession, "FMT_target_failed_printed", true, l);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
            }
        }
        antEvent.consume();
    }

    private static boolean isBuildException(Throwable throwable) {
        for (Class<?> clazz = throwable.getClass(); clazz != Throwable.class; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().equals("org.apache.tools.ant.BuildException")) continue;
            return true;
        }
        return false;
    }

    private static boolean isStopException(Throwable throwable) {
        return throwable instanceof ThreadDeath || throwable instanceof InterruptedException;
    }

    private static void formatColoredMessageWithTime(AntSession antSession, String string, boolean bl, long l) {
        int n = (int)(l / 1000L);
        int n2 = n / 60;
        int n3 = n % 60;
        String string2 = NbBundle.getMessage(StandardLogger.class, (String)string, (Object)n2, (Object)n3);
        InputOutput inputOutput = antSession.getIO();
        if (IOColorLines.isSupported((InputOutput)inputOutput)) {
            try {
                IOColorLines.println((InputOutput)inputOutput, (CharSequence)string2, (Color)(bl ? Color.RED : Color.GREEN.darker().darker()));
                return;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
        }
        antSession.println(string2, bl, null);
    }

    @Override
    public void targetStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        String string = antEvent.getTargetName();
        if (string != null) {
            int n = string.length() > 0 && string.charAt(0) == '-' ? 3 : 2;
            AntSession antSession = antEvent.getSession();
            if (antSession.getVerbosity() >= n) {
                String string2;
                if (!antSession.getOriginatingScript().getAbsolutePath().equals(antEvent.getProperty("ant.file")) && (string2 = antEvent.getProperty("ant.project.name")) != null && !string2.contains("{0}")) {
                    string = string2 + '.' + string;
                }
                string2 = NbBundle.getMessage(StandardLogger.class, (String)"MSG_target_started_printed", (Object)string);
                InputOutput inputOutput = antSession.getIO();
                if (IOColorLines.isSupported((InputOutput)inputOutput)) {
                    try {
                        IOColorLines.println((InputOutput)inputOutput, (CharSequence)string2, (Color)Color.GRAY);
                    }
                    catch (IOException iOException) {
                        ERR.log(Level.INFO, null, iOException);
                    }
                } else {
                    antSession.println(string2, false, null);
                }
            }
        }
        antEvent.consume();
    }

    @Override
    public void messageLogged(AntEvent antEvent) {
        Stack<File> stack;
        Object object;
        if (antEvent.isConsumed()) {
            return;
        }
        antEvent.consume();
        AntSession antSession = antEvent.getSession();
        String string = antEvent.getMessage();
        if (string.startsWith("Trying to override old definition of ") && antEvent.getLogLevel() == 1) {
            antSession.deliverMessageLogged(antEvent, string, 3);
            return;
        }
        ERR.log(Level.FINE, "Received message: {0}", string);
        if (string.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(string, antEvent, antEvent.getLogLevel());
            return;
        }
        Matcher matcher = CARET_SHOWING_COLUMN.matcher(string);
        if (matcher.matches()) {
            ERR.fine("  Looks like a special caret line");
            object = this.getSessionData(antSession);
            if (((SessionData)object).lastHyperlink != null) {
                ((SessionData)object).lastHyperlink.setColumn1(matcher.group(1).length() + 1);
                ((SessionData)object).lastHyperlink = null;
                return;
            }
        }
        if ((matcher = CWD_ENTER.matcher(string)).matches()) {
            ERR.fine("  Looks like a change of CWD");
            object = new File(matcher.group(1));
            if (((File)object).isDirectory()) {
                stack = this.getSessionData((AntSession)antSession).currentDir;
                stack.push((File)object);
                ERR.log(Level.FINE, "  ...is a change of CWD; stack now: {0}", stack);
            }
        }
        if ((matcher = CWD_LEAVE.matcher(string)).matches()) {
            ERR.fine("  Looks like a change of CWD back out");
            object = new File(matcher.group(1));
            stack = this.getSessionData((AntSession)antSession).currentDir;
            if (stack.empty()) {
                ERR.log(Level.FINE, "  ...but there was nowhere to change out of");
            } else {
                File file = stack.pop();
                if (!file.equals(object)) {
                    ERR.log(Level.FINE, "  ...stack mismatch: {0} vs. {1}", new Object[]{file, object});
                }
            }
        }
        if ("java".equals(antEvent.getTaskName()) && (antEvent.getLogLevel() == 1 || antEvent.getLogLevel() == 2)) {
            return;
        }
        object = StandardLogger.findHyperlink(string, antEvent.getSession(), this.getSessionData((AntSession)antSession).currentDir);
        if (((PartiallyLinkedLine)object).hyperlink instanceof Hyperlink) {
            this.getSessionData((AntSession)antSession).lastHyperlink = (Hyperlink)((PartiallyLinkedLine)object).hyperlink;
        }
        ((PartiallyLinkedLine)object).println(antEvent.getSession(), antEvent.getLogLevel() <= 1);
    }

    @Override
    public void taskFinished(AntEvent antEvent) {
        this.getSessionData((AntSession)antEvent.getSession()).lastHyperlink = null;
    }

    public static boolean isImportant(String string) {
        return !IMPORTANT_MESSAGE.matcher(string).find();
    }

    public static PartiallyLinkedLine findHyperlink(String string, AntSession antSession, Stack<File> stack) {
        File file;
        Matcher matcher = HYPERLINK.matcher(string);
        if (!matcher.matches()) {
            ERR.fine("does not look like a hyperlink");
            return new PartiallyLinkedLine(string);
        }
        String string2 = matcher.group(2);
        if (string2.startsWith("file:")) {
            try {
                file = new File(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                ERR.log(Level.FINE, "invalid URI, skipping", uRISyntaxException);
                return new PartiallyLinkedLine(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ERR.log(Level.FINE, "invalid URI, skipping", illegalArgumentException);
                return new PartiallyLinkedLine(string);
            }
        } else {
            file = new File(string2);
            if (!file.isAbsolute()) {
                if (stack == null || stack.isEmpty()) {
                    ERR.fine("Non-absolute path with no CWD, skipping");
                    return new PartiallyLinkedLine(string);
                }
                file = new File(stack.peek(), string2);
            }
        }
        if (!file.exists()) {
            ERR.log(Level.FINE, "no such file {0}, skipping", file);
            return new PartiallyLinkedLine(string);
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string3 = matcher.group(3);
        try {
            if (string3 != null) {
                n = Integer.parseInt(string3);
                string3 = matcher.group(4);
                if (string3 != null) {
                    n2 = Integer.parseInt(string3);
                    string3 = matcher.group(5);
                    if (string3 != null) {
                        n3 = Integer.parseInt(string3);
                        n4 = Integer.parseInt(matcher.group(6));
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ERR.log(Level.FINE, "bad line/col #", numberFormatException);
            return new PartiallyLinkedLine(string);
        }
        String string4 = matcher.group(8);
        file = FileUtil.normalizeFile((File)file);
        ERR.log(Level.FINE, "Hyperlink: {0} [{1}:{2}:{3}:{4}]: {5}", new Object[]{file, n, n2, n3, n4, string4});
        try {
            return new PartiallyLinkedLine(antSession.createStandardHyperlink(file.toURI().toURL(), string4, n, n2, n3, n4), string, matcher.group(1), matcher.group(7));
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException;
            return new PartiallyLinkedLine(string);
        }
    }

    public static class PartiallyLinkedLine {
        final OutputListener hyperlink;
        final String all;
        final String mainPart;
        final String postLinkPart;

        PartiallyLinkedLine(String string) {
            this(null, string, null, null);
        }

        PartiallyLinkedLine(OutputListener outputListener, String string, String string2, String string3) {
            this.hyperlink = outputListener;
            this.all = string;
            this.mainPart = string2;
            this.postLinkPart = string3;
        }

        public void println(AntSession antSession, boolean bl) {
            if (this.hyperlink != null) {
                InputOutput inputOutput = antSession.getIO();
                if (IOColorPrint.isSupported((InputOutput)inputOutput)) {
                    try {
                        assert (this.mainPart != null);
                        IOColorPrint.print((InputOutput)inputOutput, (CharSequence)this.mainPart, (OutputListener)this.hyperlink, (boolean)StandardLogger.isImportant(this.all), null);
                        assert (this.postLinkPart != null);
                        antSession.println(this.postLinkPart, true, null);
                        return;
                    }
                    catch (IOException iOException) {
                        ERR.log(Level.INFO, null, iOException);
                    }
                }
                antSession.println(this.all, bl, this.hyperlink);
            } else {
                antSession.println(this.all, bl, null);
            }
        }
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
        public Stack<File> currentDir = new Stack();
    }
}

