/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastTargetExecuted
implements BuildExecutionSupport.Item {
    private File buildScript;
    private String[] targets;
    private Map<String, String> properties;
    private String displayName;
    private Thread thread;
    private static final ChangeSupport cs = new ChangeSupport(LastTargetExecuted.class);

    private LastTargetExecuted() {
    }

    static LastTargetExecuted record(File file, String[] stringArray, Map<String, String> map, String string, Thread thread) {
        LastTargetExecuted lastTargetExecuted = new LastTargetExecuted();
        lastTargetExecuted.buildScript = file;
        lastTargetExecuted.targets = stringArray;
        lastTargetExecuted.properties = map;
        lastTargetExecuted.displayName = string;
        lastTargetExecuted.thread = thread;
        BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)lastTargetExecuted);
        return lastTargetExecuted;
    }

    static void finish(LastTargetExecuted lastTargetExecuted) {
        BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)lastTargetExecuted);
    }

    public static AntProjectCookie getLastBuildScript(LastTargetExecuted lastTargetExecuted) {
        if (lastTargetExecuted.buildScript != null && lastTargetExecuted.buildScript.isFile()) {
            FileObject fileObject = FileUtil.toFileObject((File)lastTargetExecuted.buildScript);
            assert (fileObject != null);
            return AntScriptUtils.antProjectCookieFor(fileObject);
        }
        return null;
    }

    public static ExecutorTask rerun(LastTargetExecuted lastTargetExecuted) throws IOException {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript(lastTargetExecuted);
        if (antProjectCookie == null) {
            cs.fireChange();
            return null;
        }
        TargetExecutor targetExecutor = new TargetExecutor(antProjectCookie, lastTargetExecuted.targets);
        targetExecutor.setProperties(lastTargetExecuted.properties);
        targetExecutor.setDisplayName(lastTargetExecuted.displayName);
        return targetExecutor.execute();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void repeatExecution() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    LastTargetExecuted.rerun(LastTargetExecuted.this);
                }
                catch (IOException iOException) {
                    AntModule.err.notify((Throwable)iOException);
                }
            }
        });
    }

    public boolean isRunning() {
        return this.thread != null ? this.thread.isAlive() : false;
    }

    public void stopRunning() {
        if (this.thread != null) {
            AntBridge.getInterface().stop(this.thread);
        }
    }
}

