/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.execution.ExecutorTask;
import org.openide.util.NbCollections;

public final class AntTargetExecutor {
    private final Env env;

    private AntTargetExecutor(Env env) {
        this.env = env;
    }

    public static AntTargetExecutor createTargetExecutor(Env env) {
        return new AntTargetExecutor(env);
    }

    public ExecutorTask execute(AntProjectCookie antProjectCookie, String[] stringArray) throws IOException {
        TargetExecutor targetExecutor = new TargetExecutor(antProjectCookie, stringArray);
        targetExecutor.setVerbosity(this.env.getVerbosity());
        targetExecutor.setProperties(NbCollections.checkedMapByCopy((Map)this.env.getProperties(), String.class, String.class, (boolean)true));
        if (this.env.getLogger() == null) {
            return targetExecutor.execute();
        }
        return targetExecutor.execute(this.env.getLogger());
    }

    public static final class Env {
        private int verbosity = AntSettings.getVerbosity();
        private Properties properties = new Properties();
        private OutputStream outputStream;

        public Env() {
            this.properties.putAll(AntSettings.getProperties());
        }

        public void setVerbosity(int n) {
            this.verbosity = n;
        }

        public int getVerbosity() {
            return this.verbosity;
        }

        public synchronized void setProperties(Properties properties) {
            this.properties = (Properties)properties.clone();
        }

        public synchronized Properties getProperties() {
            return (Properties)this.properties.clone();
        }

        @Deprecated
        public void setLogger(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public OutputStream getLogger() {
            return this.outputStream;
        }
    }
}

