/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ProjectFactory;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ImporterWizardPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectWizardPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.SelectionWizardPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor>,
ChangeListener {
    private String errorMessage;
    private SelectionWizardPanel workspacePanel;
    private ProjectWizardPanel projectPanel;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    private List<String> currentPanelProviders = new ArrayList<String>();
    int numberOfPanels = 2;
    int currentPanel = 0;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    EclipseWizardIterator() {
        this.workspacePanel = new SelectionWizardPanel();
        this.workspacePanel.addChangeListener(this);
        this.projectPanel = new ProjectWizardPanel();
        this.projectPanel.addChangeListener(this);
    }

    List<WizardDescriptor.Panel<WizardDescriptor>> getExtraPanels() {
        return this.extraPanels;
    }

    List<EclipseProject> getProjects() {
        if (this.workspacePanel.isWorkspaceChosen()) {
            return this.projectPanel.getProjects();
        }
        try {
            File file = FileUtil.normalizeFile((File)new File(this.workspacePanel.getProjectDir()));
            return Collections.singletonList(ProjectFactory.getInstance().load(file));
        }
        catch (ProjectImporterException projectImporterException) {
            ErrorManager.getDefault().log(65536, "ProjectImporterException catched: " + projectImporterException);
            projectImporterException.printStackTrace();
            return Collections.emptyList();
        }
    }

    int getNumberOfImportedProject() {
        return this.workspacePanel.isWorkspaceChosen() ? this.projectPanel.getNumberOfImportedProject() : 1;
    }

    String getDestination() {
        return this.workspacePanel.isWorkspaceChosen() ? this.projectPanel.getDestination() : this.workspacePanel.getProjectDestinationDir();
    }

    boolean getRecursively() {
        return this.workspacePanel.isWorkspaceChosen();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void previousPanel() {
        --this.currentPanel;
        this.updateErrorMessage();
    }

    public void nextPanel() {
        if (this.getCurrent() == this.workspacePanel) {
            this.projectPanel.loadProjects(this.workspacePanel.getWorkspaceDir());
        }
        ++this.currentPanel;
        this.updateErrorMessage();
    }

    public String name() {
        if (this.getCurrent() == this.workspacePanel) {
            return ImporterWizardPanel.WORKSPACE_LOCATION_STEP;
        }
        if (this.getCurrent() == this.projectPanel) {
            return ImporterWizardPanel.PROJECT_SELECTION_STEP;
        }
        return this.getCurrent().getComponent().getName();
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public boolean hasNext() {
        return this.currentPanel < this.numberOfPanels - 1;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getCurrent();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateExtraWizardPanels();
        this.updateErrorMessage();
    }

    private void updateExtraWizardPanels() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> arrayList = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        if (this.getCurrent() == this.workspacePanel) {
            int n = this.numberOfPanels = this.workspacePanel.isWorkspaceChosen() ? 2 : 1;
        }
        if (this.getCurrent() != this.projectPanel) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (EclipseProject object : this.getProjects()) {
            if (!object.isImportSupported() || hashSet.contains(object.getProjectTypeFactory().getClass().getName())) continue;
            hashSet.add(object.getProjectTypeFactory().getClass().getName());
            arrayList.addAll(object.getProjectTypeFactory().getAdditionalImportWizardPanels());
            arrayList2.add(object.getProjectTypeFactory().getClass().getName());
        }
        if (((Object)arrayList2).equals(this.currentPanelProviders)) {
            return;
        }
        this.currentPanelProviders = arrayList2;
        this.extraPanels = arrayList;
        this.numberOfPanels = 2 + arrayList.size();
        int n = 2;
        for (WizardDescriptor.Panel panel : arrayList) {
            JComponent jComponent = (JComponent)panel.getComponent();
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
            ++n;
            jComponent.putClientProperty("WizardPanel_contentData", this.getWizardPanelName(arrayList));
        }
        ((JComponent)this.projectPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.getWizardPanelName(arrayList));
    }

    private String[] getWizardPanelName(List<WizardDescriptor.Panel<WizardDescriptor>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ImporterWizardPanel.WORKSPACE_LOCATION_STEP);
        arrayList.add(ImporterWizardPanel.PROJECTS_SELECTION_STEP);
        if (list != null) {
            for (WizardDescriptor.Panel<WizardDescriptor> panel : list) {
                JComponent jComponent = (JComponent)panel.getComponent();
                arrayList.add(jComponent.getName());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    void updateErrorMessage() {
        this.errorMessage = this.getCurrent() == this.workspacePanel ? this.workspacePanel.getErrorMessage() : (this.getCurrent() == this.projectPanel ? this.projectPanel.getErrorMessage() : null);
        this.cs.fireChange();
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    WizardDescriptor.Panel<WizardDescriptor> getCurrent() {
        if (this.currentPanel == 0) {
            return this.workspacePanel;
        }
        if (this.currentPanel == 1) {
            return this.projectPanel;
        }
        return this.extraPanels.get(this.currentPanel - 2);
    }
}

