/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.Timer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ImportProblemsPanel;
import org.netbeans.modules.projectimport.eclipse.core.Importer;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProgressPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ProjectImporterWizard projectImporterWizard = new ProjectImporterWizard();
        projectImporterWizard.start();
        List<EclipseProject> list = projectImporterWizard.getProjects();
        String string = projectImporterWizard.getDestination();
        if (projectImporterWizard.isCancelled() || list == null) {
            return;
        }
        ImportProjectAction.performImport(list, string, projectImporterWizard.getExtraPanels(), projectImporterWizard.getNumberOfImportedProject(), false, true, true, null, null);
    }

    public static void performImport(List<EclipseProject> list, String string, List<WizardDescriptor.Panel<WizardDescriptor>> list2, int n, final boolean bl, final boolean bl2, final boolean bl3, final List<String> list3, final List<Project> list4) {
        final Importer importer = new Importer(list, string, list2);
        final ProgressPanel progressPanel = new ProgressPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)progressPanel, NbBundle.getMessage(ImportProjectAction.class, (String)"CTL_ProgressDialogTitle"), true, new Object[0], null, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[0]);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ((JDialog)dialog).setDefaultCloseOperation(2);
        progressPanel.start(n);
        final Timer timer = new Timer(250, null);
        timer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                progressPanel.setProgress(importer.getNOfProcessed(), importer.getProgressInfo());
                if (importer.isDone()) {
                    timer.stop();
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (list3 != null) {
                        list3.addAll(importer.getWarnings());
                    }
                    if (bl2) {
                        ImportProblemsPanel.showReport(NbBundle.getMessage(ImportProjectAction.class, (String)"MSG_ImportIssues"), importer.getWarnings());
                    }
                    if (importer.getProjects().length > 0) {
                        if (list4 != null) {
                            list4.addAll(Arrays.asList(importer.getProjects()));
                        }
                        if (bl3) {
                            OpenProjects.getDefault().open(importer.getProjects(), true);
                            if (bl) {
                                OpenProjects.getDefault().setMainProject(importer.getProjects()[importer.getProjects().length - 1]);
                            }
                        }
                    }
                }
            }
        });
        importer.startImporting();
        timer.start();
        dialog.setVisible(true);
    }
}

