/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.j2ee.core;

import java.util.Comparator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;

public final class Profile {
    public static final Comparator<Profile> UI_COMPARATOR = new Comparator<Profile>(){

        @Override
        public int compare(Profile profile, Profile profile2) {
            return -(profile.order - profile2.order);
        }
    };
    public static final Profile J2EE_13 = new Profile(1, "1.3", null, "J2EE13.displayName");
    public static final Profile J2EE_14 = new Profile(2, "1.4", null, "J2EE14.displayName");
    public static final Profile JAVA_EE_5 = new Profile(3, "1.5", null, "JavaEE5.displayName");
    public static final Profile JAVA_EE_6_FULL = new Profile(4, "1.6", null, "JavaEE6Full.displayName");
    public static final Profile JAVA_EE_6_WEB = new Profile(5, "1.6", "web", "JavaEE6Web.displayName");
    private final int order;
    private final String canonicalName;
    private final String propertiesString;
    private final String bundleKey;

    private Profile(int n, String string, String string2, String string3) {
        this.order = n;
        this.canonicalName = string;
        this.bundleKey = string3;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append("-").append(string2);
        }
        this.propertiesString = stringBuilder.toString();
    }

    @NonNull
    public String getDisplayName() {
        return NbBundle.getMessage(Profile.class, (String)this.bundleKey);
    }

    @NonNull
    public String toPropertiesString() {
        return this.propertiesString;
    }

    public String toString() {
        return this.toPropertiesString();
    }

    @CheckForNull
    public static Profile fromPropertiesString(@NullAllowed String string) {
        if (J2EE_13.toPropertiesString().equals(string)) {
            return J2EE_13;
        }
        if (J2EE_14.toPropertiesString().equals(string)) {
            return J2EE_14;
        }
        if (JAVA_EE_5.toPropertiesString().equals(string)) {
            return JAVA_EE_5;
        }
        if (JAVA_EE_6_FULL.toPropertiesString().equals(string) || "EE_6_FULL".equals(string)) {
            return JAVA_EE_6_FULL;
        }
        if (JAVA_EE_6_WEB.toPropertiesString().equals(string) || "EE_6_WEB".equals(string)) {
            return JAVA_EE_6_WEB;
        }
        return null;
    }
}

