/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;

public class APTTraceUtils {
    private APTTraceUtils() {
    }

    public static String toFileString(APTFile aPTFile) {
        if (aPTFile == null) {
            return "<no file>";
        }
        File file = new File(((Object)aPTFile.getPath()).toString());
        File file2 = file.getParentFile();
        if (file2 == null) {
            return file.getName();
        }
        return file2.getName() + "/" + file.getName();
    }

    public static String toStringList(APT aPT) {
        StringBuilder stringBuilder = new StringBuilder();
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(" (");
        }
        stringBuilder.append(" ").append(aPT.toString());
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(APTTraceUtils.toStringList(aPT.getFirstChild()));
        }
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(" )");
        }
        if (aPT.getNextSibling() != null) {
            stringBuilder.append(APTTraceUtils.toStringList(aPT.getNextSibling()));
        }
        return stringBuilder.toString();
    }

    public static String toStringTree(APT aPT) {
        StringBuilder stringBuilder = new StringBuilder();
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(" (");
        }
        stringBuilder.append(" ").append(aPT.toString());
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(APTTraceUtils.toStringTree(aPT.getFirstChild()));
        }
        if (aPT.getFirstChild() != null) {
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }

    public static void xmlSerialize(APT aPT, Writer writer) throws IOException {
        for (APT aPT2 = aPT; aPT2 != null; aPT2 = aPT2.getNextSibling()) {
            if (aPT2.getFirstChild() == null) {
                APTTraceUtils.xmlSerializeNode(aPT2, writer);
                continue;
            }
            APTTraceUtils.xmlSerializeRootOpen(aPT2, writer);
            APTTraceUtils.xmlSerialize(aPT2.getFirstChild(), writer);
            APTTraceUtils.xmlSerializeRootClose(aPT2, writer);
        }
    }

    private static void xmlSerializeNode(APT aPT, Writer writer) throws IOException {
        writer.write("<" + APTTraceUtils.xmlNodeText(aPT) + "\"/>\n");
    }

    private static void xmlSerializeRootOpen(APT aPT, Writer writer) throws IOException {
        writer.write("<" + APTTraceUtils.xmlNodeText(aPT) + "\">\n");
    }

    private static void xmlSerializeRootClose(APT aPT, Writer writer) throws IOException {
        writer.write("</" + aPT.getClass().getSimpleName() + ">\n");
    }

    private static String xmlNodeText(APT aPT) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(aPT.getClass().getSimpleName());
        stringBuilder.append(" type=\"").append(APTTraceUtils.encode(APTTraceUtils.getTypeName(aPT)));
        stringBuilder.append("\" text=\"").append(APTTraceUtils.encode(aPT.toString()));
        return stringBuilder.toString();
    }

    private static String decode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                char c2 = string.charAt(i + 1);
                char c3 = string.charAt(i + 2);
                char c4 = string.charAt(i + 3);
                char c5 = string.charAt(i + 4);
                char c6 = string.charAt(i + 5);
                if (c2 == 'a' && c3 == 'm' && c4 == 'p' && c5 == ';') {
                    stringBuilder.append("&");
                    i += 5;
                    continue;
                }
                if (c2 == 'l' && c3 == 't' && c4 == ';') {
                    stringBuilder.append("<");
                    i += 4;
                    continue;
                }
                if (c2 == 'g' && c3 == 't' && c4 == ';') {
                    stringBuilder.append(">");
                    i += 4;
                    continue;
                }
                if (c2 == 'q' && c3 == 'u' && c4 == 'o' && c5 == 't' && c6 == ';') {
                    stringBuilder.append("\"");
                    i += 6;
                    continue;
                }
                if (c2 == 'a' && c3 == 'p' && c4 == 'o' && c5 == 's' && c6 == ';') {
                    stringBuilder.append("'");
                    i += 6;
                    continue;
                }
                stringBuilder.append("&");
                continue;
            }
            stringBuilder.append(c);
        }
        return new String(stringBuilder);
    }

    private static String encode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return new String(stringBuilder);
    }

    public static String getTypeName(APT aPT) {
        int n = aPT.getType();
        String string = "<unknown>";
        switch (n) {
            case 0: {
                string = "INVALID";
                break;
            }
            case 1: {
                string = "FILE";
                break;
            }
            case 2: {
                string = "TOKEN_STREAM";
                break;
            }
            case 3: {
                string = "INCLUDE";
                break;
            }
            case 4: {
                string = "INCLUDE_NEXT";
                break;
            }
            case 5: {
                string = "DEFINE";
                break;
            }
            case 6: {
                string = "UNDEF";
                break;
            }
            case 7: {
                string = "IFDEF";
                break;
            }
            case 8: {
                string = "IFNDEF";
                break;
            }
            case 9: {
                string = "IF";
                break;
            }
            case 10: {
                string = "ELIF";
                break;
            }
            case 11: {
                string = "ELSE";
                break;
            }
            case 12: {
                string = "ENDIF";
                break;
            }
            case 13: {
                string = "PRAGMA";
                break;
            }
            case 14: {
                string = "LINE";
                break;
            }
            case 15: {
                string = "ERROR";
                break;
            }
            case 16: {
                string = "PREPROC_UNKNOWN";
                break;
            }
        }
        return string;
    }
}

