/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APTBaseMacroMap
implements APTMacroMap {
    protected APTMacroMapSnapshot active = this.makeSnapshot(null);
    private static final String DEFINE_PREFIX = "#define ";
    protected static final APTMacroMap EMPTY = new EmptyMacroMap();

    protected APTBaseMacroMap() {
    }

    protected final void fill(List<String> list, boolean bl) {
        for (String string : list) {
            if (APTTraceFlags.TRACE_APT) {
                System.err.println("adding macro in map " + string);
            }
            this.define(string, bl);
        }
    }

    private void define(String string, boolean bl) {
        string = DEFINE_PREFIX + string;
        TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream(string);
        try {
            APTToken aPTToken = (APTToken)tokenStream.nextToken();
            APTDefineNode aPTDefineNode = new APTDefineNode(aPTToken);
            boolean bl2 = true;
            do {
                aPTToken = (APTToken)tokenStream.nextToken();
                if (!bl2 || aPTToken.getType() != 132) continue;
                bl2 = false;
                aPTToken = (APTToken)tokenStream.nextToken();
            } while (aPTDefineNode.accept(null, aPTToken));
            if (aPTDefineNode.getBody().isEmpty() && bl2) {
                aPTDefineNode.accept(null, APTUtils.DEF_MACRO_BODY.get(0));
            }
            if (bl) {
                this.defineImpl(null, aPTDefineNode, APTMacro.Kind.COMPILER_PREDEFINED);
            } else {
                this.defineImpl(null, aPTDefineNode, APTMacro.Kind.USER_SPECIFIED);
            }
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on lexing macros {0}\n\t{1}", new Object[]{string, tokenStreamException.getMessage()});
        }
    }

    @Override
    public void define(APTFile aPTFile, APTDefine aPTDefine, APTMacro.Kind kind) {
        this.defineImpl(aPTFile, aPTDefine, kind);
    }

    private void defineImpl(APTFile aPTFile, APTDefine aPTDefine, APTMacro.Kind kind) {
        APTToken aPTToken = aPTDefine.getName();
        CharSequence charSequence = aPTFile == null ? CharSequenceKey.empty() : aPTFile.getPath();
        this.putMacro(aPTToken.getTextID(), this.createMacro(charSequence, aPTDefine, kind));
    }

    @Override
    public void undef(APTFile aPTFile, APTToken aPTToken) {
        this.putMacro(aPTToken.getTextID(), APTMacroMapSnapshot.UNDEFINED_MACRO);
    }

    protected void putMacro(CharSequence charSequence, APTMacro aPTMacro) {
        this.active.putMacro(charSequence, aPTMacro);
    }

    protected abstract APTMacro createMacro(CharSequence var1, APTDefine var2, APTMacro.Kind var3);

    @Override
    public final boolean isDefined(APTToken aPTToken) {
        return this.getMacro(aPTToken) != null;
    }

    @Override
    public final boolean isDefined(CharSequence charSequence) {
        return this.getMacro(charSequence = CharSequenceKey.create((CharSequence)charSequence)) != null;
    }

    @Override
    public APTMacro getMacro(APTToken aPTToken) {
        APTMacro aPTMacro = this.active.getMacro(aPTToken);
        return aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO ? aPTMacro : null;
    }

    protected APTMacro getMacro(CharSequence charSequence) {
        assert (charSequence instanceof TinyCharSequence) : "must not be String object " + charSequence;
        APTMacro aPTMacro = this.active.getMacro(charSequence);
        return aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO ? aPTMacro : null;
    }

    protected abstract APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot var1);

    @Override
    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new StateImpl(this.active.parent);
    }

    protected void changeActiveSnapshotIfNeeded() {
        this.active = this.makeSnapshot(this.active);
    }

    @Override
    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((StateImpl)state).snap);
    }

    public String toString() {
        HashMap<CharSequence, APTMacro> hashMap = new HashMap<CharSequence, APTMacro>();
        APTMacroMapSnapshot.addAllMacros(this.active, hashMap);
        return APTUtils.macros2String(hashMap);
    }

    private static final class EmptyMacroMap
    implements APTMacroMap {
        private EmptyMacroMap() {
        }

        protected APTMacro createMacro(APTDefine aPTDefine) {
            return null;
        }

        public boolean pushExpanding(APTToken aPTToken) {
            return false;
        }

        public void popExpanding() {
        }

        public boolean isExpanding(APTToken aPTToken) {
            return false;
        }

        public boolean isDefined(APTToken aPTToken) {
            return false;
        }

        public boolean isDefined(CharSequence charSequence) {
            return false;
        }

        public APTMacro getMacro(APTToken aPTToken) {
            return null;
        }

        public void define(APTFile aPTFile, APTDefine aPTDefine, APTMacro.Kind kind) {
        }

        public void undef(APTFile aPTFile, APTToken aPTToken) {
        }

        public void setState(APTMacroMap.State state) {
        }

        public APTMacroMap.State getState() {
            return new StateImpl((APTMacroMapSnapshot)null);
        }
    }

    public static class StateImpl
    implements APTMacroMap.State {
        public final APTMacroMapSnapshot snap;

        public StateImpl(APTMacroMapSnapshot aPTMacroMapSnapshot) {
            this.snap = aPTMacroMapSnapshot;
        }

        protected StateImpl(StateImpl stateImpl, boolean bl) {
            this.snap = bl ? this.getFirstSnapshot(stateImpl.snap) : stateImpl.snap;
        }

        public String toString() {
            return this.snap != null ? this.snap.toString() : "<no snap>";
        }

        public StateImpl copyCleaned() {
            return new StateImpl(this, true);
        }

        boolean isEmptyActiveMacroMap() {
            return this.snap == null || this.snap.isEmtpy();
        }

        public void write(DataOutput dataOutput) throws IOException {
            APTSerializeUtils.writeSnapshot(this.snap, dataOutput);
        }

        public StateImpl(DataInput dataInput) throws IOException {
            this.snap = APTSerializeUtils.readSnapshot(dataInput);
        }

        private APTMacroMapSnapshot getFirstSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
            if (aPTMacroMapSnapshot != null) {
                while (aPTMacroMapSnapshot.parent != null) {
                    aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
                }
            }
            return aPTMacroMapSnapshot;
        }
    }
}

