/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedType;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.VarStackReadingRule;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImproperFieldAccessRule
extends PHPRule
implements VarStackReadingRule {
    private String insideClsName = "";

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "improper.field.access";
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        this.insideClsName = CodeUtils.extractClassName(classDeclaration);
        super.visit(classDeclaration);
    }

    @Override
    public void leavingClassDeclaration(ClassDeclaration classDeclaration) {
        super.leavingClassDeclaration(classDeclaration);
        this.insideClsName = "";
    }

    @Override
    public void visit(InfixExpression infixExpression) {
        Variable variable;
        Expression expression;
        InfixExpression.OperatorType operatorType = infixExpression.getOperator();
        if ((operatorType.equals((Object)InfixExpression.OperatorType.MINUS) || operatorType.equals((Object)InfixExpression.OperatorType.LGREATER)) && (expression = infixExpression.getLeft()) instanceof Variable && (variable = (Variable)expression).isDollared() && "this".equals(ImproperFieldAccessRule.extractVariableName(variable))) {
            this.addHint(variable);
        }
        super.visit(infixExpression);
    }

    @Override
    public void visit(Program program) {
        this.insideClsName = "";
        super.visit(program);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        Variable variable = staticFieldAccess.getField();
        String string = CodeUtils.extractUnqualifiedClassName(staticFieldAccess);
        if (string.equals("self")) {
            string = this.insideClsName;
        }
        int n = this.insideClsName.equals(string) ? -1 : 1;
        Collection<IndexedConstant> collection = null;
        for (IndexedType indexedType : this.context.getIndex().getClassAncestors(null, string)) {
            String string2 = indexedType.getName();
            collection = this.getFields(this.context.getIndex(), string2, variable, n);
            if (!collection.isEmpty()) break;
            if (this.insideClsName.equals(string2)) {
                n = 5;
                continue;
            }
            n = 1;
        }
        if (collection == null || collection.isEmpty()) {
            this.addHint(variable);
        }
        super.visit(staticFieldAccess);
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        super.visit(fieldAccess);
        Variable variable = fieldAccess.getField();
        if (variable.isDollared() && !this.context.variableStack.isVariableDefined(ImproperFieldAccessRule.extractVariableName(variable))) {
            this.addHint(variable);
        }
        super.visit(fieldAccess);
    }

    private static String extractVariableName(Variable variable) {
        if (variable.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)variable.getName();
            return identifier.getName();
        }
        if (variable.getName() instanceof Variable) {
            Variable variable2 = (Variable)variable.getName();
            return ImproperFieldAccessRule.extractVariableName(variable2);
        }
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(ImproperFieldAccessRule.class, (String)"ImproperFieldAccessDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImproperFieldAccessRule.class, (String)"ImproperFieldAccessDispName");
    }

    private void addHint(Variable variable) {
        OffsetRange offsetRange = new OffsetRange(variable.getStartOffset(), variable.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.parserResult.getSnapshot().getSource().getFileObject(), offsetRange, null, 500);
        this.addResult(hint);
    }

    private Collection<IndexedConstant> getFields(PHPIndex pHPIndex, String string, Variable variable, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        String string2 = ImproperFieldAccessRule.extractVariableName(variable);
        Collection<IndexedConstant> collection = pHPIndex.getFields(null, string, string2, QuerySupport.Kind.PREFIX, n);
        for (IndexedConstant indexedConstant : collection) {
            String string3 = indexedConstant.getName();
            string3 = string3.charAt(0) == '$' ? string3.substring(1) : string3;
            if (!string2.equals(string3)) continue;
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }
}

