/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPHPVersionVisitor
extends DefaultTreePathVisitor {
    private FileObject fobj;
    private ArrayList<PHPVersionError> errors = new ArrayList();

    public CheckPHPVersionVisitor(FileObject fileObject) {
        this.fobj = fileObject;
    }

    public static boolean appliesTo(FileObject fileObject) {
        PhpLanguageOptions.Properties properties;
        return fileObject != null && (properties = PhpLanguageOptions.getDefault().getProperties(fileObject)).getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_5;
    }

    @Override
    public void visit(NamespaceDeclaration namespaceDeclaration) {
        this.createError(namespaceDeclaration.getStartOffset(), namespaceDeclaration.getName().getEndOffset());
    }

    @Override
    public void visit(LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        this.createError(lambdaFunctionDeclaration);
    }

    @Override
    public void visit(GotoLabel gotoLabel) {
        this.createError(gotoLabel);
    }

    @Override
    public void visit(ConstantDeclaration constantDeclaration) {
        for (ASTNode aSTNode : this.getPath()) {
            if (!(aSTNode instanceof TypeDeclaration)) continue;
            return;
        }
        this.createError(constantDeclaration);
    }

    @Override
    public void visit(GotoStatement gotoStatement) {
        this.createError(gotoStatement);
    }

    @Override
    public void visit(UseStatement useStatement) {
        this.createError(useStatement);
    }

    @Override
    public void visit(NamespaceName namespaceName) {
        QualifiedName qualifiedName = QualifiedName.create(namespaceName);
        if (qualifiedName.getKind() != QualifiedNameKind.UNQUALIFIED) {
            this.createError(namespaceName);
        }
    }

    public Collection<? extends Error> getErrors() {
        return this.errors;
    }

    private void createError(int n, int n2) {
        PHPVersionError pHPVersionError = new PHPVersionError(n, n2);
        this.errors.add(pHPVersionError);
    }

    private void createError(ASTNode aSTNode) {
        this.createError(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        super.visit(aSTNode);
    }

    class PHPVersionError
    implements Error {
        private int startPosition;
        private int endPosition;

        public PHPVersionError(int n, int n2) {
            this.startPosition = n;
            this.endPosition = n2;
        }

        public String getDescription() {
            return NbBundle.getMessage(CheckPHPVersionVisitor.class, (String)"CheckPHPVerDesc");
        }

        public String getDisplayName() {
            return NbBundle.getMessage(CheckPHPVersionVisitor.class, (String)"CheckPHPVerDispName");
        }

        public String getKey() {
            return "php.ver";
        }

        public FileObject getFile() {
            return CheckPHPVersionVisitor.this.fobj;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public boolean isLineError() {
            return true;
        }

        public Severity getSeverity() {
            return Severity.ERROR;
        }

        public Object[] getParameters() {
            return new Object[0];
        }
    }
}

