/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.FormalParameterInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDeclarationInfo
extends ASTNodeInfo<MethodDeclaration> {
    Map<String, List<QualifiedName>> paramDocTypes = Collections.emptyMap();

    MethodDeclarationInfo(Program program, MethodDeclaration methodDeclaration) {
        super(methodDeclaration);
        if (program != null) {
            this.paramDocTypes = VariousUtils.getParamTypesFromPHPDoc(program, methodDeclaration);
        }
    }

    public static MethodDeclarationInfo create(Program program, MethodDeclaration methodDeclaration) {
        return new MethodDeclarationInfo(program, methodDeclaration);
    }

    public static MethodDeclarationInfo create(MethodDeclaration methodDeclaration) {
        return new MethodDeclarationInfo(null, methodDeclaration);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        PhpModifiers phpModifiers = new PhpModifiers(((MethodDeclaration)this.getOriginalNode()).getModifier());
        return phpModifiers.isStatic() ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
    }

    @Override
    public String getName() {
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.getOriginalNode();
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.getOriginalNode();
        Identifier identifier = methodDeclaration.getFunction().getFunctionName();
        return new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
    }

    public List<? extends Parameter> getParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        List<FormalParameter> list = ((MethodDeclaration)this.getOriginalNode()).getFunction().getFormalParameters();
        for (FormalParameter formalParameter : list) {
            FormalParameterInfo formalParameterInfo = FormalParameterInfo.create(formalParameter, this.paramDocTypes);
            arrayList.add(formalParameterInfo.toParameter());
        }
        return arrayList;
    }

    public PhpModifiers getAccessModifiers() {
        return new PhpModifiers(((MethodDeclaration)this.getOriginalNode()).getModifier());
    }
}

