/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PHPCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private volatile boolean accept = false;
    private int caretOffset;
    private CompletionContextFinder.CompletionContext context;
    private static final RequestProcessor requestProcessor = new RequestProcessor("PHPCodeTemplateFilter");
    private final RequestProcessor.Task postedTask;

    public PHPCodeTemplateFilter(final JTextComponent jTextComponent, int n) {
        this.caretOffset = n;
        this.postedTask = requestProcessor.post(new Runnable(){

            public void run() {
                PHPCodeTemplateFilter.this.parseDocument(jTextComponent);
            }
        });
    }

    public boolean accept(CodeTemplate codeTemplate) {
        try {
            if (this.postedTask.waitFinished(300L)) {
                if (this.context == CompletionContextFinder.CompletionContext.CLASS_CONTEXT_KEYWORDS) {
                    return codeTemplate.getAbbreviation().equals("fnc");
                }
                return this.accept;
            }
            this.postedTask.cancel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        ParserResult parserResult = null;
        String string = resultIterator.getSnapshot().getMimeType();
        if (!string.equals("text/x-php5")) {
            for (Embedding embedding : resultIterator.getEmbeddings()) {
                if (!embedding.getMimeType().equals("text/x-php5")) continue;
                resultIterator = resultIterator.getResultIterator(embedding);
                break;
            }
            string = resultIterator.getSnapshot().getMimeType();
        }
        if (string.equals("text/x-php5")) {
            parserResult = (ParserResult)resultIterator.getParserResult();
            this.context = CompletionContextFinder.findCompletionContext(parserResult, this.caretOffset);
            switch (this.context) {
                case EXPRESSION: {
                    this.accept = true;
                    break;
                }
                case CLASS_CONTEXT_KEYWORDS: {
                    this.accept = true;
                }
            }
        }
    }

    private void parseDocument(JTextComponent jTextComponent) {
        try {
            ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)jTextComponent.getDocument())), (UserTask)this);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new PHPCodeTemplateFilter(jTextComponent, n);
        }
    }
}

