/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedFullyQualified;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceIndexFilter<T extends ElementHandle> {
    private final String requestPrefix;
    private final QualifiedName prefix;
    private QualifiedNameKind kind;
    private String namespaceName;
    private String name;
    private int segmentSize;

    public NamespaceIndexFilter(String string) {
        this.requestPrefix = string;
        this.prefix = QualifiedName.create(string);
    }

    public String getRequestPrefix() {
        return this.requestPrefix;
    }

    public String getNamespaceName() {
        if (this.namespaceName == null) {
            this.namespaceName = this.prefix.toNamespaceName(true).toString();
        }
        return this.namespaceName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.prefix.toName().toString();
        }
        return this.name;
    }

    public QualifiedNameKind getKind() {
        if (this.kind == null) {
            this.kind = this.prefix.getKind();
        }
        return this.kind;
    }

    public int getSegmentSize() {
        if (this.segmentSize != -1) {
            this.segmentSize = this.prefix.getSegments().size();
        }
        return this.segmentSize;
    }

    public Collection<T> filter(Collection<T> collection) {
        return this.filter(collection, this.getName().trim().length() == 0);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<? extends ModelElement> filterModelElements(Collection<? extends ModelElement> collection, boolean bl) {
        if (this.getKind().isUnqualified()) {
            return collection;
        }
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        String string = this.getNamespaceName().toLowerCase();
        String string2 = string;
        if (!string2.endsWith("\\")) {
            string2 = string2 + "\\";
        }
        for (ModelElement modelElement : collection) {
            String string3;
            QualifiedName qualifiedName;
            void modelElement2;
            Scope scope = modelElement.getInScope();
            ModelElement modelElement3 = null;
            if (scope instanceof TypeScope) {
                modelElement3 = modelElement;
                Scope scope2 = scope;
            }
            String string4 = modelElement2.getNamespaceName().append(modelElement2.getName()).toFullyQualified().toString();
            int n = string4.toLowerCase().indexOf(string2);
            boolean bl2 = this.getKind().isFullyQualified();
            if (!(bl2 ? n == 0 : n != -1) || bl && (bl2 || this.getSegmentSize() > 1) && ((qualifiedName = QualifiedName.create(string4).toNamespaceName(true)).toString().toLowerCase().indexOf(string) == -1 || (string3 = string4.substring(n + string2.length())).indexOf("\\") != -1)) continue;
            arrayList.add((ModelElement)(modelElement3 != null ? modelElement3 : modelElement2));
        }
        return arrayList;
    }

    public Collection<T> filter(Collection<T> collection, boolean bl) {
        if (this.getKind().isUnqualified()) {
            return collection;
        }
        ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>();
        String string = this.getNamespaceName().toLowerCase();
        String string2 = string;
        if (!string2.endsWith("\\")) {
            string2 = string2 + "\\";
        }
        for (ElementHandle elementHandle : collection) {
            if (elementHandle instanceof IndexedFullyQualified || elementHandle instanceof IndexedClassMember) {
                String string3;
                QualifiedName qualifiedName;
                int n;
                if (elementHandle instanceof IndexedClassMember && (n = ((IndexedClassMember)elementHandle).getType().getName().toLowerCase().indexOf(this.getName().toLowerCase())) == -1) {
                    arrayList.add(elementHandle);
                    continue;
                }
                String string4 = elementHandle instanceof IndexedFullyQualified ? ((IndexedFullyQualified)elementHandle).getFullyQualifiedName() : ((IndexedClassMember)elementHandle).getType().getFullyQualifiedName();
                int n2 = string4.toLowerCase().indexOf(string2);
                boolean bl2 = this.getKind().isFullyQualified();
                if (!((bl2 ? n2 == 0 : n2 != -1) && (!bl || !bl2 && this.getSegmentSize() <= 1 || (qualifiedName = QualifiedName.create(string4).toNamespaceName(true)).toString().toLowerCase().indexOf(string) != -1 && (string3 = string4.substring(n2 + string2.length())).indexOf("\\") == -1))) continue;
                arrayList.add(elementHandle);
                continue;
            }
            if (!string.equals("")) continue;
            arrayList.add(elementHandle);
        }
        return arrayList;
    }
}

