/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.LazyLookupProviders;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ProjectServiceProvider;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class LookupProviderAnnotationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(LookupProvider.Registration.class.getCanonicalName(), ProjectServiceProvider.class.getCanonicalName(), LookupMerger.Registration.class.getCanonicalName()));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        List<TypeMirror> list;
        if (roundEnvironment.processingOver()) {
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LookupProvider.Registration.class)) {
            list = element.getAnnotation(LookupProvider.Registration.class);
            if (list.projectType().length == 0 && list.projectTypes().length == 0) {
                throw new LayerGenerationException("You must specify either projectType or projectTypes", element);
            }
            for (String string : list.projectType()) {
                this.layer(new Element[]{element}).instanceFile("Projects/" + string + "/Lookup", null, LookupProvider.class).write();
            }
            for (LookupProvider.Registration.ProjectType projectType : list.projectTypes()) {
                this.layer(new Element[]{element}).instanceFile("Projects/" + projectType.id() + "/Lookup", null, LookupProvider.class).position(projectType.position()).write();
            }
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ProjectServiceProvider.class)) {
            LayerBuilder.File file;
            void var9_37;
            void var6_14;
            list = this.findServiceAnnotation(element);
            if (list.isEmpty()) {
                throw new LayerGenerationException("Must specify at least one service", element);
            }
            Object var6_13 = null;
            for (TypeMirror typeMirror : list) {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror)).toString();
                if (string.equals(LookupMerger.class.getName())) {
                    throw new LayerGenerationException("@ProjectServiceProvider should not be used on LookupMerger; use @LookupMerger.Registration instead", element);
                }
                String string2 = var6_14 == null ? string : (String)var6_14 + "," + string;
            }
            String[] stringArray = this.findPSPDefinition(element, list);
            ProjectServiceProvider projectServiceProvider = element.getAnnotation(ProjectServiceProvider.class);
            if (projectServiceProvider.projectType().length == 0 && projectServiceProvider.projectTypes().length == 0) {
                throw new LayerGenerationException("You must specify either projectType or projectTypes", element);
            }
            String string = stringArray[0].replace('.', '-');
            if (stringArray[1] != null) {
                String string3 = string + "-" + stringArray[1];
            }
            for (String string4 : projectServiceProvider.projectType()) {
                file = this.layer(new Element[]{element}).file("Projects/" + string4 + "/Lookup/" + (String)var9_37 + ".instance").methodvalue("instanceCreate", LazyLookupProviders.class.getName(), "forProjectServiceProvider").stringvalue("class", stringArray[0]).stringvalue("service", (String)var6_14);
                if (stringArray[1] != null) {
                    file.stringvalue("method", stringArray[1]);
                }
                file.write();
            }
            for (LookupProvider.Registration.ProjectType projectType : projectServiceProvider.projectTypes()) {
                file = this.layer(new Element[]{element}).file("Projects/" + projectType.id() + "/Lookup/" + (String)var9_37 + ".instance").methodvalue("instanceCreate", LazyLookupProviders.class.getName(), "forProjectServiceProvider").stringvalue("class", stringArray[0]).stringvalue("service", (String)var6_14).position(projectType.position());
                if (stringArray[1] != null) {
                    file.stringvalue("method", stringArray[1]);
                }
                file.write();
            }
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(LookupMerger.Registration.class)) {
            void var6_19;
            DeclaredType declaredType;
            list = element.getAnnotation(LookupMerger.Registration.class);
            if (element.getKind() == ElementKind.CLASS) {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString().replace('.', '-');
                declaredType = (DeclaredType)element.asType();
            } else {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)element.getEnclosingElement()).toString().replace('.', '-') + "-" + element.getSimpleName().toString();
                declaredType = (DeclaredType)((ExecutableElement)element).getReturnType();
            }
            DeclaredType declaredType2 = this.findLookupMergerType(declaredType);
            if (declaredType2 == null) {
                throw new LayerGenerationException("Not assignable to LookupMerger<T> for some T", element);
            }
            String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)declaredType2.asElement()).toString();
            if (list.projectType().length == 0 && list.projectTypes().length == 0) {
                throw new LayerGenerationException("You must specify either projectType or projectTypes", element);
            }
            for (String string5 : list.projectType()) {
                this.layer(new Element[]{element}).file("Projects/" + (String)string5 + "/Lookup/" + (String)var6_19 + ".instance").methodvalue("instanceCreate", LazyLookupProviders.class.getName(), "forLookupMerger").instanceAttribute("lookupMergerInstance", LookupMerger.class).stringvalue("service", string).write();
            }
            for (LookupProvider.Registration.ProjectType projectType : list.projectTypes()) {
                this.layer(new Element[]{element}).file("Projects/" + projectType.id() + "/Lookup/" + (String)var6_19 + ".instance").methodvalue("instanceCreate", LazyLookupProviders.class.getName(), "forLookupMerger").instanceAttribute("lookupMergerInstance", LookupMerger.class).stringvalue("service", string).position(projectType.position()).write();
            }
        }
        return true;
    }

    private List<TypeMirror> findServiceAnnotation(Element element) throws LayerGenerationException {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!ProjectServiceProvider.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals("service")) continue;
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
                for (Object e : (List)entry.getValue().getValue()) {
                    arrayList.add((TypeMirror)((AnnotationValue)e).getValue());
                }
                return arrayList;
            }
            throw new LayerGenerationException("No service attr found", element);
        }
        throw new LayerGenerationException("No @ProjectServiceProvider found", element);
    }

    private String[] findPSPDefinition(Element element, List<TypeMirror> list) throws LayerGenerationException {
        if (element.getKind() == ElementKind.CLASS) {
            TypeElement typeElement = (TypeElement)element;
            for (TypeMirror object : list) {
                if (this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), object)) continue;
                throw new LayerGenerationException("Not assignable to " + object, element);
            }
            int n = 0;
            block1: for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
                List<? extends VariableElement> list2;
                if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || (list2 = executableElement.getParameters()).size() > 2) continue;
                for (VariableElement variableElement : list2) {
                    if (((Object)variableElement.asType()).equals(this.processingEnv.getElementUtils().getTypeElement(Project.class.getCanonicalName()).asType()) || ((Object)variableElement.asType()).equals(this.processingEnv.getElementUtils().getTypeElement(Lookup.class.getCanonicalName()).asType())) continue;
                    continue block1;
                }
                ++n;
            }
            if (n != 1) {
                throw new LayerGenerationException("Must have exactly one public constructor optionally taking Project and/or Lookup", element);
            }
            if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("Class must be public", element);
            }
            return new String[]{this.processingEnv.getElementUtils().getBinaryName(typeElement).toString(), null};
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        for (TypeMirror typeMirror : list) {
            if (this.processingEnv.getTypeUtils().isAssignable(executableElement.getReturnType(), typeMirror)) continue;
            throw new LayerGenerationException("Not assignable to " + typeMirror, element);
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new LayerGenerationException("Method must be public", element);
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new LayerGenerationException("Method must be static", element);
        }
        List<? extends VariableElement> list3 = executableElement.getParameters();
        if (list3.size() > 2) {
            throw new LayerGenerationException("Method must take at most two parameters", element);
        }
        for (VariableElement variableElement : list3) {
            if (((Object)variableElement.asType()).equals(this.processingEnv.getElementUtils().getTypeElement(Project.class.getCanonicalName()).asType()) || ((Object)variableElement.asType()).equals(this.processingEnv.getElementUtils().getTypeElement(Lookup.class.getCanonicalName()).asType())) continue;
            throw new LayerGenerationException("Method parameters may be either Lookup or Project", element);
        }
        if (!executableElement.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new LayerGenerationException("Class must be public", element);
        }
        return new String[]{this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString(), executableElement.getSimpleName().toString()};
    }

    private DeclaredType findLookupMergerType(DeclaredType declaredType) {
        String string = ((Object)this.processingEnv.getTypeUtils().erasure(declaredType)).toString();
        if (string.equals(LookupMerger.class.getName())) {
            List<? extends TypeMirror> list = declaredType.getTypeArguments();
            if (list.size() == 1) {
                return (DeclaredType)list.get(0);
            }
            return null;
        }
        for (TypeMirror typeMirror : this.processingEnv.getTypeUtils().directSupertypes(declaredType)) {
            DeclaredType declaredType2 = this.findLookupMergerType((DeclaredType)typeMirror);
            if (declaredType2 == null) continue;
            return declaredType2;
        }
        return null;
    }
}

