/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.build.model;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.ReaderFactory;
import hidden.org.codehaus.plexus.util.StringUtils;
import hidden.org.codehaus.plexus.util.xml.XmlStreamReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.aspect.PBEDerivativeReporterAspect;
import org.apache.maven.project.aspect.ProjectArtifactErrorReporterAspect;
import org.apache.maven.project.aspect.ProjectIOErrorReporterAspect;
import org.apache.maven.project.build.model.DefaultModelLineage;
import org.apache.maven.project.build.model.ModelAndFile;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultModelLineageBuilder
implements ModelLineageBuilder,
LogEnabled {
    public static final String ROLE_HINT = "default";
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private MavenTools mavenTools;
    private ProfileAdvisor profileAdvisor;
    private ProjectWorkspace projectWorkspace;
    private Logger logger;

    public DefaultModelLineageBuilder() {
    }

    public DefaultModelLineageBuilder(ArtifactResolver resolver, ArtifactFactory artifactFactory) {
        this.artifactResolver = resolver;
        this.artifactFactory = artifactFactory;
    }

    public ModelLineage buildModelLineage(File pom, ProjectBuilderConfiguration config, List remoteRepositories, boolean allowStubs, boolean isReactorProject) throws ProjectBuildingException {
        DefaultModelLineage lineage = new DefaultModelLineage();
        List currentRemoteRepositories = remoteRepositories == null ? new ArrayList() : new ArrayList(remoteRepositories);
        ModelAndFile current = this.projectWorkspace.getModelAndFile(pom);
        if (current == null) {
            current = new ModelAndFile(this.readModel(pom), pom, isReactorProject);
            this.projectWorkspace.storeModelAndFile(current);
        }
        do {
            currentRemoteRepositories = this.updateRepositorySet(current.getModel(), currentRemoteRepositories, current.getFile(), config, current.isValidProfilesXmlLocation());
            if (lineage.size() == 0) {
                lineage.setOrigin(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
                continue;
            }
            lineage.addParent(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
        } while ((current = this.resolveParentPom(current, currentRemoteRepositories, config, allowStubs, isReactorProject)) != null);
        return lineage;
    }

    public void resumeBuildingModelLineage(ModelLineage lineage, ProjectBuilderConfiguration config, boolean allowStubs, boolean isReactorProject) throws ProjectBuildingException {
        if (lineage.size() == 0) {
            throw new ProjectBuildingException("unknown", "Cannot resume a ModelLineage that doesn't contain at least one Model instance.");
        }
        List currentRemoteRepositories = lineage.getDeepestAncestorArtifactRepositoryList();
        if (currentRemoteRepositories == null) {
            currentRemoteRepositories = new ArrayList();
        }
        currentRemoteRepositories.addAll(lineage.getOriginatingArtifactRepositoryList());
        ModelAndFile current = new ModelAndFile(lineage.getDeepestAncestorModel(), lineage.getDeepestAncestorFile(), lineage.isDeepestAncestorUsingProfilesXml());
        current = this.resolveParentPom(current, currentRemoteRepositories, config, allowStubs, isReactorProject);
        while (current != null) {
            lineage.addParent(current.getModel(), current.getFile(), currentRemoteRepositories, current.isValidProfilesXmlLocation());
            currentRemoteRepositories = this.updateRepositorySet(current.getModel(), currentRemoteRepositories, current.getFile(), config, current.isValidProfilesXmlLocation());
            current = this.resolveParentPom(current, currentRemoteRepositories, config, allowStubs, isReactorProject);
        }
    }

    private Model readModel(File file) throws ProjectBuildingException {
        Model model;
        File file2 = file;
        Object[] objectArray = new Object[]{file2};
        ProjectIOErrorReporterAspect.ajc$cflowStack$3.push(objectArray);
        try {
            Model model2;
            File pomFile;
            if (pomFile.isDirectory()) {
                pomFile = new File(pomFile, "pom.xml");
            }
            XmlStreamReader reader = null;
            try {
                try {
                    reader = ReaderFactory.newXmlReader(pomFile);
                    model2 = new MavenXpp3Reader().read(reader);
                }
                catch (IOException e) {
                    IOException iOException = e;
                    File file3 = pomFile;
                    String string = "Failed to read model from: " + pomFile;
                    String string2 = "unknown";
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid() && ProjectIOErrorReporterAspect.ajc$cflowStack$4.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$4$35fd0ac6((ModelAndFile)ProjectIOErrorReporterAspect.ajc$cflowStack$4.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), iOException);
                    }
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid() && !ProjectIOErrorReporterAspect.ajc$cflowCounter$5.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$6$b9cf7859((File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), iOException);
                    }
                    throw new ProjectBuildingException(string2, string, file3, iOException);
                }
                catch (XmlPullParserException e) {
                    XmlPullParserException xmlPullParserException = e;
                    File file4 = pomFile;
                    String string = "Failed to parse model from: " + pomFile;
                    String string3 = "unknown";
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$2.isValid() && ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$3$fadd25ea((ModelAndFile)ProjectIOErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), xmlPullParserException);
                    }
                    if (ProjectIOErrorReporterAspect.ajc$cflowStack$3.isValid() && !ProjectIOErrorReporterAspect.ajc$cflowCounter$5.isValid()) {
                        ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$5$4dc6227d((File)ProjectIOErrorReporterAspect.ajc$cflowStack$3.get(0), xmlPullParserException);
                    }
                    throw new ProjectBuildingException(string3, string, file4, xmlPullParserException);
                }
            }
            finally {
                IOUtil.close(reader);
            }
            model = model2;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowStack$3.pop();
        }
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private List updateRepositorySet(Model model, List list, File file, ProjectBuilderConfiguration projectBuilderConfiguration, boolean bl) throws ProjectBuildingException {
        ArrayList arrayList;
        Model model2 = model;
        List list2 = list;
        File file2 = file;
        ProjectBuilderConfiguration projectBuilderConfiguration2 = projectBuilderConfiguration;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{model2, file2};
        PBEDerivativeReporterAspect.ajc$cflowStack$1.push(objectArray);
        try {
            void model3;
            List repositories = model3.getRepositories();
            LinkedHashSet artifactRepositories = null;
            if (repositories != null) {
                void pomFile;
                try {
                    void useProfilesXml;
                    void config;
                    void oldArtifactRepositories;
                    void lastRemoteRepos = oldArtifactRepositories;
                    List remoteRepos = this.mavenTools.buildArtifactRepositories(repositories);
                    this.loadActiveProfileRepositories(remoteRepos, (Model)model3, (ProjectBuilderConfiguration)config, (File)pomFile, (boolean)useProfilesXml);
                    artifactRepositories = new LinkedHashSet(remoteRepos.size() + oldArtifactRepositories.size());
                    artifactRepositories.addAll(remoteRepos);
                    artifactRepositories.addAll(lastRemoteRepos);
                }
                catch (InvalidRepositoryException e) {
                    throw new ProjectBuildingException(model3.getId(), "Failed to create ArtifactRepository list for: " + pomFile, (File)pomFile, e);
                }
            }
            arrayList = new ArrayList(artifactRepositories);
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowStack$1.pop();
        }
        return arrayList;
    }

    private void loadActiveProfileRepositories(List repositories, Model model, ProjectBuilderConfiguration config, File pomFile, boolean useProfilesXml) throws ProjectBuildingException {
        ProfileActivationContext context = config.getGlobalProfileManager() != null ? config.getGlobalProfileManager().getProfileActivationContext() : new DefaultProfileActivationContext(config.getExecutionProperties(), false);
        LinkedHashSet profileRepos = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, config.getGlobalProfileManager());
        LinkedHashSet pomProfileRepos = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, useProfilesXml, context);
        profileRepos.addAll(pomProfileRepos);
        if (!profileRepos.isEmpty()) {
            repositories.addAll(profileRepos);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ModelAndFile resolveParentPom(ModelAndFile modelAndFile, List list, ProjectBuilderConfiguration projectBuilderConfiguration, boolean bl, boolean bl2) throws ProjectBuildingException {
        ModelAndFile modelAndFile2;
        ModelAndFile modelAndFile3 = modelAndFile;
        List list2 = list;
        ProjectBuilderConfiguration projectBuilderConfiguration2 = projectBuilderConfiguration;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        ProjectIOErrorReporterAspect.ajc$cflowCounter$5.inc();
        try {
            ModelAndFile modelAndFile4;
            Object[] objectArray = new Object[]{modelAndFile3};
            ProjectIOErrorReporterAspect.ajc$cflowStack$4.push(objectArray);
            try {
                ModelAndFile modelAndFile5;
                block29: {
                    Object[] objectArray2 = new Object[]{modelAndFile3};
                    ProjectIOErrorReporterAspect.ajc$cflowStack$2.push(objectArray2);
                    try {
                        void child;
                        Model model = child.getModel();
                        File modelPomFile = child.getFile();
                        Parent modelParent = model.getParent();
                        ModelAndFile result = null;
                        if (modelParent != null) {
                            Model parent;
                            void allowStubs;
                            void childIsReactorProject;
                            this.validateParentDeclaration(modelParent, model);
                            String cfr_ignored_0 = String.valueOf(modelParent.getGroupId()) + ":" + modelParent.getArtifactId() + ":" + modelParent.getVersion();
                            File parentPomFile = null;
                            if (childIsReactorProject != false && modelPomFile != null) {
                                String relativePath = modelParent.getRelativePath();
                                File modelDir = modelPomFile.getParentFile();
                                parentPomFile = new File(modelDir, relativePath);
                                if (parentPomFile.isDirectory()) {
                                    parentPomFile = new File(parentPomFile, "pom.xml");
                                }
                                if ((result = this.projectWorkspace.getModelAndFile(parentPomFile)) != null && !this.parentModelMatches(modelParent, result.getModel())) {
                                    parentPomFile = null;
                                    result = null;
                                }
                            }
                            if (result == null) {
                                result = this.projectWorkspace.getModelAndFile(modelParent.getGroupId(), modelParent.getArtifactId(), modelParent.getVersion());
                            }
                            if (result != null) {
                                modelAndFile5 = result;
                                break block29;
                            }
                            if (parentPomFile != null) {
                                if (parentPomFile.exists()) {
                                    Model parentModel = this.readModel(parentPomFile);
                                    if (!this.parentModelMatches(modelParent, parentModel)) {
                                        parentPomFile = null;
                                    }
                                } else {
                                    parentPomFile = null;
                                }
                            }
                            boolean isResolved = false;
                            if (parentPomFile == null) {
                                try {
                                    void remoteRepositories;
                                    void config;
                                    parentPomFile = this.resolveParentFromRepositories(modelParent, (ProjectBuilderConfiguration)config, (List)remoteRepositories, model.getId(), modelPomFile);
                                    isResolved = true;
                                }
                                catch (ProjectBuildingException e) {
                                    if (allowStubs != false) {
                                        this.getLogger().warn("An error was encountered while resolving artifact for: " + modelParent.getId() + "\n\nError was: " + e.getMessage());
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug("Stack trace: ", e);
                                        }
                                        parentPomFile = null;
                                    }
                                    throw e;
                                }
                            }
                            if (parentPomFile == null) {
                                if (allowStubs != false) {
                                    this.getLogger().warn("Cannot find parent POM: " + modelParent.getId() + " for child: " + model.getId() + ".\n\nMaven is using a stub model instead for this build.");
                                    parent = new Model();
                                    parent.setGroupId(modelParent.getGroupId());
                                    parent.setArtifactId(modelParent.getArtifactId());
                                    parent.setVersion(modelParent.getVersion());
                                    result = new ModelAndFile(parent, parentPomFile, false);
                                } else {
                                    this.getLogger().error("Cannot find parent POM: " + modelParent.getId());
                                }
                            } else {
                                parent = this.readModel(parentPomFile);
                                result = new ModelAndFile(parent, parentPomFile, !isResolved);
                            }
                        }
                        if (result != null) {
                            this.projectWorkspace.storeModelAndFile(result);
                        }
                        modelAndFile5 = result;
                    }
                    finally {
                        ProjectIOErrorReporterAspect.ajc$cflowStack$2.pop();
                    }
                }
                modelAndFile4 = modelAndFile5;
            }
            finally {
                ProjectIOErrorReporterAspect.ajc$cflowStack$4.pop();
            }
            modelAndFile2 = modelAndFile4;
        }
        finally {
            ProjectIOErrorReporterAspect.ajc$cflowCounter$5.dec();
        }
        return modelAndFile2;
    }

    private boolean parentModelMatches(Parent modelParent, Model parentModel) {
        boolean versionsMatch;
        boolean groupsMatch = parentModel.getGroupId() == null || parentModel.getGroupId().equals(modelParent.getGroupId());
        boolean bl = versionsMatch = parentModel.getVersion() == null || parentModel.getVersion().equals(modelParent.getVersion());
        return groupsMatch && versionsMatch && parentModel.getArtifactId().equals(modelParent.getArtifactId());
    }

    private void validateParentDeclaration(Parent modelParent, Model model) throws ProjectBuildingException {
        if (StringUtils.isEmpty(modelParent.getGroupId())) {
            throw new ProjectBuildingException(model.getId(), "Missing groupId element from parent element");
        }
        if (StringUtils.isEmpty(modelParent.getArtifactId())) {
            throw new ProjectBuildingException(model.getId(), "Missing artifactId element from parent element");
        }
        if (modelParent.getGroupId().equals(model.getGroupId()) && modelParent.getArtifactId().equals(model.getArtifactId())) {
            throw new ProjectBuildingException(model.getId(), "Parent element is a duplicate of the current project ");
        }
        if (StringUtils.isEmpty(modelParent.getVersion())) {
            throw new ProjectBuildingException(model.getId(), "Missing version element from parent element");
        }
    }

    /*
     * WARNING - void declaration
     */
    private File resolveParentFromRepositories(Parent parent, ProjectBuilderConfiguration projectBuilderConfiguration, List list, String string, File file) throws ProjectBuildingException {
        File file2;
        Parent parent2 = parent;
        ProjectBuilderConfiguration projectBuilderConfiguration2 = projectBuilderConfiguration;
        List list2 = list;
        String string2 = string;
        File file3 = file;
        Object[] objectArray = new Object[]{parent2, projectBuilderConfiguration2, list2, string2, file3};
        ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            void childId;
            void childPomFile;
            void modelParent;
            Artifact parentPomArtifact = this.artifactFactory.createBuildArtifact(modelParent.getGroupId(), modelParent.getArtifactId(), modelParent.getVersion(), "pom");
            try {
                void config;
                void remoteRepositories;
                this.artifactResolver.resolve(parentPomArtifact, (List<ArtifactRepository>)remoteRepositories, config.getLocalRepository());
            }
            catch (ArtifactResolutionException e) {
                ArtifactResolutionException artifactResolutionException = e;
                void var15_16 = childPomFile;
                String string3 = "Failed to resolve parent POM: " + modelParent.getId();
                void var17_18 = childId;
                if (ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.isValid()) {
                    ProjectArtifactErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectArtifactErrorReporterAspect$2$8c18d679((Parent)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(0), (ProjectBuilderConfiguration)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(1), (List)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(2), (String)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(3), (File)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(4), artifactResolutionException);
                }
                throw new ProjectBuildingException((String)var17_18, string3, (File)var15_16, artifactResolutionException);
            }
            catch (ArtifactNotFoundException e) {
                ArtifactNotFoundException artifactNotFoundException = e;
                void var19_20 = childPomFile;
                String string4 = "Cannot find artifact for parent POM: " + modelParent.getId();
                void var21_22 = childId;
                if (ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.isValid()) {
                    ProjectArtifactErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectArtifactErrorReporterAspect$1$cfd6ffdc((Parent)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(0), (ProjectBuilderConfiguration)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(1), (List)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(2), (String)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(3), (File)ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.get(4), artifactNotFoundException);
                }
                throw new ProjectBuildingException((String)var21_22, string4, (File)var19_20, artifactNotFoundException);
            }
            file2 = parentPomArtifact.isResolved() ? parentPomArtifact.getFile() : null;
        }
        finally {
            ProjectArtifactErrorReporterAspect.ajc$cflowStack$0.pop();
        }
        return file2;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "DefaultModelLineageBuilder:internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

