/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.conflict.ConflictResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolutionRequest {
    private Artifact artifact;
    private Set<Artifact> artifactDependencies;
    private String groupId;
    private String artifactId;
    private String version;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepostories;
    private ArtifactFilter filter;
    private List<ResolutionListener> listeners = new ArrayList<ResolutionListener>();
    private ArtifactMetadataSource metadataSource;
    private Map managedVersionMap;
    private List<ConflictResolver> conflictResolvers;

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResolutionRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public boolean hasArtifact() {
        return this.artifact != null;
    }

    public ArtifactResolutionRequest setArtifactDependencies(Set<Artifact> artifactDependencies) {
        this.artifactDependencies = artifactDependencies;
        return this;
    }

    public Set<Artifact> getArtifactDependencies() {
        return this.artifactDependencies;
    }

    public String getGroupId() {
        if (this.artifact != null) {
            return this.artifact.getGroupId();
        }
        return this.groupId;
    }

    public ArtifactResolutionRequest setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        if (this.artifact != null) {
            return this.artifact.getArtifactId();
        }
        return this.artifactId;
    }

    public ArtifactResolutionRequest setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getVersion() {
        if (this.artifact != null) {
            return this.artifact.getVersion();
        }
        return this.version;
    }

    public ArtifactResolutionRequest setVersion(String version) {
        this.version = version;
        return this;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public ArtifactResolutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public List<ArtifactRepository> getRemoteRepostories() {
        return this.remoteRepostories;
    }

    public ArtifactResolutionRequest setRemoteRepostories(List<ArtifactRepository> remoteRepostories) {
        this.remoteRepostories = remoteRepostories;
        return this;
    }

    public ArtifactFilter getFilter() {
        return this.filter;
    }

    public ArtifactResolutionRequest setFilter(ArtifactFilter filter) {
        this.filter = filter;
        return this;
    }

    public List<ResolutionListener> getListeners() {
        return this.listeners;
    }

    public ArtifactResolutionRequest addListener(ResolutionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ArtifactMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public ArtifactResolutionRequest setMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
        return this;
    }

    public Map getManagedVersionMap() {
        return this.managedVersionMap;
    }

    public ArtifactResolutionRequest setManagedVersionMap(Map managedVersionMap) {
        this.managedVersionMap = managedVersionMap;
        return this;
    }

    public List<ConflictResolver> getConflictResolvers() {
        return this.conflictResolvers;
    }

    public ArtifactResolutionRequest setConflictResolvers(List<ConflictResolver> conflictResolvers) {
        this.conflictResolvers = conflictResolvers;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.getGroupId()).append(":").append(this.getArtifactId()).append(":").append(this.getVersion());
        return sb.toString();
    }
}

