/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.installer;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    private ArtifactTransformationManager transformationManager;
    private RepositoryMetadataManager repositoryMetadataManager;

    @Deprecated
    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.install(source, artifact, localRepository);
    }

    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        try {
            this.transformationManager.transformForInstall(artifact, localRepository);
            String localPath = localRepository.pathOf(artifact);
            File destination = new File(localRepository.getBasedir(), localPath);
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            this.getLogger().info("Installing " + source.getPath() + " to " + destination);
            FileUtils.copyFile(source, destination);
            for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                this.repositoryMetadataManager.install(metadata, localRepository);
            }
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Error installing artifact: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataInstallationException e) {
            throw new ArtifactInstallationException("Error installing artifact's metadata: " + e.getMessage(), e);
        }
    }
}

