/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.AbstractEntryWithSources;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgEntry;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetBeansOrgCachedEntry
extends AbstractEntryWithSources {
    private static final Logger LOG = Logger.getLogger(NetBeansOrgCachedEntry.class.getName());
    private final File nb_all;
    private final File nbdestdir;
    private final String cnb;
    private final File jar;
    private final String classPathExtensions;
    private final File sourceLocation;
    private final String netbeansOrgPath;
    private final String[] buildPrerequisites;
    private final File cluster;
    private final String[] runtimeDependencies;
    private final String[] testDependencies;
    private ModuleEntry officialEntry;
    private URL javadoc;

    public NetBeansOrgCachedEntry(File file, File file2, String string, File file3, File[] fileArray, File file4, String string2, String[] stringArray, String string3, String[] stringArray2, String[] stringArray3) {
        super(null);
        this.nb_all = file;
        this.nbdestdir = FileUtil.normalizeFile((File)file2);
        this.cnb = string;
        this.jar = FileUtil.normalizeFile((File)file3);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file5 : fileArray) {
            stringBuilder.append(File.pathSeparatorChar);
            stringBuilder.append(FileUtil.normalizeFile((File)file5).getAbsolutePath());
        }
        this.classPathExtensions = stringBuilder.toString();
        this.sourceLocation = FileUtil.normalizeFile((File)file4);
        this.netbeansOrgPath = string2;
        this.buildPrerequisites = stringArray;
        this.cluster = new File(this.nbdestdir, string3);
        this.runtimeDependencies = stringArray2;
        this.testDependencies = stringArray3;
    }

    @Override
    public String getNetBeansOrgPath() {
        return this.netbeansOrgPath;
    }

    @Override
    public File getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public String getCodeNameBase() {
        return this.cnb;
    }

    @Override
    public File getClusterDirectory() {
        return this.cluster;
    }

    @Override
    public File getJarLocation() {
        return this.jar;
    }

    @Override
    public String getClassPathExtensions() {
        if (this.officialEntry != null) {
            return this.officialEntry.getClassPathExtensions();
        }
        return this.classPathExtensions;
    }

    private synchronized void ensureOfficialEntry(String string) {
        if (this.officialEntry == null) {
            LOG.fine("Had to fall back to loading official entry for " + this.cnb + " because of " + string);
            HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
            try {
                ModuleList.scanPossibleProject(this.sourceLocation, hashMap, NbModuleProvider.NbModuleType.NETBEANS_ORG, this.nb_all, this.nbdestdir, this.netbeansOrgPath);
                this.officialEntry = (ModuleEntry)hashMap.get(this.cnb);
                if (this.officialEntry == null) {
                    LOG.fine("Failed to load official entry for " + this.cnb);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, null, iOException);
            }
        }
    }

    @Override
    public String getReleaseVersion() {
        this.ensureOfficialEntry("getReleaseVersion");
        if (this.officialEntry != null) {
            return this.officialEntry.getReleaseVersion();
        }
        return null;
    }

    @Override
    public String[] getProvidedTokens() {
        this.ensureOfficialEntry("getProvidedTokens");
        if (this.officialEntry != null) {
            return this.officialEntry.getProvidedTokens();
        }
        return new String[0];
    }

    @Override
    public ManifestManager.PackageExport[] getPublicPackages() {
        this.ensureOfficialEntry("getPublicPackages");
        if (this.officialEntry != null) {
            return this.officialEntry.getPublicPackages();
        }
        return new ManifestManager.PackageExport[0];
    }

    @Override
    public boolean isDeclaredAsFriend(String string) {
        this.ensureOfficialEntry("isDeclaredAsFriend");
        if (this.officialEntry != null) {
            return this.officialEntry.isDeclaredAsFriend(string);
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        this.ensureOfficialEntry("isDeprecated");
        if (this.officialEntry != null) {
            return this.officialEntry.isDeprecated();
        }
        return false;
    }

    @Override
    public Set<String> getPublicClassNames() {
        this.ensureOfficialEntry("getPublicClassNames");
        if (this.officialEntry != null) {
            return this.officialEntry.getPublicClassNames();
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "NetBeansOrgCachedEntry[" + this.getSourceLocation() + (this.officialEntry != null ? "->" + this.officialEntry : "") + "]";
    }

    @Override
    public URL getJavadoc(NbPlatform nbPlatform) {
        if (this.javadoc == null) {
            this.javadoc = NetBeansOrgEntry.findJavadocForNetBeansOrgModules(this, this.nbdestdir);
        }
        return this.javadoc;
    }
}

