/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.quicksearch;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.quicksearch.NewQuickSearchIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class QuickSearchPanel
extends BasicWizardIterator.Panel {
    private NewQuickSearchIterator.DataModel data;
    private JLabel categoryNameLabel;
    private JTextField categoryNameTextField;
    private JTextField classNameTextField;
    private JLabel commandLabel;
    private JTextField commandPrefixTextField;
    private JLabel fileNameLabel;
    private JComboBox packageCombo;
    private JLabel packageLabel;
    private JLabel positionLabel;
    private JTextField positionTextField;

    QuickSearchPanel(WizardDescriptor wizardDescriptor, NewQuickSearchIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", this.getMessage("LBL_QuickSearchPanel_Title"));
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                QuickSearchPanel.this.checkValidity();
            }
        };
        if (dataModel.getPackageName() != null) {
            this.packageCombo.setSelectedItem(dataModel.getPackageName());
        }
        this.classNameTextField.getDocument().addDocumentListener(documentAdapter);
        this.categoryNameTextField.getDocument().addDocumentListener(documentAdapter);
        this.commandPrefixTextField.getDocument().addDocumentListener(documentAdapter);
        this.positionTextField.getDocument().addDocumentListener(documentAdapter);
        Component component = this.packageCombo.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(documentAdapter);
        }
    }

    protected String getPanelName() {
        return this.getMessage("LBL_QuickSearchPanel_Title");
    }

    protected void storeToDataModel() {
        this.data.setClassName(this.normalize(this.classNameTextField.getText().trim()));
        this.data.setCommandPrefix(this.commandPrefixTextField.getText().trim());
        this.data.setCategoryName(this.categoryNameTextField.getText().trim());
        this.data.setPosition(Integer.parseInt(this.positionTextField.getText()));
        this.data.setPackageName(this.packageCombo.getEditor().getItem().toString());
        NewQuickSearchIterator.generateFileChanges(this.data);
    }

    protected void readFromDataModel() {
        this.classNameTextField.setText(this.data.getClassName());
        this.commandPrefixTextField.setText(this.data.getCommandPrefix());
        this.categoryNameTextField.setText(this.data.getCategoryName());
        this.positionTextField.setText(this.data.getPosition().toString());
        this.packageCombo.setSelectedItem(this.data.getPackageName());
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(QuickSearchPanel.class);
    }

    private boolean checkValidity() {
        String string = this.classNameTextField.getText().trim();
        if (string.length() == 0) {
            this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.normalize(string))) {
            this.setError(this.getMessage("ERR_FN_INVALID"));
            return false;
        }
        String string2 = this.packageCombo.getEditor().getItem().toString();
        if (string2.equals("")) {
            this.setWarning(this.getMessage("EMPTY_PACKAGE"), false);
            return false;
        }
        if (this.categoryNameTextField.getText().equals("")) {
            this.setWarning(this.getMessage("EMPTY_CATEGORY"), false);
            return false;
        }
        if (this.commandPrefixTextField.getText().trim().equals("")) {
            this.setWarning(this.getMessage("ERR_EMPTY_PREFIX"), false);
        }
        if (!this.commandPrefixTextField.getText().trim().matches("\\w*")) {
            this.setError(this.getMessage("ERR_PREFIX_INVALID"));
            return false;
        }
        if (this.positionTextField.getText().equals("")) {
            this.setWarning(this.getMessage("ERR_POSITION_EMPTY"), false);
            return false;
        }
        if (!this.positionTextField.getText().trim().matches("\\d*")) {
            this.setError(this.getMessage("ERR_POSITION_INVALID"));
            return false;
        }
        this.markValid();
        return true;
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageCombo = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.categoryNameLabel = new JLabel();
        this.categoryNameTextField = new JTextField();
        this.commandLabel = new JLabel();
        this.commandPrefixTextField = new JTextField();
        this.positionLabel = new JLabel();
        this.positionTextField = new JTextField();
        this.fileNameLabel.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.fileNameLabel.text"));
        this.classNameTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.classNameTextField.text"));
        this.packageLabel.setLabelFor(this.packageCombo);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageLabel.text"));
        this.packageCombo.setEditable(true);
        this.categoryNameLabel.setLabelFor(this.categoryNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameLabel.text"));
        this.categoryNameTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameTextField.text"));
        this.commandLabel.setLabelFor(this.commandPrefixTextField);
        Mnemonics.setLocalizedText((JLabel)this.commandLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandLabel.text"));
        this.commandPrefixTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.text"));
        this.positionLabel.setLabelFor(this.positionTextField);
        Mnemonics.setLocalizedText((JLabel)this.positionLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionLabel.text"));
        this.positionTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionTextField.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileNameLabel).add((Component)this.packageLabel).add((Component)this.categoryNameLabel).add((Component)this.commandLabel).add((Component)this.positionLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.classNameTextField, -1, 231, Short.MAX_VALUE).add((Component)this.packageCombo, 0, 231, Short.MAX_VALUE).add((Component)this.categoryNameTextField, -1, 231, Short.MAX_VALUE).add((Component)this.commandPrefixTextField, -1, 231, Short.MAX_VALUE).add((Component)this.positionTextField, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileNameLabel).add((Component)this.classNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageCombo, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.categoryNameLabel).add((Component)this.categoryNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.commandLabel).add((Component)this.commandPrefixTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.positionLabel).add((Component)this.positionTextField, -2, -1, -2)).addContainerGap(124, Short.MAX_VALUE)));
        this.fileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.fileNameLabel.AccessibleContext.accessibleDescription"));
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.classNameTextField.AccessibleContext.accessibleDescription"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageLabel.AccessibleContext.accessibleDescription"));
        this.packageCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageCombo.AccessibleContext.accessibleName"));
        this.packageCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageCombo.AccessibleContext.accessibleDescription"));
        this.categoryNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameLabel.AccessibleContext.accessibleDescription"));
        this.categoryNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameTextField.AccessibleContext.accessibleDescription"));
        this.commandLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandLabel.AccessibleContext.accessibleDescription"));
        this.commandPrefixTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.AccessibleContext.accessibleName"));
        this.commandPrefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.AccessibleContext.accessibleDescription"));
        this.positionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionLabel.AccessibleContext.accessibleDescription"));
        this.positionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.AccessibleContext.accessibleDescription"));
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(QuickSearchPanel.class, (String)string);
    }

    private String normalize(String string) {
        if (string.endsWith(".java")) {
            return string.substring(0, string.length() - 5);
        }
        return string;
    }
}

