/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.javahelp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.javahelp.NewJavaHelpIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class JavaHelpPanel
extends BasicWizardIterator.Panel {
    private NewJavaHelpIterator.DataModel data;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;

    public JavaHelpPanel(WizardDescriptor wizardDescriptor, NewJavaHelpIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage(JavaHelpPanel.class, (String)"LBL_JavaHelpWizardTitle"));
    }

    protected void storeToDataModel() {
    }

    protected void readFromDataModel() {
    }

    private void updateData() {
        this.createdFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] stringArray = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (stringArray.length > 0) {
            this.setError(NbBundle.getMessage(JavaHelpPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)stringArray[0]));
        } else {
            this.markValid();
        }
    }

    protected String getPanelName() {
        return NbBundle.getMessage(JavaHelpPanel.class, (String)"LBL_JavaHelpPanel_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(JavaHelpPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(JavaHelpPanel.class, (String)string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(JavaHelpPanel.getMessage("ACS_JavaHelpPanel"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(JavaHelpPanel.getMessage("ACS_CTL_ProjectName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(JavaHelpPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(JavaHelpPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    public void addNotify() {
        super.addNotify();
        this.updateData();
    }

    private void initComponents() {
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/javahelp/Bundle").getString("LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/javahelp/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/javahelp/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
    }
}

