/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.queries.FileEncodingQueryImpl;
import org.netbeans.modules.apisupport.project.queries.TemplateAttributesProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteSubprojectProviderImpl;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.modules.apisupport.project.ui.SuiteLogicalView;
import org.netbeans.modules.apisupport.project.ui.SuiteOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class SuiteProject
implements Project {
    public static final String SUITE_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/suite.png";
    private final AntProjectHelper helper;
    private Lookup lookup;
    private final PropertyEvaluator eval;
    private final GeneratedFilesHelper genFilesHelper;

    public SuiteProject(AntProjectHelper antProjectHelper) throws IOException {
        this.helper = antProjectHelper;
        this.eval = this.createEvaluator();
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        Util.err.log("Loading suite project in " + this.getProjectDirectory());
        this.lookup = Lookups.fixed((Object[])new Object[]{this, new Info(), antProjectHelper.createAuxiliaryConfiguration(), antProjectHelper.createCacheDirectoryProvider(), new SavedHook(), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new OpenedHook()), antProjectHelper.createSharabilityQuery(this.eval, new String[0], new String[]{"build", "${dist.dir}"}), new SuiteSubprojectProviderImpl(antProjectHelper, this.eval), new SuiteProviderImpl(), new SuiteActions(this), new SuiteLogicalView(this), new SuiteCustomizer(this, antProjectHelper, this.eval), new PrivilegedTemplatesImpl(), new SuiteOperations(this), new TemplateAttributesProvider(antProjectHelper, false), new FileEncodingQueryImpl()});
        this.lookup = LookupProviderSupport.createCompositeLookup((Lookup)this.lookup, (String)"Projects/org-netbeans-modules-apisupport-project-suite/Lookup");
    }

    public String toString() {
        return "SuiteProject[" + this.getProjectDirectory() + "]";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getProjectDirectory());
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    public File getTestUserDirLockFile() {
        return this.getHelper().resolveFile(this.getEvaluator().evaluate("${test.user.dir}/lock"));
    }

    public NbPlatform getPlatform(boolean bl) {
        String string = this.getEvaluator().getProperty("netbeans.dest.dir");
        NbPlatform nbPlatform = string != null ? NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(string)) : null;
        if (bl && (nbPlatform == null || !nbPlatform.isValid())) {
            nbPlatform = NbPlatform.getDefaultPlatform();
        }
        return nbPlatform;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyProvider propertyProvider = this.helper.getStockPropertyPreprovider();
        File file = this.getProjectDirectoryFile();
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        arrayList.add(this.helper.getPropertyProvider("nbproject/private/platform-private.properties"));
        arrayList.add(this.helper.getPropertyProvider("nbproject/platform.properties"));
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        arrayList.add(new Util.UserPropertiesFileProvider(propertyEvaluator, file));
        propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DestDirProvider
        extends Util.ComputedPropertyProvider {
            public DestDirProvider(PropertyEvaluator propertyEvaluator) {
                super(propertyEvaluator);
            }

            @Override
            protected Map<String, String> getProperties(Map<String, String> map) {
                String string = map.get("nbplatform.active");
                if (string != null) {
                    return Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + string + ".netbeans.dest.dir}");
                }
                return Collections.emptyMap();
            }

            @Override
            protected Set<String> inputProperties() {
                return Collections.singleton("nbplatform.active");
            }
        }
        arrayList.add(new DestDirProvider(propertyEvaluator));
        arrayList.add(this.helper.getPropertyProvider("nbproject/private/private.properties"));
        arrayList.add(this.helper.getPropertyProvider("nbproject/project.properties"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("enabled.clusters", "");
        hashMap.put("disabled.clusters", "");
        hashMap.put("disabled.modules", "");
        hashMap.put("branding.dir", "branding");
        hashMap.put("dist.dir", "dist");
        hashMap.put("test.user.dir", "build/testuserdir");
        arrayList.add(PropertyUtils.fixedPropertyProvider(hashMap));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    public void open() {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                String string = "nbproject/private/platform-private.properties";
                EditableProperties editableProperties = SuiteProject.this.helper.getProperties(string);
                File file = new File(System.getProperty("netbeans.user"), "build.properties");
                editableProperties.setProperty("user.properties.file", file.getAbsolutePath());
                SuiteProject.this.helper.putProperties(string, editableProperties);
                try {
                    ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                return null;
            }
        });
        try {
            this.refreshBuildScripts(true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void refreshBuildScripts(boolean bl) throws IOException {
        String string = this.getPlatform(true).getHarnessVersion() <= 6 || this.eval.getProperty("cluster.path") == null ? "build-impl-65.xsl" : "build-impl.xsl";
        this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", SuiteProject.class.getResource("resources/" + string), bl);
        this.genFilesHelper.refreshBuildScript("build.xml", SuiteProject.class.getResource("resources/build.xsl"), bl);
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Ant/Project.xml", "Templates/Other/properties.properties"};
        private static final String[] RECOMMENDED_TYPES = new String[]{"oasis-XML-catalogs", "XML", "ant-script", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }
    }

    private final class SuiteProviderImpl
    implements SuiteProvider {
        private static final String CLUSTER_PROP = "${cluster}";

        private SuiteProviderImpl() {
        }

        public File getSuiteDirectory() {
            return SuiteProject.this.getProjectDirectoryFile();
        }

        public File getClusterDirectory() {
            String string = SuiteProject.this.getEvaluator().evaluate(CLUSTER_PROP);
            if (CLUSTER_PROP.equals(string)) {
                string = "build/cluster";
            }
            return SuiteProject.this.getHelper().resolveFile(string).getAbsoluteFile();
        }
    }

    private final class SavedHook
    extends ProjectXmlSavedHook {
        SavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            SuiteProject.this.refreshBuildScripts(false);
        }
    }

    private final class OpenedHook
    extends ProjectOpenedHook {
        OpenedHook() {
        }

        public void projectOpened() {
            SuiteProject.this.open();
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)SuiteProject.this);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
        }
    }

    private final class Info
    implements ProjectInformation,
    AntProjectListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
            SuiteProject.this.helper.addAntProjectListener((AntProjectListener)this);
        }

        private String getSimpleName() {
            Element element = Util.findElement(SuiteProject.this.helper.getPrimaryConfigurationData(true), "name", "http://www.netbeans.org/ns/nb-module-suite-project/1");
            String string = element != null ? Util.findText(element) : null;
            return string != null ? string : "???";
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getSimpleName());
        }

        public String getDisplayName() {
            String string = SuiteProject.this.getEvaluator().getProperty("app.title");
            if (string != null) {
                return string;
            }
            return this.getSimpleName();
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)SuiteProject.SUITE_ICON_PATH, (boolean)false);
        }

        public Project getProject() {
            return SuiteProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            this.fireNameChange();
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
            this.fireNameChange();
        }

        private void fireNameChange() {
            this.pcs.firePropertyChange("name", null, this.getName());
            this.pcs.firePropertyChange("displayName", null, this.getDisplayName());
        }
    }
}

