/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WritableXMLFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.Info,
AbstractFileSystem.List,
FileChangeListener,
PropertyChangeListener {
    private final TreeEditorCookie cookie;
    private TreeDocumentRoot doc;
    private URL location;
    private String suffix;
    private final FileChangeListener fileChangeListener;
    private ClassPath classpath;
    private static final int INDENT_STEP = 4;

    public WritableXMLFileSystem(URL uRL, TreeEditorCookie treeEditorCookie, ClassPath classPath) {
        this.attr = this;
        this.change = this;
        this.info = this;
        this.list = this;
        this.cookie = treeEditorCookie;
        this.suffix = "";
        try {
            this.doc = treeEditorCookie.openDocumentRoot();
        }
        catch (TreeException treeException) {
            Util.err.notify(1, (Throwable)treeException);
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        treeEditorCookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)treeEditorCookie));
        this.setLocation(uRL);
        this.setClasspath(classPath);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("WritableXMLFileSystem is not persistent");
    }

    private void setLocation(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.endsWith("/")) {
            throw new IllegalArgumentException(string);
        }
        this.location = uRL;
    }

    private void setClasspath(ClassPath classPath) {
        this.classpath = classPath;
    }

    public String getDisplayName() {
        FileObject fileObject = URLMapper.findFileObject((URL)this.location);
        if (fileObject != null) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }
        return this.location.toExternalForm();
    }

    public boolean isReadOnly() {
        return false;
    }

    private TreeElement getRootElement() {
        if (this.doc == null) {
            return null;
        }
        for (Object e : this.doc.getChildNodes()) {
            if (!(e instanceof TreeElement)) continue;
            return (TreeElement)e;
        }
        return null;
    }

    private TreeElement findElement(String string) {
        return WritableXMLFileSystem.findElementIn(this.getRootElement(), string);
    }

    private static TreeElement findElementIn(TreeElement treeElement, String string) {
        String string2;
        String string3;
        if (treeElement == null) {
            return null;
        }
        if (string.equals("")) {
            return treeElement;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        TreeElement treeElement2 = null;
        for (TreeElement treeElement3 : treeElement.getChildNodes(TreeElement.class)) {
            TreeAttribute treeAttribute;
            if (!treeElement3.getLocalName().equals("file") && !treeElement3.getLocalName().equals("folder") || (treeAttribute = treeElement3.getAttribute("name")) == null || !treeAttribute.getValue().equals(string3)) continue;
            treeElement2 = treeElement3;
            break;
        }
        return WritableXMLFileSystem.findElementIn(treeElement2, string2);
    }

    public boolean folder(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return false;
        }
        boolean bl = treeElement.getLocalName().equals("folder");
        return bl;
    }

    public String[] children(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (TreeElement treeElement2 : treeElement.getChildNodes(TreeElement.class)) {
            String string2;
            TreeAttribute treeAttribute;
            if (!treeElement2.getLocalName().equals("file") && !treeElement2.getLocalName().equals("folder") || (treeAttribute = treeElement2.getAttribute("name")) == null || !hashSet.add(string2 = treeAttribute.getValue())) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private byte[] getContentsOf(String string) throws FileNotFoundException {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null) {
            try {
                String string2 = treeAttribute.getValue();
                URI uRI = new URI(null, string2, null);
                boolean bl = string2.startsWith("nbres:") || string2.startsWith("nbresloc:");
                URL uRL = bl ? uRI.toURL() : new URL(this.location, uRI.getRawPath());
                URL[] uRLArray = LayerUtils.currentify(uRL, this.suffix, this.classpath);
                URLConnection uRLConnection = uRLArray[0].openConnection();
                uRLConnection.connect();
                InputStream inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[uRLConnection.getContentLength()];
                if (inputStream.read(byArray) != byArray.length) {
                    throw new IOException("wrong content length");
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[0]);
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this.fileChangeListener);
                    fileObject.addFileChangeListener(this.fileChangeListener);
                }
                return byArray;
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(iOException.getMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new FileNotFoundException(uRISyntaxException.getMessage());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : treeElement.getChildNodes()) {
            if (e instanceof TreeCDATASection) {
                stringBuffer.append(((TreeCDATASection)e).getData());
                continue;
            }
            if (!(e instanceof TreeText)) continue;
            stringBuffer.append(((TreeText)e).getData().trim());
        }
        try {
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FileNotFoundException(unsupportedEncodingException.getMessage());
        }
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getContentsOf(string));
    }

    public OutputStream outputStream(final String string) throws IOException {
        final TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null) {
            String string2 = treeAttribute.getValue();
            if (URI.create(string2).isAbsolute()) {
                throw new IOException(string);
            }
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(this.location, string2));
            if (fileObject == null) {
                throw new FileNotFoundException(string);
            }
            return fileObject.getOutputStream();
        }
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                block4: {
                    super.close();
                    final byte[] byArray = this.toByteArray();
                    final FileObject fileObject = WritableXMLFileSystem.this.findLayerParent();
                    final String string2 = LayerUtils.findGeneratedName(fileObject, string);
                    assert (string2.indexOf(47) == -1) : string2;
                    fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            FileObject fileObject2 = fileObject.createData(string2);
                            OutputStream outputStream = fileObject2.getOutputStream();
                            try {
                                outputStream.write(byArray);
                            }
                            finally {
                                outputStream.close();
                            }
                            fileObject2.addFileChangeListener(WritableXMLFileSystem.this.fileChangeListener);
                        }
                    });
                    try {
                        treeElement.addAttribute("url", string2);
                    }
                    catch (ReadOnlyException readOnlyException) {
                        throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError((Object)invalidArgumentException);
                    }
                }
            }
        };
    }

    private FileObject findLayerParent() throws IOException {
        String string = this.location.toExternalForm();
        int n = string.lastIndexOf(47);
        assert (n != -1) : string;
        FileObject fileObject = URLMapper.findFileObject((URL)new URL(string.substring(0, n + 1)));
        if (fileObject == null) {
            throw new IOException(string);
        }
        return fileObject;
    }

    private void createFileOrFolder(String string, boolean bl) throws IOException {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        TreeElement treeElement = this.findElement(string3);
        if (treeElement == null) {
            throw new FileNotFoundException(string3);
        }
        try {
            TreeElement treeElement2 = new TreeElement(bl ? "folder" : "file", true);
            treeElement2.addAttribute("name", string2);
            WritableXMLFileSystem.appendWithIndent(treeElement, (TreeChild)treeElement2);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            assert (false) : invalidArgumentException;
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    public void createFolder(String string) throws IOException {
        this.createFileOrFolder(string, true);
    }

    public void createData(String string) throws IOException {
        this.createFileOrFolder(string, false);
    }

    public void delete(String string) throws IOException {
        FileObject fileObject;
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            throw new FileNotFoundException(string);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute != null && !URI.create(treeAttribute.getValue()).isAbsolute() && (fileObject = URLMapper.findFileObject((URL)new URL(this.location, treeAttribute.getValue()))) != null) {
            fileObject.removeFileChangeListener(this.fileChangeListener);
            fileObject.delete();
        }
        try {
            WritableXMLFileSystem.deleteWithIndent((TreeChild)treeElement);
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    public void rename(String string, String string2) throws IOException {
        block7: {
            TreeElement treeElement = this.findElement(string);
            if (treeElement == null) {
                throw new FileNotFoundException(string);
            }
            int n = string2.lastIndexOf(47) + 1;
            if (n != string.lastIndexOf(47) + 1 || !string.substring(0, n).equals(string2.substring(0, n))) {
                throw new IOException("Cannot rename to a different dir: " + string + " -> " + string2);
            }
            String string3 = string2.substring(n);
            assert (string3.indexOf(47) == -1);
            assert (string3.length() > 0);
            try {
                treeElement.getAttribute("name").setValue(string3);
            }
            catch (ReadOnlyException readOnlyException) {
                throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)invalidArgumentException);
            }
        }
    }

    public Enumeration<String> attributes(String string) {
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return Enumerations.empty();
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (TreeElement treeElement2 : treeElement.getChildNodes(TreeElement.class)) {
            TreeAttribute treeAttribute;
            if (!treeElement2.getLocalName().equals("attr") || (treeAttribute = treeElement2.getAttribute("name")) == null) continue;
            arrayList.add(treeAttribute.getValue());
        }
        return Collections.enumeration(arrayList);
    }

    public Object readAttribute(String string, String string2) {
        if (string2.equals("WritableXMLFileSystem.cp")) {
            return this.classpath;
        }
        if (string2.equals("WritableXMLFileSystem.location")) {
            return this.location;
        }
        if (string2.equals("DataFolder.Index.reorderable")) {
            return Boolean.TRUE;
        }
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return null;
        }
        boolean bl = false;
        if (string2.startsWith("literal:")) {
            string2 = string2.substring("literal:".length());
            bl = true;
        }
        for (TreeElement treeElement2 : treeElement.getChildNodes(TreeElement.class)) {
            TreeAttribute treeAttribute;
            if (!treeElement2.getLocalName().equals("attr") || (treeAttribute = treeElement2.getAttribute("name")) == null || !string2.equals(treeAttribute.getValue())) continue;
            try {
                String string3;
                treeAttribute = treeElement2.getAttribute("stringvalue");
                if (treeAttribute != null) {
                    string3 = treeAttribute.getValue();
                    StringBuffer stringBuffer = new StringBuffer(string3.length());
                    for (int i = 0; i < string3.length(); ++i) {
                        char c = string3.charAt(i);
                        if (c == '\\' && string3.charAt(i + 1) == 'u' && i + 5 < string3.length()) {
                            String string4 = string3.substring(i + 2, i + 6);
                            try {
                                stringBuffer.append((char)Integer.parseInt(string4, 16));
                                i += 5;
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append(c);
                            }
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    return stringBuffer.toString();
                }
                treeAttribute = treeElement2.getAttribute("boolvalue");
                if (treeAttribute != null) {
                    return Boolean.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("urlvalue");
                if (treeAttribute != null) {
                    return new URL(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("charvalue");
                if (treeAttribute != null) {
                    return new Character(treeAttribute.getValue().charAt(0));
                }
                treeAttribute = treeElement2.getAttribute("bytevalue");
                if (treeAttribute != null) {
                    return Byte.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("shortvalue");
                if (treeAttribute != null) {
                    return Short.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("intvalue");
                if (treeAttribute != null) {
                    return Integer.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("longvalue");
                if (treeAttribute != null) {
                    return Long.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("floatvalue");
                if (treeAttribute != null) {
                    return Float.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("doublevalue");
                if (treeAttribute != null) {
                    return Double.valueOf(treeAttribute.getValue());
                }
                treeAttribute = treeElement2.getAttribute("newvalue");
                if (treeAttribute != null) {
                    string3 = treeAttribute.getValue();
                    if (!bl) continue;
                    return "new:" + string3;
                }
                treeAttribute = treeElement2.getAttribute("methodvalue");
                if (treeAttribute != null) {
                    string3 = treeAttribute.getValue();
                    if (!bl) continue;
                    return "method:" + string3;
                }
                treeAttribute = treeElement2.getAttribute("bundlevalue");
                if (treeAttribute == null) continue;
                string3 = treeAttribute.getValue();
                if (!bl) continue;
                return "bundle:" + string3;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        Object object2;
        TreeElement treeElement;
        if (object != null && object.getClass().getName().equals("org.openide.filesystems.MultiFileObject$VoidValue")) {
            object = null;
        }
        if ((treeElement = this.findElement(string)) == null) {
            throw new FileNotFoundException(string);
        }
        TreeElement treeElement2 = null;
        for (TreeElement treeElement3 : treeElement.getChildNodes(TreeElement.class)) {
            if (!treeElement3.getLocalName().equals("attr") || (object2 = treeElement3.getAttribute("name")) == null || !object2.getValue().equals(string2)) continue;
            treeElement2 = treeElement3;
            break;
        }
        try {
            TreeElement treeElement3;
            treeElement3 = new TreeElement("attr", true);
            treeElement3.addAttribute("name", string2);
            if (object instanceof String) {
                object2 = (String)object;
                if (((String)object2).startsWith("newvalue:")) {
                    treeElement3.addAttribute("newvalue", ((String)object2).substring("newvalue:".length()));
                } else if (((String)object2).startsWith("methodvalue:")) {
                    treeElement3.addAttribute("methodvalue", ((String)object2).substring("methodvalue:".length()));
                } else if (((String)object2).startsWith("bundlevalue:")) {
                    treeElement3.addAttribute("bundlevalue", ((String)object2).substring("bundlevalue:".length()));
                    TreeObjectList treeObjectList = this.doc.getChildNodes();
                    for (int i = 0; i < treeObjectList.size(); ++i) {
                        Object object3 = treeObjectList.get(i);
                        if (!(object3 instanceof TreeDocumentType)) continue;
                        TreeDocumentType treeDocumentType = (TreeDocumentType)object3;
                        treeDocumentType.setPublicId("-//NetBeans//DTD Filesystem 1.2//EN");
                        treeDocumentType.setSystemId("http://www.netbeans.org/dtds/filesystem-1_2.dtd");
                        break;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < ((String)object2).length(); ++i) {
                        char c = ((String)object2).charAt(i);
                        if (Character.isISOControl(c) || c == '&' || c == '<' || c == '>' || c == '\"' || c == '\'') {
                            stringBuffer.append(WritableXMLFileSystem.encodeChar(c));
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    treeElement3.addAttribute("stringvalue", stringBuffer.toString());
                }
            } else if (object instanceof URL) {
                treeElement3.addAttribute("urlvalue", ((URL)object).toExternalForm());
            } else if (object instanceof Boolean) {
                treeElement3.addAttribute("boolvalue", object.toString());
            } else if (object instanceof Character) {
                treeElement3.addAttribute("charvalue", object.toString());
            } else if (object instanceof Integer) {
                treeElement3.addAttribute("intvalue", object.toString());
            } else if (object != null) {
                throw new UnsupportedOperationException("XXX: " + object);
            }
            if (object != null && treeElement2 == null) {
                WritableXMLFileSystem.appendWithIndent(treeElement, (TreeChild)treeElement3);
            } else if (object != null) {
                treeElement.replaceChild((TreeChild)treeElement2, (TreeChild)treeElement3);
            } else if (treeElement2 != null) {
                WritableXMLFileSystem.deleteWithIndent((TreeChild)treeElement2);
            }
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new AssertionError((Object)invalidArgumentException);
        }
        catch (ReadOnlyException readOnlyException) {
            throw (IOException)new IOException(readOnlyException.toString()).initCause(readOnlyException);
        }
    }

    private static String encodeChar(char c) {
        String string = Integer.toString(c, 16);
        return "\\u" + "0000".substring(0, "0000".length() - string.length()).concat(string);
    }

    public void renameAttributes(String string, String string2) {
    }

    public void deleteAttributes(String string) {
    }

    public boolean readOnly(String string) {
        return false;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        try {
            return this.getContentsOf(string).length;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0L;
        }
    }

    public void markUnimportant(String string) {
    }

    public Date lastModified(String string) {
        FileObject fileObject;
        TreeElement treeElement = this.findElement(string);
        if (treeElement == null) {
            return new Date(0L);
        }
        TreeAttribute treeAttribute = treeElement.getAttribute("url");
        if (treeAttribute == null) {
            return new Date(0L);
        }
        String string2 = treeAttribute.getValue();
        URI uRI = null;
        try {
            uRI = new URI(null, string2, null);
            if (uRI.isAbsolute()) {
                return new Date(0L);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false) : uRISyntaxException;
            return new Date(0L);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(this.location, uRI == null ? string2 : uRI.getRawPath()));
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException;
            return new Date(0L);
        }
        if (fileObject == null) {
            return new Date(0L);
        }
        return fileObject.lastModified();
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    private static void appendWithIndent(TreeElement treeElement, TreeChild treeChild) throws ReadOnlyException {
        block7: {
            TreeElement treeElement2 = treeElement;
            int n = -2;
            while (treeElement2 != null) {
                treeElement2 = treeElement2.getParentNode();
                ++n;
            }
            TreeChild treeChild2 = WritableXMLFileSystem.insertBefore(treeElement, treeChild);
            try {
                if (treeChild2 != null) {
                    treeElement.insertBefore(treeChild, treeChild2);
                    treeElement.insertBefore((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((n + 1) * 4)), treeChild2);
                } else {
                    if (treeElement.hasChildNodes()) {
                        treeElement.appendChild((TreeChild)new TreeText(WritableXMLFileSystem.spaces(4)));
                    } else {
                        treeElement.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((n + 1) * 4)));
                    }
                    treeElement.appendChild(treeChild);
                    treeElement.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces(n * 4)));
                }
                treeElement.normalize();
            }
            catch (InvalidArgumentException invalidArgumentException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)invalidArgumentException);
            }
        }
    }

    private static TreeChild insertBefore(TreeElement treeElement, TreeChild treeChild) throws ReadOnlyException {
        if (!(treeChild instanceof TreeElement)) {
            return null;
        }
        TreeElement treeElement2 = (TreeElement)treeChild;
        if (treeElement2.getQName().equals("file") || treeElement2.getQName().equals("folder")) {
            String string = treeElement2.getAttribute("name").getValue();
            for (TreeElement treeElement3 : treeElement.getChildNodes(TreeElement.class)) {
                String string2;
                TreeAttribute treeAttribute;
                if (!treeElement3.getQName().equals("file") && !treeElement3.getQName().equals("folder") || (treeAttribute = treeElement3.getAttribute("name")) == null || (string2 = treeAttribute.getValue()).compareTo(string) <= 0) continue;
                return treeElement3;
            }
            return null;
        }
        if (treeElement2.getQName().equals("attr")) {
            String string = treeElement2.getAttribute("name").getValue();
            for (TreeElement treeElement4 : treeElement.getChildNodes(TreeElement.class)) {
                if (treeElement4.getQName().equals("file") || treeElement4.getQName().equals("folder")) {
                    return treeElement4;
                }
                if (treeElement4.getQName().equals("attr")) {
                    String string3;
                    TreeAttribute treeAttribute = treeElement4.getAttribute("name");
                    if (treeAttribute == null || (string3 = treeAttribute.getValue()).compareTo(string) <= 0) continue;
                    return treeElement4;
                }
                throw new AssertionError((Object)("Weird child: " + treeElement4.getQName()));
            }
            return null;
        }
        throw new AssertionError((Object)("Weird child: " + treeElement2.getQName()));
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    private static void deleteWithIndent(TreeChild treeChild) throws ReadOnlyException {
        Object object;
        block12: {
            TreeChild treeChild2 = treeChild.getNextSibling();
            if (treeChild2 instanceof TreeText && ((TreeText)treeChild2).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                treeChild2.removeFromContext();
            } else {
                object = treeChild.getPreviousSibling();
                if (object instanceof TreeText && ((TreeText)object).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                    object.removeFromContext();
                }
            }
            object = (TreeElement)treeChild.getParentNode();
            TreeObjectList treeObjectList = object.getChildNodes();
            boolean bl = true;
            for (Object object2 : treeObjectList) {
                if (object2 == treeChild) continue;
                if (!(object2 instanceof TreeText)) {
                    bl = false;
                    break;
                }
                if (((TreeText)object2).getData().trim().length() <= 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                try {
                    if (object.getParentNode() instanceof TreeDocumentRoot) {
                        Iterator iterator = treeObjectList.iterator();
                        while (iterator.hasNext()) {
                            ((TreeChild)iterator.next()).removeFromContext();
                        }
                        object.appendChild((TreeChild)new TreeText("\n"));
                    } else {
                        Object object2;
                        object2 = new TreeElement(object.getQName(), true);
                        TreeAttribute treeAttribute = object.getAttribute("name");
                        if (treeAttribute != null) {
                            object2.addAttribute("name", treeAttribute.getValue());
                        }
                        TreeParentNode treeParentNode = object.getParentNode();
                        treeParentNode.replaceChild(object, object2);
                        object = object2;
                    }
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)invalidArgumentException);
                }
            }
        }
        treeChild.removeFromContext();
        object.normalize();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.someFileChange();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.someFileChange();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.someFileChange();
    }

    private void someFileChange() {
        this.refreshResource("", true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("documentRoot")) {
            return;
        }
        if (this.cookie.getStatus() == 1 || this.cookie.getStatus() == 0) {
            try {
                this.doc = this.cookie.openDocumentRoot();
                Enumeration enumeration = this.existingFileObjects(this.getRoot());
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject = (FileObject)enumeration.nextElement();
                    this.refreshResource(fileObject.getPath(), true);
                }
            }
            catch (TreeException treeException) {
                Util.err.notify(1, (Throwable)treeException);
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
    }
}

