/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BadgingSupport
implements FileSystem.Status,
FileChangeListener {
    static final RequestProcessor RP = new RequestProcessor(BadgingSupport.class.getName());
    private String suffix = "";
    private ClassPath classpath;
    private final FileSystem fs;
    private final FileChangeListener fileChangeListener;
    private final List<FileStatusListener> listeners = new ArrayList<FileStatusListener>();
    private final Map<String, String> names = new HashMap<String, String>();
    private final Map<String, Image> smallIcons = new HashMap<String, Image>();
    private final Map<String, Image> bigIcons = new HashMap<String, Image>();

    public BadgingSupport(FileSystem fileSystem) {
        this.fs = fileSystem;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        fileSystem.addFileChangeListener(this.fileChangeListener);
    }

    public void setClasspath(ClassPath classPath) {
        this.classpath = classPath;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public void addFileStatusListener(FileStatusListener fileStatusListener) {
        this.listeners.add(fileStatusListener);
    }

    public void removeFileStatusListener(FileStatusListener fileStatusListener) {
        this.listeners.remove(fileStatusListener);
    }

    private void fireFileStatusChanged(FileStatusEvent fileStatusEvent) {
        for (FileStatusListener fileStatusListener : this.listeners) {
            fileStatusListener.annotationChanged(fileStatusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String annotateName(final String string, final Set<? extends FileObject> set) {
        Map<String, String> map = this.names;
        synchronized (map) {
            for (FileObject fileObject : set) {
                String string2 = fileObject.getPath();
                if (!this.names.containsKey(string2)) continue;
                return this.names.get(string2);
            }
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string2 = BadgingSupport.annotateNameGeneral(string, set, BadgingSupport.this.suffix, BadgingSupport.this.fileChangeListener, BadgingSupport.this.classpath);
                Map map = BadgingSupport.this.names;
                synchronized (map) {
                    for (FileObject fileObject : set) {
                        BadgingSupport.this.names.put(fileObject.getPath(), string2);
                    }
                }
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, set, false, true));
            }
        });
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static String annotateNameGeneral(String string, Set<? extends FileObject> set, String string2, FileChangeListener fileChangeListener, ClassPath classPath) {
        Iterator<? extends FileObject> iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            Object object;
            Object object2;
            FileObject fileObject2 = iterator.next();
            Object object3 = (String)fileObject2.getAttribute("literal:displayName");
            if (object3 != null) {
                object2 = ((String)object3).split(":", 2);
                if (!object2[0].equals("bundle")) return object3;
                object2 = object2[1].split("#", 2);
                object = object2[0];
                object3 = object2[1];
            } else {
                object = (String)fileObject2.getAttribute("SystemFileSystem.localizingBundle");
                object3 = fileObject2.getPath();
            }
            if (object != null) {
                try {
                    object2 = LayerUtils.currentify(LayerUtils.urlForBundle((String)object), string2, classPath);
                    for (int i = 0; i < ((Object[])object2).length; ++i) {
                        InputStream inputStream = ((URL)object2[i]).openStream();
                        try {
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            String string3 = properties.getProperty((String)object3);
                            FileObject fileObject3 = URLMapper.findFileObject((URL)object2[i]);
                            if (fileObject3 != null) {
                                fileObject3.removeFileChangeListener(fileChangeListener);
                                fileObject3.addFileChangeListener(fileChangeListener);
                                fileObject3.getParent().removeFileChangeListener(fileChangeListener);
                                fileObject3.getParent().addFileChangeListener(fileChangeListener);
                            }
                            if (string3 == null) continue;
                            if (fileObject2.getPath().startsWith("Menu/")) {
                                String string4 = Actions.cutAmpersand((String)string3);
                                return string4;
                            }
                            String string5 = string3;
                            return string5;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_no_such_bundle", (Object)string, (Object)object);
                }
            }
            if (fileObject2.hasExt("instance")) {
                return BadgingSupport.getInstanceLabel(fileObject2);
            }
            if (!fileObject2.hasExt("shadow") || (object2 = fileObject2.getAttribute("originalFile")) == null || !(object2 instanceof String)) continue;
            try {
                fileObject = fileObject2.getFileSystem().findResource((String)object2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileObject = null;
            }
            if (fileObject != null && fileObject.hasExt("instance")) return BadgingSupport.annotateNameGeneral((String)object2, Collections.singleton(fileObject), string2, fileChangeListener, classPath);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getInstanceLabel(FileObject fileObject) {
        String string;
        Object object;
        try {
            object = (InstanceCookie)DataObject.find((FileObject)fileObject).getLookup().lookup(InstanceCookie.class);
            if (object != null) {
                Logger logger = Logger.getLogger("org.openide.filesystems");
                Logger logger2 = Logger.getLogger("org.netbeans.core.startup.layers.BinaryFS");
                Level level = logger.getLevel();
                Level level2 = logger2.getLevel();
                logger.setLevel(Level.OFF);
                logger2.setLevel(Level.OFF);
                try {
                    final Object object2 = object.instanceCreate();
                    if (object2 instanceof Action) {
                        String string2 = (String)Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return (String)((Action)object2).getValue("Name");
                            }
                        });
                        if (string2 != null) {
                            String string3 = Actions.cutAmpersand((String)string2);
                            return string3;
                        }
                        String string4 = BadgingSupport.toStringOf(object2);
                        return string4;
                    }
                    if (object2 instanceof Presenter.Menu) {
                        String string5 = (String)Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return ((Presenter.Menu)object2).getMenuPresenter().getText();
                            }
                        });
                        return string5;
                    }
                    if (object2 instanceof JSeparator) {
                        String string6 = NbBundle.getMessage(BadgingSupport.class, (String)"LBL_separator");
                        return string6;
                    }
                    String string7 = BadgingSupport.toStringOf(object2);
                    return string7;
                }
                finally {
                    logger.setLevel(level);
                    logger2.setLevel(level2);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(BadgingSupport.class.getName()).log(Level.FINE, "Ignored exception: (" + exception.getClass().getSimpleName() + ") " + exception.getMessage());
        }
        object = (String)fileObject.getAttribute("instanceClass");
        if (object == null) {
            object = fileObject.getName().replace('-', '.');
        }
        if ((string = (String)fileObject.getAttribute("literal:instanceCreate")) != null && string.startsWith("new:")) {
            object = string.substring("new:".length());
        } else if (string != null && string.startsWith("method:")) {
            String string8 = string.substring(string.lastIndexOf(46, string.lastIndexOf(46) - 1) + 1);
            return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_from", (Object)string8);
        }
        String string9 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
        return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_of", (Object)string9);
    }

    private static String toStringOf(Object object) {
        String string = object.toString();
        if ((object.getClass().getName() + "@" + Integer.toHexString(object.hashCode())).equals(string)) {
            String string2 = object.getClass().getName();
            String string3 = string2.substring(string2.lastIndexOf(46) + 1);
            return NbBundle.getMessage(BadgingSupport.class, (String)"LBL_instance_of", (Object)string3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image annotateIcon(final Image image, int n, final Set<? extends FileObject> set) {
        Map<String, Image> map;
        boolean bl;
        if (n == 1) {
            bl = false;
        } else if (n == 2) {
            bl = true;
        } else {
            return image;
        }
        Map<String, Image> map2 = map = bl ? this.bigIcons : this.smallIcons;
        synchronized (map2) {
            for (FileObject fileObject : set) {
                String string = fileObject.getPath();
                if (!map.containsKey(string)) continue;
                return map.get(string);
            }
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Image image2 = BadgingSupport.this.annotateIconGeneral(image, bl, set);
                Map map2 = map;
                synchronized (map2) {
                    for (FileObject fileObject : set) {
                        map.put(fileObject.getPath(), image2);
                    }
                }
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, set, true, false));
            }
        });
        return image;
    }

    private Image annotateIconGeneral(Image image, boolean bl, Set<? extends FileObject> set) {
        for (FileObject fileObject : set) {
            URL[] uRLArray;
            Object object;
            block8: {
                object = fileObject.getAttribute(bl ? "SystemFileSystem.icon32" : "SystemFileSystem.icon");
                if (object instanceof Image) {
                    return (Image)object;
                }
                if (object == null && (uRLArray = fileObject.getAttribute("iconBase")) instanceof String) {
                    try {
                        object = new URL("nbresloc:/" + uRLArray);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)malformedURLException);
                    }
                }
            }
            if (object == null) continue;
            try {
                uRLArray = LayerUtils.currentify((URL)object, this.suffix, this.classpath);
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRLArray[0]);
                if (fileObject2 != null) {
                    fileObject2.removeFileChangeListener(this.fileChangeListener);
                    fileObject2.addFileChangeListener(this.fileChangeListener);
                }
                return Toolkit.getDefaultToolkit().getImage(uRLArray[0]);
            }
            catch (Exception exception) {
                Util.err.notify(1, (Throwable)exception);
            }
        }
        return image;
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.someFileChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.someFileChange();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.someFileChange();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.someFileChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someFileChange() {
        Map<String, Object> map = this.names;
        synchronized (map) {
            this.names.clear();
        }
        map = this.smallIcons;
        synchronized (map) {
            this.smallIcons.clear();
        }
        map = this.bigIcons;
        synchronized (map) {
            this.bigIcons.clear();
        }
        RP.post(new Runnable(){

            public void run() {
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, true, true));
            }
        });
    }
}

