/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidateConfiguration;
import org.netbeans.modules.xml.wsdl.validator.visitor.ValidationUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateSupport {
    private ValidateConfiguration mValConfig;
    public static final String VAL_MISSING_ATTRIB = "VAL_MISSING_ATTRIB";
    public static final String FIX_MISSING_ATTRIB = "FIX_MISSING_ATTRIB";
    public static final String VAL_NOT_NCNAME_ATTRIB = "VAL_NOT_NCNAME_ATTRIB";
    public static final String FIX_NOT_NCNAME_ATTRIB = "FIX_NOT_NCNAME_ATTRIB";
    public static final String VAL_NOT_QNAME_ATTRIB = "VAL_NOT_QNAME_ATTRIB";
    public static final String FIX_NOT_QNAME_ATTRIB = "FIX_NOT_QNAME_ATTRIB";
    public static final String VAL_PREFIX_NULL_QNAME_ATTRIB = "VAL_PREFIX_NULL_QNAME_ATTRIB";
    public static final String FIX_PREFIX_NULL_QNAME_ATTRIB = "FIX_PREFIX_NULL_QNAME_ATTRIB";
    public static final String VAL_PREFIX_NOT_DEFINED = "VAL_PREFIX_NOT_DEFINED";
    public static final String FIX_PREFIX_NOT_DEFINED = "FIX_PREFIX_NOT_DEFINED";
    public static final String VAL_NOT_BOOLEAN_ATTRIB = "VAL_NOT_BOOLEAN_ATTRIB";
    public static final String FIX_NOT_BOOLEAN_ATTRIB = "FIX_NOT_BOOLEAN_ATTRIB";
    public static final String VAL_NOT_ENUM_ATTRIB = "VAL_NOT_ENUM_ATTRIB";
    public static final String FIX_NOT_ENUM_ATTRIB = "FIX_NOT_ENUM_ATTRIB";
    public static final String VAL_MIN_ELEM_NOT_MET = "VAL_MIN_ELEM_NOT_MET";
    public static final String FIX_MIN_ELEM_NOT_MET = "FIX_MIN_ELEM_NOT_MET";
    public static final String VAL_MISSING_ELEM = "VAL_MISSING_ELEM";
    public static final String FIX_MISSING_ELEM = "FIX_MISSING_ELEM";
    public static final String VAL_MATCHING_WSDL_NOT_FOUND = "VAL_MATCHING_WSDL_NOT_FOUND";
    public static final String FIX_MATCHING_WSDL_NOT_FOUND = "FIX_MATCHING_WSDL_NOT_FOUND";
    public static final String VAL_COMPENSATE_WITH_AN_INVALID_SCOPE = "VAL_COMPENSATE_WITH_AN_INVALID_SCOPE";
    public static final String FIX_COMPENSATE_WITH_AN_INVALID_SCOPE = "FIX_COMPENSATE_WITH_AN_INVALID_SCOPE";
    public static final String VAL_MESSAGETYPE_IN_CONTAINER = "VAL_MESSAGETYPE_IN_CONTAINER";
    public static final String FIX_MESSAGETYPE_IN_CONTAINER = "FIX_MESSAGETYPE_IN_CONTAINER";
    public static final String VAL_UNKNOWN_CONTAINER_IN_CATCH = "VAL_UNKNOWN_CONTAINER_IN_CATCH";
    public static final String FIX_UNKNOWN_CONTAINER_IN_CATCH = "FIX_UNKNOWN_CONTAINER_IN_CATCH";
    public static final String VAL_EMPTY_CONTAINER_IN_CATCH = "VAL_EMPTY_CONTAINER_IN_CATCH";
    public static final String SEQUENCE_TITLE_NAME = "SEQUENCE_TITLE_NAME";
    public static final String VAL_MISSING_CONNECTIONS = "VAL_MISSING_CONNECTIONS";
    public static final String FIX_MISSING_CONNECTIONS = "FIX_MISSING_CONNECTIONS";
    public static final String VAL_SEMANTICALLY_CORRECT_CORRELATION_SET = "VAL_SEMANTICALLY_CORRECT_CORRELATION_SET";
    public static final String FIX_SEMANTICALLY_CORRECT_CORRELATION_SET = "FIX_SEMANTICALLY_CORRECT_CORRELATION_SET";
    public static final String VAL_FAULT_NAME_CANNOT_BE_EMPTY = "VAL_FAULT_NAME_CANNOT_BE_EMPTY";
    public static final String FIX_FAULT_NAME_CANNOT_BE_EMPTY = "FIX_FAULT_NAME_CANNOT_BE_EMPTY";
    public static final String VAL_UNKNOWN_OPERATION = "VAL_UNKNOWN_OPERATION";
    public static final String FIX_UNKNOWN_OPERATION = "FIX_UNKNOWN_OPERATION";
    public static final String VAL_UNKNOWN_PORT_TYPE = "VAL_UNKNOWN_PORT_TYPE";
    public static final String FIX_UNKNOWN_PORT_TYPE = "FIX_UNKNOWN_PORT_TYPE";
    public static final String VAL_ASSIGN_MUST_HAVE_MINIMUM = "VAL_ASSIGN_MUST_HAVE_MINIMUM";
    public static final String FIX_ASSIGN_MUST_HAVE_MINIMUM = "FIX_ASSIGN_MUST_HAVE_MINIMUM";
    public static final String VAL_FOR_EACH_MUST_HAVE_MIN_ONE_COPY = "VAL_FOR_EACH_MUST_HAVE_MIN_ONE_COPY";
    public static final String FIX_FOR_EACH_MUST_HAVE_MIN_ONE_COPY = "FIX_FOR_EACH_MUST_HAVE_MIN_ONE_COPY";
    public static final String VAL_EMPTY_SCOPE = "VAL_EMPTY_SCOPE";
    public static final String FIX_EMPTY_SCOPE = "FIX_EMPTY_SCOPE";
    public static final String VAL_EMPTY_WHILE = "VAL_EMPTY_WHILE";
    public static final String FIX_EMPTY_WHILE = "FIX_EMPTY_WHILE";
    public static final String VAL_EMPTY_COMPENSATION_HANDLER = "VAL_EMPTY_COMPENSATION_HANDLER";
    public static final String FIX_EMPTY_COMPENSATION_HANDLER = "FIX_EMPTY_COMPENSATION_HANDLER";
    public static final String VAL_EMPTY_CATCH = "VAL_EMPTY_CATCH";
    public static final String FIX_EMPTY_CATCH = "FIX_EMPTY_CATCH";
    public static final String VAL_EMPTY_CATCHALL = "VAL_EMPTY_CATCHALL";
    public static final String FIX_EMPTY_CATCHALL = "FIX_EMPTY_CATCHALL";
    public static final String VAL_NO_EINSIGHT_LICENSE_W_EVISION = "VAL_NO_EINSIGHT_LICENSE_W_EVISION";
    public static final String FIX_NO_EINSIGHT_LICENSE_W_EVISION = "FIX_NO_EINSIGHT_LICENSE_W_EVISION";
    private Collection<Validator.ResultItem> mResultItems;
    private Validator mValidator;

    public ValidateSupport(ValidateConfiguration validateConfiguration) {
        this.mValConfig = validateConfiguration;
    }

    public ValidateConfiguration getValidateConfiguration() {
        return this.mValConfig;
    }

    public void setValidateConfiguration(ValidateConfiguration validateConfiguration) {
        this.mValConfig = validateConfiguration;
    }

    public void setResultItems(Collection<Validator.ResultItem> collection) {
        this.mResultItems = collection;
    }

    public void setValidator(Validator validator) {
        this.mValidator = validator;
    }

    public static boolean isAttributeAbsent(String string) {
        return null == string || string.trim().length() == 0;
    }

    public boolean assertRequiredAttrib(String string, String string2, Component component) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.required")) {
            return true;
        }
        if (ValidateSupport.isAttributeAbsent(string)) {
            return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ATTRIB, (Object)string2), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ATTRIB, (Object)string2));
        }
        return true;
    }

    public boolean assertRequiredAttrib(QName qName, String string, Component component, int n) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.required")) {
            return true;
        }
        if (qName == null || ValidateSupport.isAttributeAbsent(qName.toString())) {
            return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ATTRIB, (Object)string), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ATTRIB, (Object)string));
        }
        return true;
    }

    public boolean assertNCNameAttrib(String string, String string2, Component component) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.ncname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(string) && !ValidationUtils.isNCName(string)) {
            return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_NCNAME_ATTRIB, (Object)string2), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_NCNAME_ATTRIB, (Object)string2));
        }
        return true;
    }

    public boolean assertQNameListAttrib(String string, String string2, Component component, int n) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.qname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                if (this.assertQNameAttrib(stringTokenizer.nextToken(), string2, component, n)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean assertQNameAttrib(QName qName, String string, Component component, int n) {
        if (qName != null) {
            return this.assertQNameAttrib(qName.toString(), string, component, n);
        }
        return true;
    }

    public boolean assertQNameAttrib(String string, String string2, Component component, int n) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.qname")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(string)) {
            String string3;
            String string4;
            if (!ValidationUtils.isQName(string) && !this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_QNAME_ATTRIB, (Object)string2), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_QNAME_ATTRIB, (Object)string2))) {
                return false;
            }
            String[] stringArray = string.split(":");
            if (stringArray != null && stringArray.length > 1 && (string4 = stringArray[0]) != null && null == (string3 = ((AbstractDocumentComponent)component).lookupNamespaceURI(string4)) && !this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_PREFIX_NOT_DEFINED, (Object)string4), NbBundle.getMessage(ValidateSupport.class, (String)FIX_PREFIX_NOT_DEFINED, (Object)string4))) {
                return false;
            }
        }
        return true;
    }

    public boolean assertQNameAttrib(String string, String string2, Component component, int n, boolean bl) {
        String string3;
        String[] stringArray;
        boolean bl2 = this.assertQNameAttrib(string, string2, component, n);
        return !bl2 || !bl || (stringArray = string.split(":")) == null || stringArray.length <= 1 || (string3 = stringArray[0]) != null && !"".equals(string3.trim()) || this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_PREFIX_NULL_QNAME_ATTRIB, (Object)string2), NbBundle.getMessage(ValidateSupport.class, (String)FIX_PREFIX_NULL_QNAME_ATTRIB, (Object)string2));
    }

    public boolean assertBooleanAttrib(String string, String string2, Component component, int n) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.boolean")) {
            return true;
        }
        if (!(ValidateSupport.isAttributeAbsent(string) || string.equals("yes") || string.equals("no"))) {
            return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_BOOLEAN_ATTRIB, (Object)string2), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_BOOLEAN_ATTRIB, (Object)string2));
        }
        return true;
    }

    public boolean assertMinimumElem(int n, int n2, String string, Component component, int n3) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.elem.min")) {
            return true;
        }
        if (n < n2) {
            return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MIN_ELEM_NOT_MET, (Object)n2, (Object)string, (Object)n), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MIN_ELEM_NOT_MET, (Object)(n2 - n), (Object)string));
        }
        return true;
    }

    public boolean assertEnumeratedAttrib(String string, String[] stringArray, String string2, Component component, int n) {
        if (component instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.attrib.enumerated")) {
            return true;
        }
        if (!ValidateSupport.isAttributeAbsent(string) && stringArray != null && stringArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!ValidationUtils.areEqualXMLValues(string, stringArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringArray[i]);
                }
                return this.fireToDo(Validator.ResultType.ERROR, component, NbBundle.getMessage(ValidateSupport.class, (String)VAL_NOT_ENUM_ATTRIB, (Object)string2, (Object)stringBuffer.toString()), NbBundle.getMessage(ValidateSupport.class, (String)FIX_NOT_ENUM_ATTRIB, (Object)stringBuffer.toString(), (Object)string2));
            }
        }
        return true;
    }

    public boolean assertRequiredElement(Component component, String string, Component component2, int n) {
        if (component2 instanceof WSDLComponent && !this.mValConfig.getBooleanProperty("wsdl.syntax.elem.required")) {
            return true;
        }
        if (null == component) {
            return this.fireToDo(Validator.ResultType.ERROR, component2, NbBundle.getMessage(ValidateSupport.class, (String)VAL_MISSING_ELEM, (Object)string), NbBundle.getMessage(ValidateSupport.class, (String)FIX_MISSING_ELEM, (Object)string));
        }
        return true;
    }

    public boolean fireToDo(Validator.ResultType resultType, Component component, String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            string3 = string + " : " + string2;
        }
        Validator.ResultItem resultItem = new Validator.ResultItem(this.mValidator, resultType, component, string3);
        this.mResultItems.add(resultItem);
        return true;
    }
}

