/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesModel
implements PropertyChangeListener {
    public static final LibraryStorageArea GLOBAL_AREA = new LibraryStorageArea(){

        public String getDisplayName() {
            return NbBundle.getMessage(LibrariesModel.class, (String)"LBL_global");
        }

        public URL getLocation() {
            throw new AssertionError();
        }
    };
    private static final Logger LOG = Logger.getLogger(LibrariesModel.class.getName());
    public static final Set<URL> createdAreas = Collections.synchronizedSet(new HashSet());
    private final Map<LibraryImplementation, LibraryStorageArea> library2Area = new HashMap<LibraryImplementation, LibraryStorageArea>();
    private final Map<LibraryStorageArea, ArealLibraryProvider> area2Storage = new HashMap<LibraryStorageArea, ArealLibraryProvider>();
    private final Map<LibraryImplementation, LibraryProvider> storageByLib = new HashMap<LibraryImplementation, LibraryProvider>();
    private final Map<LibraryStorageArea, LibraryProvider> area2Provider = new HashMap<LibraryStorageArea, LibraryProvider>();
    private final Collection<LibraryImplementation> actualLibraries = new TreeSet<LibraryImplementation>(new LibrariesComparator());
    private final List<LibraryImplementation> addedLibraries;
    private final List<LibraryImplementation> removedLibraries;
    private final List<ProxyLibraryImplementation> changedLibraries;
    private WritableLibraryProvider writableProvider;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public LibrariesModel() {
        this.addedLibraries = new ArrayList<LibraryImplementation>();
        this.removedLibraries = new ArrayList<LibraryImplementation>();
        this.changedLibraries = new ArrayList<ProxyLibraryImplementation>();
        for (Object object : Lookup.getDefault().lookupAll(LibraryProvider.class)) {
            object.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
            if (this.writableProvider != null || !(object instanceof WritableLibraryProvider)) continue;
            this.writableProvider = (WritableLibraryProvider)object;
        }
        for (Object object : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            object.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
        }
        this.computeLibraries();
    }

    public synchronized Collection<? extends LibraryImplementation> getLibraries() {
        return this.actualLibraries;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public LibraryStorageArea createArea() {
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            Object a = arealLibraryProvider.createArea();
            if (a == null) continue;
            createdAreas.add(a.getLocation());
            this.area2Storage.put((LibraryStorageArea)a, arealLibraryProvider);
            this.propertyChange(null);
            return a;
        }
        return null;
    }

    public LibraryImplementation createArealLibrary(String string, String string2, LibraryStorageArea libraryStorageArea) {
        DummyArealLibrary dummyArealLibrary = new DummyArealLibrary(string, string2);
        this.library2Area.put(dummyArealLibrary, libraryStorageArea);
        return dummyArealLibrary;
    }

    public Collection<? extends LibraryStorageArea> getAreas() {
        HashSet<LibraryStorageArea> hashSet = new HashSet<LibraryStorageArea>();
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (LibraryStorageArea object : LibraryAccessor.getOpenAreas(arealLibraryProvider)) {
                this.area2Storage.put(object, arealLibraryProvider);
                hashSet.add(object);
            }
        }
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (URL uRL : createdAreas) {
                Object a = arealLibraryProvider.loadArea(uRL);
                if (a == null) continue;
                assert (a.getLocation().equals(uRL)) : "Bad location " + a.getLocation() + " does not match " + uRL + " from " + arealLibraryProvider.getClass().getName();
                this.area2Storage.put((LibraryStorageArea)a, arealLibraryProvider);
                hashSet.add((LibraryStorageArea)a);
            }
        }
        return hashSet;
    }

    public LibraryStorageArea getArea(LibraryImplementation libraryImplementation) {
        LibraryStorageArea libraryStorageArea = this.getAreaOrNull(libraryImplementation);
        return libraryStorageArea != null ? libraryStorageArea : GLOBAL_AREA;
    }

    private LibraryStorageArea getAreaOrNull(LibraryImplementation libraryImplementation) {
        if (libraryImplementation instanceof ProxyLibraryImplementation) {
            libraryImplementation = ((ProxyLibraryImplementation)libraryImplementation).getOriginal();
        }
        return this.library2Area.get(libraryImplementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibrary(LibraryImplementation libraryImplementation) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            this.addedLibraries.add(libraryImplementation);
            this.actualLibraries.add(libraryImplementation);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLibrary(LibraryImplementation libraryImplementation) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            if (this.addedLibraries.contains(libraryImplementation)) {
                this.addedLibraries.remove(libraryImplementation);
            } else {
                this.removedLibraries.add(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
            }
            this.actualLibraries.remove(libraryImplementation);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLibrary(ProxyLibraryImplementation proxyLibraryImplementation) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            if (!this.addedLibraries.contains(proxyLibraryImplementation) && !this.changedLibraries.contains(proxyLibraryImplementation)) {
                this.changedLibraries.add(proxyLibraryImplementation);
            }
        }
        this.cs.fireChange();
    }

    public boolean isLibraryEditable(LibraryImplementation libraryImplementation) {
        if (this.addedLibraries.contains(libraryImplementation)) {
            return true;
        }
        LibraryProvider libraryProvider = this.storageByLib.get(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
        return libraryProvider == this.writableProvider || this.getAreaOrNull(libraryImplementation) != null;
    }

    public void apply() throws IOException {
        Object object;
        Object object2;
        for (LibraryImplementation libraryImplementation : this.removedLibraries) {
            object2 = this.storageByLib.get(libraryImplementation);
            if (object2 == this.writableProvider) {
                this.writableProvider.removeLibrary(libraryImplementation);
                continue;
            }
            assert (libraryImplementation instanceof LibraryImplementation2);
            object = this.getAreaOrNull(libraryImplementation);
            if (object != null) {
                LibraryAccessor.remove(this.area2Storage.get(object), (LibraryImplementation2)libraryImplementation);
                continue;
            }
            throw new IOException("Cannot find storage for library: " + libraryImplementation.getName());
        }
        for (LibraryImplementation libraryImplementation : this.addedLibraries) {
            object2 = this.getAreaOrNull(libraryImplementation);
            if (object2 != null) {
                object = this.area2Storage.get(object2);
                assert (object != null) : object2;
                LibraryAccessor.createLibrary((ArealLibraryProvider)object, libraryImplementation.getType(), libraryImplementation.getName(), (LibraryStorageArea)object2, ((DummyArealLibrary)libraryImplementation).contents);
                continue;
            }
            if (this.writableProvider != null) {
                this.writableProvider.addLibrary(libraryImplementation);
                continue;
            }
            throw new IOException("Cannot add libraries, no WritableLibraryProvider.");
        }
        for (ProxyLibraryImplementation proxyLibraryImplementation : this.changedLibraries) {
            object2 = proxyLibraryImplementation.getOriginal();
            object = this.storageByLib.get(object2);
            if (object == this.writableProvider) {
                this.writableProvider.updateLibrary((LibraryImplementation)object2, proxyLibraryImplementation);
                continue;
            }
            LibraryStorageArea libraryStorageArea = this.library2Area.get(object2);
            if (libraryStorageArea != null) {
                if (proxyLibraryImplementation instanceof ProxyLibraryImplementation.ProxyLibraryImplementation2) {
                    ProxyLibraryImplementation.ProxyLibraryImplementation2 proxyLibraryImplementation2 = (ProxyLibraryImplementation.ProxyLibraryImplementation2)proxyLibraryImplementation;
                    LibraryImplementation2 libraryImplementation2 = proxyLibraryImplementation2.getOriginal2();
                    if (proxyLibraryImplementation2.newURIContents == null) continue;
                    for (Map.Entry<String, List<URI>> entry : proxyLibraryImplementation2.newURIContents.entrySet()) {
                        libraryImplementation2.setURIContent(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (proxyLibraryImplementation.newContents == null) continue;
                for (Map.Entry entry : proxyLibraryImplementation.newContents.entrySet()) {
                    object2.setContent((String)entry.getKey(), (List)entry.getValue());
                }
                continue;
            }
            throw new IOException("Cannot find storage for library: " + object2.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LibrariesModel.this.computeLibraries();
                LibrariesModel.this.cs.fireChange();
            }
        });
    }

    private ProxyLibraryImplementation findModified(LibraryImplementation libraryImplementation) {
        for (ProxyLibraryImplementation proxyLibraryImplementation : this.changedLibraries) {
            if (!proxyLibraryImplementation.getOriginal().equals(libraryImplementation)) continue;
            return proxyLibraryImplementation;
        }
        return null;
    }

    private synchronized void computeLibraries() {
        this.actualLibraries.clear();
        for (LibraryProvider object : Lookup.getDefault().lookupAll(LibraryProvider.class)) {
            for (LibraryImplementation libraryImplementation : object.getLibraries()) {
                ProxyLibraryImplementation proxyLibraryImplementation = this.findModified(libraryImplementation);
                if (proxyLibraryImplementation != null) {
                    this.actualLibraries.add(proxyLibraryImplementation);
                } else {
                    proxyLibraryImplementation = ProxyLibraryImplementation.createProxy(libraryImplementation, this);
                    this.actualLibraries.add(proxyLibraryImplementation);
                }
                this.storageByLib.put(libraryImplementation, object);
                LOG.log(Level.FINER, "computeLibraries: storage={0} lib={1} proxy={2}", new Object[]{object, libraryImplementation, proxyLibraryImplementation});
            }
        }
        for (LibraryStorageArea libraryStorageArea : this.getAreas()) {
            ArealLibraryProvider arealLibraryProvider = this.area2Storage.get(libraryStorageArea);
            assert (arealLibraryProvider != null) : libraryStorageArea;
            LibraryProvider libraryProvider = this.area2Provider.get(libraryStorageArea);
            if (libraryProvider == null) {
                libraryProvider = LibraryAccessor.getLibraries(arealLibraryProvider, libraryStorageArea);
                libraryProvider.addPropertyChangeListener(this);
                this.area2Provider.put(libraryStorageArea, libraryProvider);
            }
            for (LibraryImplementation libraryImplementation : libraryProvider.getLibraries()) {
                ProxyLibraryImplementation proxyLibraryImplementation = this.findModified(libraryImplementation);
                if (proxyLibraryImplementation != null) {
                    this.actualLibraries.add(proxyLibraryImplementation);
                } else {
                    proxyLibraryImplementation = ProxyLibraryImplementation.createProxy(libraryImplementation, this);
                    this.actualLibraries.add(proxyLibraryImplementation);
                }
                this.library2Area.put(libraryImplementation, libraryStorageArea);
                LOG.log(Level.FINER, "computeLibraries: alp={0} area={1} lib={2} proxy={3}", new Object[]{arealLibraryProvider, libraryStorageArea, libraryImplementation, proxyLibraryImplementation});
            }
        }
        this.actualLibraries.addAll(this.addedLibraries);
        LOG.log(Level.FINE, "computeLibraries: actualLibraries={0} library2Area={1}", new Object[]{this.actualLibraries, this.library2Area});
    }

    public static List<URL> convertURIsToURLs(List<URI> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URI uRI : list) {
            try {
                arrayList.add(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList;
    }

    public static List<URI> convertURLsToURIs(List<URL> list) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (URL uRL : list) {
            arrayList.add(URI.create(uRL.toExternalForm()));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyArealLibrary
    implements LibraryImplementation2 {
        private final String type;
        private final String name;
        final Map<String, List<URI>> contents = new HashMap<String, List<URI>>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public DummyArealLibrary(String string, String string2) {
            this.type = string;
            this.name = string2;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getLocalizingBundle() {
            return null;
        }

        @Override
        public List<URL> getContent(String string) throws IllegalArgumentException {
            return LibrariesModel.convertURIsToURLs(this.getURIContent(string));
        }

        @Override
        public List<URI> getURIContent(String string) throws IllegalArgumentException {
            List<URI> list = this.contents.get(string);
            if (list != null) {
                return list;
            }
            return Collections.emptyList();
        }

        @Override
        public void setName(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDescription(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLocalizingBundle(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void setContent(String string, List<URL> list) throws IllegalArgumentException {
            this.setURIContent(string, LibrariesModel.convertURLsToURIs(list));
        }

        @Override
        public void setURIContent(String string, List<URI> list) throws IllegalArgumentException {
            this.contents.put(string, list);
            this.pcs.firePropertyChange("content", null, null);
        }

        public String toString() {
            return "DummyArealLibrary[" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibrariesComparator
    implements Comparator<LibraryImplementation> {
        private LibrariesComparator() {
        }

        @Override
        public int compare(LibraryImplementation libraryImplementation, LibraryImplementation libraryImplementation2) {
            String string;
            String string2 = LibrariesCustomizer.getLocalizedName(libraryImplementation);
            int n = string2.compareToIgnoreCase(string = LibrariesCustomizer.getLocalizedName(libraryImplementation2));
            return n != 0 ? n : System.identityHashCode(libraryImplementation) - System.identityHashCode(libraryImplementation2);
        }
    }
}

