/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.nodes.Node;

public class BugzillaQuery
extends Query {
    private String name;
    private final BugzillaRepository repository;
    protected QueryController controller;
    private final Set<String> issues = new HashSet<String>();
    private Set<String> archivedIssues = new HashSet<String>();
    protected String urlParameters;
    private boolean initialUrlDef;
    private boolean firstRun = true;
    private ColumnDescriptor[] columnDescriptors;

    public BugzillaQuery(BugzillaRepository bugzillaRepository) {
        this(null, bugzillaRepository, null, false, false, true);
    }

    public BugzillaQuery(String string, BugzillaRepository bugzillaRepository, String string2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        this.repository = bugzillaRepository;
        this.saved = bl;
        this.name = string;
        this.urlParameters = string2;
        this.initialUrlDef = bl2;
        this.setLastRefresh(bugzillaRepository.getIssueCache().getQueryTimestamp(this.getStoredQueryName()));
        if (bl3) {
            this.controller = this.createControler(bugzillaRepository, this, string2);
        }
        if (bugzillaRepository instanceof KenaiRepository && (bl4 = BugzillaConfig.getInstance().getQueryAutoRefresh(this.getDisplayName()))) {
            this.getRepository().scheduleForRefresh(this);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " - " + this.repository.getDisplayName();
    }

    public synchronized QueryController getController() {
        if (this.controller == null) {
            this.controller = this.createControler(this.repository, this, this.urlParameters);
        }
        return this.controller;
    }

    public BugzillaRepository getRepository() {
        return this.repository;
    }

    protected QueryController createControler(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery, String string) {
        return new QueryController(bugzillaRepository, bugzillaQuery, string, this.initialUrlDef);
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = BugzillaIssue.getColumnDescriptors(this.repository);
        }
        return this.columnDescriptors;
    }

    public boolean refresh() {
        return this.refreshIntern(false);
    }

    boolean refreshIntern(final boolean bl) {
        assert (this.urlParameters != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final boolean[] blArray = new boolean[1];
        this.executeQuery(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet<String> hashSet;
                block7: {
                    Bugzilla.LOG.log(Level.FINE, "refresh start - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    try {
                        hashSet = new HashSet<String>();
                        BugzillaQuery.this.issues.clear();
                        BugzillaQuery.this.archivedIssues.clear();
                        if (BugzillaQuery.this.isSaved()) {
                            if (!BugzillaQuery.this.wasRun() && BugzillaQuery.this.issues.size() != 0) {
                                Bugzilla.LOG.warning("query " + BugzillaQuery.this.getDisplayName() + " supposed to be run for the first time yet already contains issues.");
                                assert (false);
                            }
                            hashSet.addAll(BugzillaQuery.this.repository.getIssueCache().readQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            hashSet.addAll(BugzillaQuery.this.repository.getIssueCache().readArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            BugzillaQuery.this.archivedIssues.addAll(hashSet);
                        }
                        BugzillaQuery.this.firstRun = false;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("/buglist.cgi?query_format=advanced");
                        stringBuffer.append(BugzillaQuery.this.urlParameters);
                        PerformQueryCommand performQueryCommand = new PerformQueryCommand(BugzillaQuery.this.repository, stringBuffer.toString(), new IssuesIdCollector());
                        BugzillaQuery.this.repository.getExecutor().execute(performQueryCommand, !bl);
                        blArray[0] = performQueryCommand.hasFailed();
                        if (!blArray[0]) break block7;
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), bl);
                    }
                    catch (Throwable throwable) {
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), bl);
                        Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                        throw throwable;
                    }
                    Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    return;
                }
                BugzillaQuery.this.archivedIssues.removeAll(BugzillaQuery.this.issues);
                if (BugzillaQuery.this.isSaved()) {
                    BugzillaQuery.this.repository.getIssueCache().storeQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.issues.toArray(new String[BugzillaQuery.this.issues.size()]));
                    BugzillaQuery.this.repository.getIssueCache().storeArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.archivedIssues.toArray(new String[BugzillaQuery.this.archivedIssues.size()]));
                }
                hashSet.addAll(BugzillaQuery.this.issues);
                GetMultiTaskDataCommand getMultiTaskDataCommand = new GetMultiTaskDataCommand(BugzillaQuery.this.repository, hashSet, new IssuesCollector());
                BugzillaQuery.this.repository.getExecutor().execute(getMultiTaskDataCommand, !bl);
                blArray[0] = getMultiTaskDataCommand.hasFailed();
                BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), bl);
                Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
            }
        });
        return blArray[0];
    }

    public String getStoredQueryName() {
        return this.getDisplayName();
    }

    protected void logQueryEvent(int n, boolean bl) {
        BugtrackingUtil.logQueryEvent((String)BugzillaConnector.getConnectorName(), (String)this.name, (int)n, (boolean)false, (boolean)bl);
    }

    void refresh(String string, boolean bl) {
        assert (string != null);
        this.urlParameters = string;
        this.refreshIntern(bl);
    }

    void remove() {
        this.repository.removeQuery(this);
        this.fireQueryRemoved();
    }

    public int getIssueStatus(Issue issue) {
        String string = issue.getID();
        return this.getIssueStatus(string);
    }

    public boolean contains(Issue issue) {
        return this.issues.contains(issue.getID());
    }

    public Node[] getSelection() {
        return super.getSelection();
    }

    public int getIssueStatus(String string) {
        return this.repository.getIssueCache().getStatus(string);
    }

    int getSize() {
        return this.issues.size();
    }

    public String getUrlParameters() {
        return this.getController().getUrlParameters();
    }

    public boolean isUrlDefined() {
        return this.getController().isUrlDefined();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSaved(boolean bl) {
        super.setSaved(bl);
    }

    public void setFilter(Filter filter) {
        this.getController().selectFilter(filter);
    }

    public void fireQuerySaved() {
        super.fireQuerySaved();
        this.repository.fireQueryListChanged();
    }

    public void fireQueryRemoved() {
        super.fireQueryRemoved();
        this.repository.fireQueryListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue[] getIssues(int n) {
        if (this.issues == null) {
            return new Issue[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = this.issues;
        synchronized (set) {
            arrayList.addAll(this.issues);
        }
        set = this.repository.getIssueCache();
        ArrayList<Issue> arrayList2 = new ArrayList<Issue>();
        for (String string : arrayList) {
            int n2 = this.getIssueStatus(string);
            if ((n2 & n) == 0) continue;
            arrayList2.add(set.getIssue(string));
        }
        return arrayList2.toArray(new Issue[arrayList2.size()]);
    }

    boolean wasRun() {
        return !this.firstRun;
    }

    private class IssuesCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            BugzillaIssue bugzillaIssue;
            String string = BugzillaIssue.getID(taskData);
            try {
                IssueCache<TaskData> issueCache = BugzillaQuery.this.repository.getIssueCache();
                bugzillaIssue = (BugzillaIssue)issueCache.setIssueData(string, (Object)taskData);
            }
            catch (IOException iOException) {
                Bugzilla.LOG.log(Level.SEVERE, null, iOException);
                return;
            }
            BugzillaQuery.this.fireNotifyData(bugzillaIssue);
        }
    }

    private class IssuesIdCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            String string = BugzillaIssue.getID(taskData);
            BugzillaQuery.this.issues.add(string);
        }
    }
}

